# Generated by Django 3.2.9 on 2021-11-19 16:52

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="UserHandle",
            fields=[
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="webauthn_user_handle",
                        serialize=False,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "handle",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Unqiue user handle to be used to map users to their Webauthn credentials, only set if user has registered one or more security keys. Will be unique random 64 bytes",
                        max_length=255,
                        null=True,
                        unique=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "Webauthn User Handle",
                "verbose_name_plural": "Webauthn User Handles",
                "db_table": "security_keys_user_handle",
            },
        ),
        migrations.CreateModel(
            name="SecurityKeyDevice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The human-readable name of this device.",
                        max_length=64,
                    ),
                ),
                (
                    "confirmed",
                    models.BooleanField(
                        default=True, help_text="Is this device ready for use?"
                    ),
                ),
                (
                    "throttling_failure_timestamp",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        help_text="A timestamp of the last failed verification attempt. Null if last attempt succeeded.",
                        null=True,
                    ),
                ),
                (
                    "throttling_failure_count",
                    models.PositiveIntegerField(
                        default=0, help_text="Number of successive failed attempts."
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="The user that this device belongs to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Webauthn Security Key 2FA Device",
                "verbose_name_plural": "Webauthn Security Key 2FA Devices",
                "db_table": "security_keys_2fa_device",
            },
        ),
        migrations.CreateModel(
            name="SecurityKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Security key name", max_length=255, null=True
                    ),
                ),
                (
                    "credential_id",
                    models.CharField(db_index=True, max_length=255, unique=True),
                ),
                ("credential_public_key", models.TextField()),
                ("sign_count", models.PositiveIntegerField(default=0)),
                ("type", models.CharField(max_length=64)),
                (
                    "passwordless_login",
                    models.BooleanField(
                        default=False,
                        help_text="User has enabled this key for passwordless login",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="webauthn_security_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Webauthn Security Key",
                "verbose_name_plural": "Webauthn Security Keys",
                "db_table": "security_keys_security_key",
            },
        ),
    ]
