#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import re
import sys

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


def get_version(*file_paths):
    """Retrieves the version from django_better_admin_arrayfield/__init__.py"""
    filename = os.path.join(os.path.dirname(__file__), *file_paths)
    version_file = open(filename).read()
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]", version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")


version = get_version("django_better_admin_arrayfield", "__init__.py")


if sys.argv[-1] == "publish":
    try:
        import wheel

        print("Wheel version: ", wheel.__version__)
    except ImportError:
        print('Wheel library missing. Please run "pip install wheel"')
        sys.exit()
    os.system("python setup.py sdist upload")
    os.system("python setup.py bdist_wheel upload")
    sys.exit()

if sys.argv[-1] == "tag":
    print("Tagging the version on git:")
    os.system("git tag -a %s -m 'version %s'" % (version, version))
    os.system("git push --tags")
    sys.exit()

with open("README.md") as f:
    readme = f.read()
with open("HISTORY.md") as f:
    history = f.read().replace(".. :changelog:", "")

setup(
    name="django-better-admin-arrayfield",
    version=version,
    description="""Better ArrayField widget for admin""",
    long_description=readme + "\n\n" + history,
    long_description_content_type="text/markdown",
    author="Jakub Semik",
    author_email="kuba.semik@gmail.com",
    url="https://github.com/gradam/django-better-admin-arrayfield",
    packages=["django_better_admin_arrayfield"],
    include_package_data=True,
    install_requires=[],
    license="MIT",
    zip_safe=False,
    keywords="django-better-admin-arrayfield",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Framework :: Django :: 3.1",
        "Framework :: Django :: 3.0",
        "Framework :: Django :: 2.2",
        "Framework :: Django :: 2.1",
        "Framework :: Django :: 2.0",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
)
