"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAutoRollbackConfiguration = exports.renderAlarmConfiguration = exports.arnForDeploymentConfig = exports.arnForDeploymentGroup = exports.arnForApplication = void 0;
const core_1 = require("@aws-cdk/core");
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                'at least one CloudWatch alarm with the Deployment Group');
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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