import * as elb from '@aws-cdk/aws-elasticloadbalancing';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
/**
 * The generations of AWS load balancing solutions.
 *
 * @stability stable
 */
export declare enum LoadBalancerGeneration {
    /**
     * The first generation (ELB Classic).
     *
     * @stability stable
     */
    FIRST = 0,
    /**
     * The second generation (ALB and NLB).
     *
     * @stability stable
     */
    SECOND = 1
}
/**
 * An interface of an abstract load balancer, as needed by CodeDeploy.
 *
 * Create instances using the static factory methods:
 * {@link #classic}, {@link #application} and {@link #network}.
 *
 * @stability stable
 */
export declare abstract class LoadBalancer {
    /**
     * Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     *
     * @param loadBalancer a classic ELB Load Balancer.
     * @stability stable
     */
    static classic(loadBalancer: elb.LoadBalancer): LoadBalancer;
    /**
     * Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     *
     * @param albTargetGroup an ALB Target Group.
     * @stability stable
     */
    static application(albTargetGroup: elbv2.ApplicationTargetGroup): LoadBalancer;
    /**
     * Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     *
     * @param nlbTargetGroup an NLB Target Group.
     * @stability stable
     */
    static network(nlbTargetGroup: elbv2.NetworkTargetGroup): LoadBalancer;
    /**
     * @stability stable
     */
    abstract readonly generation: LoadBalancerGeneration;
    /**
     * @stability stable
     */
    abstract readonly name: string;
}
