/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ClientProfile
extends Properties {
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";

    public ClientProfile() {
    }

    public ClientProfile(Properties properties) {
        if (properties.containsKey("oracle.net.profile")) {
            this.put("oracle.net.profile", properties.getProperty("oracle.net.profile"));
        }
        this.put("oracle.net.authentication_services", properties.getProperty("oracle.net.authentication_services", "()"));
        this.put("oracle.net.encryption_client", properties.getProperty("oracle.net.encryption_client", "ACCEPTED"));
        this.put("oracle.net.encryption_types_client", properties.getProperty("oracle.net.encryption_types_client", "()"));
        this.put("oracle.net.crypto_checksum_client", properties.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
        this.put("oracle.net.crypto_checksum_types_client", properties.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        this.put("oracle.net.crypto_seed", properties.getProperty("oracle.net.crypto_seed", ""));
        String string = properties.getProperty("oracle.net.KerberosRealm");
        if (string != null) {
            this.put("oracle.net.KerberosRealm", string);
        }
        this.put("oracle.net.kerberos5_mutual_authentication", properties.getProperty("oracle.net.kerberos5_mutual_authentication", "false"));
        if (properties.getProperty("oracle.net.kerberos5_cc_name") != null) {
            this.put("oracle.net.kerberos5_cc_name", properties.getProperty("oracle.net.kerberos5_cc_name"));
        }
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)this.get("oracle.net.authentication_services"));
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)this.get("oracle.net.encryption_types_client"));
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)this.get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)this.get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String getDataIntegrityLevel() {
        return (String)this.get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> enumeration = this.propertyNames();
        System.out.println("Enumeration has elements ? " + enumeration.hasMoreElements());
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Key " + n2 + " = " + string);
            System.out.println("Value = " + this.getProperty(string));
            ++n2;
        }
        System.out.println(" ----------------------------------------");
    }

    private String[] getServices(String string) {
        String string2 = this.removeParenths(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    private String removeParenths(String string) {
        int n2 = string.indexOf(40);
        int n3 = n2 == -1 ? 0 : n2 + 1;
        int n4 = string.lastIndexOf(41);
        int n5 = n4 == -1 ? string.length() : n4;
        String string2 = string.substring(n3, n5);
        return string2.trim();
    }

    private int translateAnoValue(String string) {
        int n2 = 0;
        if (string != null) {
            n2 = string.equalsIgnoreCase("ACCEPTED") ? 0 : (string.equalsIgnoreCase("REQUESTED") ? 2 : (string.equalsIgnoreCase("REQUIRED") ? 3 : (string.equalsIgnoreCase("REJECTED") ? 1 : -1)));
        }
        return n2;
    }
}

