/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeStringUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringTokenizer;

public class ConvertCastScalarFunction
extends ConvertScalarFunction {
    public String processTokens(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        String string2;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            this.countEscapeTokens(string2);
            if (this.isEndParen(string2)) continue;
            if (this.canICountComma() && ",".equals(string2)) {
                ++n;
                continue;
            }
            if (this.addParams && n == 0) {
                stringBuffer.append(string2);
                continue;
            }
            if (this.addParams && n == 1) {
                stringBuffer2.append(string2);
                continue;
            }
            if (!this.isStartParen(string2)) continue;
            this.addParams = true;
        }
        if (n != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ377", string);
        }
        if (stringBuffer.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ378", "expression", string);
        }
        if (stringBuffer2.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ378", "sqltype", string);
        }
        string2 = this.getSQLType(stringBuffer2.toString().toUpperCase().trim());
        return "CAST( " + stringBuffer.toString() + "  " + "AS" + " " + string2 + " " + ")";
    }

    protected String getSQLType(String string) throws SQLException {
        if (string.indexOf("DATE") != -1) {
            return string;
        }
        if (string.indexOf("DECIMAL") != -1) {
            return string;
        }
        if ("DOUBLE".equals(string)) {
            return "DOUBLE PRECISION";
        }
        if ("INTEGER".equals(string)) {
            return "INTEGER";
        }
        if (string.indexOf("FLOAT") != -1) {
            return string;
        }
        if ("LONGVARCHAR".equals(string)) {
            return "LONG VARCHAR";
        }
        if ("SMALLINT".equals(string)) {
            return "SMALLINT";
        }
        if (string.indexOf("TIME") != -1) {
            return string;
        }
        if (string.indexOf("TIMESTAMP") != -1) {
            return "TIMESTAMP";
        }
        if ("TINYINT".equals(string)) {
            return "BYTEINT";
        }
        if (string.indexOf("VARBINARY") != -1) {
            return string;
        }
        if (string.indexOf("VARCHAR") != -1) {
            return string;
        }
        if (string.indexOf("CHAR") != -1) {
            return string;
        }
        if (string.indexOf("BINARY") != -1) {
            return EscapeStringUtil.replace(string, "BINARY", "BYTE");
        }
        throw ErrorFactory.makeDriverJDBCException("TJ379", string);
    }
}

