/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.navigator;

import com.datapps.linkoopdb.jdbc.Row;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.navigator.RangeIterator;
import com.datapps.linkoopdb.jdbc.result.ResultMetaData;
import com.datapps.linkoopdb.jdbc.rowio.RowInputInterface;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputInterface;

public abstract class RowSetNavigator
implements RangeIterator {
    public int size;
    protected SessionInterface session;
    protected long id;
    protected int currentPos = -1;
    protected int rangePosition;
    protected boolean isClosed;
    protected boolean isBigResult = false;
    int mode;
    boolean hadNext;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public abstract Object[] getCurrent();

    @Override
    public void setCurrent(Object[] data) {
    }

    @Override
    public Object getField(int i) {
        Object[] current = this.getCurrent();
        if (current == null) {
            return null;
        }
        return current[i];
    }

    @Override
    public abstract Row getCurrentRow();

    public abstract void add(Object[] var1);

    public abstract boolean addRow(Row var1);

    @Override
    public abstract void removeCurrent();

    @Override
    public void reset() {
        this.currentPos = -1;
    }

    public abstract void clear();

    @Override
    public abstract void release();

    public boolean isClosed() {
        return this.isClosed;
    }

    public SessionInterface getSession() {
        return this.session;
    }

    public void setSession(SessionInterface session) {
        this.session = session;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.currentPos;
            this.hadNext = true;
            return true;
        }
        if (this.size != 0) {
            this.currentPos = this.size;
        }
        this.hadNext = false;
        return false;
    }

    final boolean hasNext() {
        return this.currentPos < this.size - 1;
    }

    @Override
    public long getRowId() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public boolean hadNext() {
        return this.hadNext;
    }

    public boolean beforeFirst() {
        this.reset();
        this.currentPos = -1;
        return true;
    }

    public boolean afterLast() {
        if (this.size == 0) {
            return false;
        }
        this.reset();
        this.currentPos = this.size;
        return true;
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        if (this.size == 0) {
            return false;
        }
        if (this.isAfterLast()) {
            this.beforeFirst();
        }
        while (this.hasNext()) {
            this.next();
        }
        return true;
    }

    public int getRowNumber() {
        return this.currentPos;
    }

    public boolean absolute(int position) {
        if (position < 0) {
            position += this.size;
        }
        if (position < 0) {
            this.beforeFirst();
            return false;
        }
        if (position >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        if (position < this.currentPos) {
            this.beforeFirst();
        }
        while (position > this.currentPos) {
            this.next();
            if (this.size != 0) continue;
            return false;
        }
        return true;
    }

    public boolean relative(int rows) {
        int position = this.currentPos + rows;
        if (position < 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(position);
    }

    public boolean previous() {
        return this.relative(-1);
    }

    public boolean isFirst() {
        return this.size > 0 && this.currentPos == 0;
    }

    public boolean isLast() {
        return this.size > 0 && this.currentPos == this.size - 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.size > 0 && this.currentPos == -1;
    }

    public boolean isAfterLast() {
        return this.size > 0 && this.currentPos == this.size;
    }

    public void writeSimple(RowOutputInterface out, ResultMetaData meta) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public void readSimple(RowInputInterface in, ResultMetaData meta) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public abstract void write(RowOutputInterface var1, ResultMetaData var2);

    public abstract void read(RowInputInterface var1, ResultMetaData var2);

    public boolean isMemory() {
        return true;
    }

    public boolean isBigResult() {
        return this.isBigResult;
    }

    public void setBigResult(boolean bigResult) {
        this.isBigResult = bigResult;
    }

    @Override
    public int getRangePosition() {
        return this.rangePosition;
    }
}

