"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Calendar = exports.CalendarSourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const calendar_setup_function_1 = require("./calendar-setup-function");
var CalendarSourceType;
(function (CalendarSourceType) {
    CalendarSourceType["S3_OBJECT"] = "s3Object";
    CalendarSourceType["PATH"] = "path";
})(CalendarSourceType = exports.CalendarSourceType || (exports.CalendarSourceType = {}));
class Calendar {
    constructor() { }
    static path(options) {
        return new (class extends Calendar {
            _bind(scope) {
                const localPath = options.calendarPath
                    ? options.calendarPath
                    : __dirname;
                const calendarBody = fs.readFileSync(path.join(localPath, options.calendarName), { encoding: 'utf-8' });
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.PATH,
                    calendarBody,
                    calendarName: options.calendarName,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        })();
    }
    static s3Location(options) {
        return new (class extends Calendar {
            _bind(scope) {
                const calendar = new CustomResourceCalendar(scope, {
                    sourceType: CalendarSourceType.S3_OBJECT,
                    bucketName: options.bucket.bucketName,
                    calendarName: options.calendarName,
                    roleArn: options.role?.roleArn,
                });
                this.calendarArn = calendar.calendarArn;
                this.calendarName = calendar.calendarName;
                return calendar;
            }
        })();
    }
}
exports.Calendar = Calendar;
_a = JSII_RTTI_SYMBOL_1;
Calendar[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.Calendar", version: "0.0.5" };
class CustomResourceCalendar extends Calendar {
    constructor(scope, options) {
        super();
        this.calendarName = options.calendarName;
        this.calendarArn = aws_cdk_lib_1.Arn.format({
            service: 'ssm',
            resource: 'document',
            resourceName: options.calendarName,
        }, aws_cdk_lib_1.Stack.of(scope));
        const onEvent = new calendar_setup_function_1.CalendarSetupFunction(scope, 'OnEventHandler');
        onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'ssm:CreateDocument',
                'ssm:UpdateDocument',
                'ssm:DeleteDocument',
            ],
            resources: [this.calendarArn],
        }));
        const provider = new custom_resources_1.Provider(scope, 'Provider', {
            onEventHandler: onEvent,
        });
        new aws_cdk_lib_1.CustomResource(scope, 'SSMCalendarCustomResource', {
            serviceToken: provider.serviceToken,
            properties: {
                sourceType: options.sourceType,
                calendarBody: options.calendarBody,
                calendarPath: options.calendarPath,
                calendarName: options.calendarName,
                roleArn: options.roleArn,
            },
        });
    }
    _bind() { }
}
//# sourceMappingURL=data:application/json;base64,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