import { IRole } from 'aws-cdk-lib/aws-iam';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface CalendarLocationOptionsBase {
    readonly calendarName: string;
    readonly calendarPath?: string;
}
export interface S3LocationOptions extends CalendarLocationOptionsBase {
    readonly bucket: IBucket;
    readonly role?: IRole;
}
export declare enum CalendarSourceType {
    S3_OBJECT = "s3Object",
    PATH = "path"
}
export declare abstract class Calendar {
    static path(options: CalendarLocationOptionsBase): Calendar;
    static s3Location(options: S3LocationOptions): Calendar;
    calendarName: string;
    calendarArn: string;
    protected constructor();
    /**
     *
     * @internal
     */
    abstract _bind(scope: Construct): any;
}
