"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nx = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
var Nx;
(function (Nx) {
    /**
     * Supported enums for a TargetDependency.
     */
    let TargetDependencyProject;
    (function (TargetDependencyProject) {
        /**
         * Only rely on the package where the target is called.
         *
         * This is usually done for test like targets where you only want to run unit
         * tests on the target packages without testing all dependent packages.
         */
        TargetDependencyProject["SELF"] = "self";
        /**
         * Target relies on executing the target against all dependencies first.
         *
         * This is usually done for build like targets where you want to build all
         * dependant projects first.
         */
        TargetDependencyProject["DEPENDENCIES"] = "dependencies";
    })(TargetDependencyProject = Nx.TargetDependencyProject || (Nx.TargetDependencyProject = {}));
})(Nx = exports.Nx || (exports.Nx = {}));
//# sourceMappingURL=data:application/json;base64,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