# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class PowerSupplyClient(Client):
    """
    A power supply with a fixed or variable voltage range
    Implements a client for the `Power supply <https://microsoft.github.io/jacdac-docs/services/powersupply>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_POWER_SUPPLY, JD_POWER_SUPPLY_PACK_FORMATS, role)


    @property
    def enabled(self) -> Optional[bool]:
        """
        Turns the power supply on with `true`, off with `false`., 
        """
        return self.register(JD_POWER_SUPPLY_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_POWER_SUPPLY_REG_ENABLED).set_values(value)


    @property
    def output_voltage(self) -> Optional[float]:
        """
        The current output voltage of the power supply. Values provided must be in the range `minimum_voltage` to `maximum_voltage`, _: V
        """
        return self.register(JD_POWER_SUPPLY_REG_OUTPUT_VOLTAGE).value()

    @output_voltage.setter
    def output_voltage(self, value: float) -> None:
        self.enabled = True
        self.register(JD_POWER_SUPPLY_REG_OUTPUT_VOLTAGE).set_values(value)


    @property
    def minimum_voltage(self) -> Optional[float]:
        """
        The minimum output voltage of the power supply. For fixed power supplies, `minimum_voltage` should be equal to `maximum_voltage`., _: V
        """
        return self.register(JD_POWER_SUPPLY_REG_MINIMUM_VOLTAGE).value()

    @property
    def maximum_voltage(self) -> Optional[float]:
        """
        The maximum output voltage of the power supply. For fixed power supplies, `minimum_voltage` should be equal to `maximum_voltage`., _: V
        """
        return self.register(JD_POWER_SUPPLY_REG_MAXIMUM_VOLTAGE).value()

    
