# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class BrailleDisplayClient(Client):
    """
    A Braille pattern display module. This module display [unicode braille patterns](https://www.unicode.org/charts/PDF/U2800.pdf), country specific encoding have to be implemented by the clients.
    Implements a client for the `Braille display <https://microsoft.github.io/jacdac-docs/services/brailledisplay>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_BRAILLE_DISPLAY, JD_BRAILLE_DISPLAY_PACK_FORMATS, role)


    @property
    def enabled(self) -> Optional[bool]:
        """
        Determines if the braille display is active., 
        """
        return self.register(JD_BRAILLE_DISPLAY_REG_ENABLED).bool_value()

    @enabled.setter
    def enabled(self, value: bool) -> None:
        self.register(JD_BRAILLE_DISPLAY_REG_ENABLED).set_values(value)


    @property
    def patterns(self) -> Optional[str]:
        """
        Braille patterns to show. Must be unicode characters between `0x2800` and `0x28ff`., 
        """
        return self.register(JD_BRAILLE_DISPLAY_REG_PATTERNS).value()

    @patterns.setter
    def patterns(self, value: str) -> None:
        self.enabled = True
        self.register(JD_BRAILLE_DISPLAY_REG_PATTERNS).set_values(value)


    @property
    def length(self) -> Optional[int]:
        """
        Gets the number of patterns that can be displayed., _: #
        """
        return self.register(JD_BRAILLE_DISPLAY_REG_LENGTH).value()

    
