"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmsEncryptionKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_kms_1 = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const getArnPrincipals = (administratorRoleArns) => {
    return administratorRoleArns.map((arn) => new aws_iam_1.ArnPrincipal(arn));
};
const getAdministratorArns = (administratorRoleArns) => {
    return [new aws_iam_1.CompositePrincipal(...getArnPrincipals(administratorRoleArns))];
};
const createKeyPolicy = (administratorRoleArns) => {
    return new aws_iam_1.PolicyDocument({
        statements: [
            new aws_iam_1.PolicyStatement({
                actions: ['kms:*'],
                resources: ['*'],
                principals: getAdministratorArns(administratorRoleArns),
            }),
        ],
    });
};
/**
 * @stability stable
 */
class KmsEncryptionKey extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.environmentName = (_b = props === null || props === void 0 ? void 0 : props.environmentName) !== null && _b !== void 0 ? _b : 'DEV';
        this.description = this.getKeyName(props === null || props === void 0 ? void 0 : props.description);
        this.keyName = this.getKeyName(props === null || props === void 0 ? void 0 : props.keyName);
        this.kmsKey = this.createKmsKey((_c = props === null || props === void 0 ? void 0 : props.administratorRoleArns) !== null && _c !== void 0 ? _c : []);
        this.addTags();
    }
    /**
     * @stability stable
     */
    getKeyName(keyName) {
        return keyName !== null && keyName !== void 0 ? keyName : `${this.environmentName}-kms-encryption-key`;
    }
    /**
     * @stability stable
     */
    createKmsKey(administratorRoleArns) {
        return new aws_kms_1.Key(this, 'EncryptionKey', {
            alias: this.keyName,
            description: this.description,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            policy: createKeyPolicy(administratorRoleArns),
        });
    }
    /**
     * @stability stable
     */
    addTags() {
        core_1.Tags.of(this).add('environment', this.environmentName);
        core_1.Tags.of(this).add('alias', this.keyName);
    }
}
exports.KmsEncryptionKey = KmsEncryptionKey;
_a = JSII_RTTI_SYMBOL_1;
KmsEncryptionKey[_a] = { fqn: "kms-encryption-key.KmsEncryptionKey", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zRW5jcnlwdGlvbktleS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9rbXNFbmNyeXB0aW9uS2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOENBSzBCO0FBQzFCLDhDQUE2QztBQUM3Qyx3Q0FBK0Q7QUFTL0QsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLHFCQUErQixFQUFrQixFQUFFO0lBQzNFLE9BQU8scUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxJQUFJLHNCQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztBQUNuRSxDQUFDLENBQUM7QUFFRixNQUFNLG9CQUFvQixHQUFHLENBQzNCLHFCQUErQixFQUNULEVBQUU7SUFDeEIsT0FBTyxDQUFDLElBQUksNEJBQWtCLENBQUMsR0FBRyxnQkFBZ0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUM5RSxDQUFDLENBQUM7QUFFRixNQUFNLGVBQWUsR0FBRyxDQUFDLHFCQUErQixFQUFrQixFQUFFO0lBQzFFLE9BQU8sSUFBSSx3QkFBYyxDQUFDO1FBQ3hCLFVBQVUsRUFBRTtZQUNWLElBQUkseUJBQWUsQ0FBQztnQkFDbEIsT0FBTyxFQUFFLENBQUMsT0FBTyxDQUFDO2dCQUNsQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7Z0JBQ2hCLFVBQVUsRUFBRSxvQkFBb0IsQ0FBQyxxQkFBcUIsQ0FBQzthQUN4RCxDQUFDO1NBQ0g7S0FDRixDQUFDLENBQUM7QUFDTCxDQUFDLENBQUM7Ozs7QUFDRixNQUFhLGdCQUFpQixTQUFRLGdCQUFTOzs7O0lBTTdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBOEI7O1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLGVBQWUsU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsZUFBZSxtQ0FBSSxLQUFLLENBQUM7UUFDdkQsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxXQUFXLENBQUMsQ0FBQztRQUN2RCxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFlBQVksT0FBQyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUscUJBQXFCLG1DQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQ3BFLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUNqQixDQUFDOzs7O0lBRUQsVUFBVSxDQUFDLE9BQWdCO1FBQ3pCLE9BQU8sT0FBTyxhQUFQLE9BQU8sY0FBUCxPQUFPLEdBQUksR0FBRyxJQUFJLENBQUMsZUFBZSxxQkFBcUIsQ0FBQztJQUNqRSxDQUFDOzs7O0lBRUQsWUFBWSxDQUFDLHFCQUErQjtRQUMxQyxPQUFPLElBQUksYUFBRyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDcEMsS0FBSyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ25CLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixhQUFhLEVBQUUsb0JBQWEsQ0FBQyxNQUFNO1lBQ25DLE1BQU0sRUFBRSxlQUFlLENBQUMscUJBQXFCLENBQUM7U0FDL0MsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7OztJQUVELE9BQU87UUFDTCxXQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3ZELFdBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7QUEvQkgsNENBZ0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQXJuUHJpbmNpcGFsLFxuICBDb21wb3NpdGVQcmluY2lwYWwsXG4gIFBvbGljeURvY3VtZW50LFxuICBQb2xpY3lTdGF0ZW1lbnQsXG59IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgS2V5LCBJS2V5IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWttcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIFJlbW92YWxQb2xpY3ksIFRhZ3MgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBJS21zRW5jcnlwdGlvbktleVByb3BzIHtcbiAgcmVhZG9ubHkga2V5TmFtZTogc3RyaW5nO1xuICByZWFkb25seSBhZG1pbmlzdHJhdG9yUm9sZUFybnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnROYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbn1cblxuY29uc3QgZ2V0QXJuUHJpbmNpcGFscyA9IChhZG1pbmlzdHJhdG9yUm9sZUFybnM6IHN0cmluZ1tdKTogQXJuUHJpbmNpcGFsW10gPT4ge1xuICByZXR1cm4gYWRtaW5pc3RyYXRvclJvbGVBcm5zLm1hcCgoYXJuKSA9PiBuZXcgQXJuUHJpbmNpcGFsKGFybikpO1xufTtcblxuY29uc3QgZ2V0QWRtaW5pc3RyYXRvckFybnMgPSAoXG4gIGFkbWluaXN0cmF0b3JSb2xlQXJuczogc3RyaW5nW10sXG4pOiBDb21wb3NpdGVQcmluY2lwYWxbXSA9PiB7XG4gIHJldHVybiBbbmV3IENvbXBvc2l0ZVByaW5jaXBhbCguLi5nZXRBcm5QcmluY2lwYWxzKGFkbWluaXN0cmF0b3JSb2xlQXJucykpXTtcbn07XG5cbmNvbnN0IGNyZWF0ZUtleVBvbGljeSA9IChhZG1pbmlzdHJhdG9yUm9sZUFybnM6IHN0cmluZ1tdKTogUG9saWN5RG9jdW1lbnQgPT4ge1xuICByZXR1cm4gbmV3IFBvbGljeURvY3VtZW50KHtcbiAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgYWN0aW9uczogWydrbXM6KiddLFxuICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgICBwcmluY2lwYWxzOiBnZXRBZG1pbmlzdHJhdG9yQXJucyhhZG1pbmlzdHJhdG9yUm9sZUFybnMpLFxuICAgICAgfSksXG4gICAgXSxcbiAgfSk7XG59O1xuZXhwb3J0IGNsYXNzIEttc0VuY3J5cHRpb25LZXkgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBrbXNLZXk6IElLZXk7XG4gIGRlc2NyaXB0aW9uOiBzdHJpbmc7XG4gIGtleU5hbWU6IHN0cmluZztcbiAgZW52aXJvbm1lbnROYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBJS21zRW5jcnlwdGlvbktleVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLmVudmlyb25tZW50TmFtZSA9IHByb3BzPy5lbnZpcm9ubWVudE5hbWUgPz8gJ0RFVic7XG4gICAgdGhpcy5kZXNjcmlwdGlvbiA9IHRoaXMuZ2V0S2V5TmFtZShwcm9wcz8uZGVzY3JpcHRpb24pO1xuICAgIHRoaXMua2V5TmFtZSA9IHRoaXMuZ2V0S2V5TmFtZShwcm9wcz8ua2V5TmFtZSk7XG4gICAgdGhpcy5rbXNLZXkgPSB0aGlzLmNyZWF0ZUttc0tleShwcm9wcz8uYWRtaW5pc3RyYXRvclJvbGVBcm5zID8/IFtdKTtcbiAgICB0aGlzLmFkZFRhZ3MoKTtcbiAgfVxuXG4gIGdldEtleU5hbWUoa2V5TmFtZT86IHN0cmluZyk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGtleU5hbWUgPz8gYCR7dGhpcy5lbnZpcm9ubWVudE5hbWV9LWttcy1lbmNyeXB0aW9uLWtleWA7XG4gIH1cblxuICBjcmVhdGVLbXNLZXkoYWRtaW5pc3RyYXRvclJvbGVBcm5zOiBzdHJpbmdbXSk6IEtleSB7XG4gICAgcmV0dXJuIG5ldyBLZXkodGhpcywgJ0VuY3J5cHRpb25LZXknLCB7XG4gICAgICBhbGlhczogdGhpcy5rZXlOYW1lLFxuICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LlJFVEFJTixcbiAgICAgIHBvbGljeTogY3JlYXRlS2V5UG9saWN5KGFkbWluaXN0cmF0b3JSb2xlQXJucyksXG4gICAgfSk7XG4gIH1cblxuICBhZGRUYWdzKCkge1xuICAgIFRhZ3Mub2YodGhpcykuYWRkKCdlbnZpcm9ubWVudCcsIHRoaXMuZW52aXJvbm1lbnROYW1lKTtcbiAgICBUYWdzLm9mKHRoaXMpLmFkZCgnYWxpYXMnLCB0aGlzLmtleU5hbWUpO1xuICB9XG59XG4iXX0=