import { Key, IKey } from '@aws-cdk/aws-kms';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface IKmsEncryptionKeyProps {
    /**
     * @stability stable
     */
    readonly keyName: string;
    /**
     * @stability stable
     */
    readonly administratorRoleArns?: string[];
    /**
     * @stability stable
     */
    readonly environmentName?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
}
/**
 * @stability stable
 */
export declare class KmsEncryptionKey extends Construct {
    /**
     * @stability stable
     */
    kmsKey: IKey;
    /**
     * @stability stable
     */
    description: string;
    /**
     * @stability stable
     */
    keyName: string;
    /**
     * @stability stable
     */
    environmentName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: IKmsEncryptionKeyProps);
    /**
     * @stability stable
     */
    getKeyName(keyName?: string): string;
    /**
     * @stability stable
     */
    createKmsKey(administratorRoleArns: string[]): Key;
    /**
     * @stability stable
     */
    addTags(): void;
}
