/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as lambda from '@aws-cdk/aws-lambda';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from '@aws-cdk/core';
import * as logs from '@aws-cdk/aws-logs';
/**
 * @summary Properties for the LambdaToStepFunction class.
 */
export interface LambdaToStepFunctionProps {
    /**
     * Existing instance of Lambda Function object, if this is set then the lambdaFunctionProps is ignored.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function.
     *
     * @default - Default properties are used.
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * User provided StateMachineProps to override the defaults.
     *
     * @default - None
     */
    readonly stateMachineProps: sfn.StateMachineProps;
    /**
     * Whether to create recommended CloudWatch alarms.
     *
     * @default - Alarms are created
     */
    readonly createCloudWatchAlarms?: boolean;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
    /**
     * Optional Name for the Step Functions state machine environment variable set for the producer Lambda function.
     *
     * @default - None
     */
    readonly stateMachineEnvironmentVariableName?: string;
}
/**
 * @summary The LambdaToStepFunctionProps class.
 */
export declare class LambdaToStepFunction extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly stateMachine: sfn.StateMachine;
    readonly stateMachineLogGroup: logs.LogGroup;
    readonly cloudwatchAlarms?: cloudwatch.Alarm[];
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToStepFunctionProps class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToStepFunctionProps);
}
