"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyModelProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const projen_1 = require("projen");
/**
 * A project which contains a hello-world Smithy model
 */
class SmithyModelProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        new projen_1.SampleFile(this, "main.smithy", {
            contents: `$version: "2"
namespace ${options.serviceNamespace}

use aws.protocols#restJson1

@title("A Sample Hello World API")

/// A sample smithy api
@restJson1
service ${options.serviceName} {
    version: "1.0"
    operations: [SayHello]
}

@readonly
@http(method: "GET", uri: "/hello")
operation SayHello {
    input: SayHelloInput
    output: SayHelloOutput
    errors: [ApiError]
}

string Name
string Message

@input
structure SayHelloInput {
    @httpQuery("name")
    @required
    name: Name
}

@output
structure SayHelloOutput {
    @required
    message: Message
}

@error("client")
structure ApiError {
    @required
    errorMessage: Message
}
`,
        });
    }
}
exports.SmithyModelProject = SmithyModelProject;
//# sourceMappingURL=data:application/json;base64,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