"use strict";
(self["webpackChunkcodeium_jupyter"] = self["webpackChunkcodeium_jupyter"] || []).push([["vendors-node_modules_connectrpc_connect_dist_esm_protocol-connect_end-stream_js-node_modules_-08d26d"],{

/***/ "./node_modules/@bufbuild/protobuf/dist/esm/google/protobuf/any_pb.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@bufbuild/protobuf/dist/esm/google/protobuf/any_pb.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Any: () => (/* binding */ Any)
/* harmony export */ });
/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../message.js */ "./node_modules/@bufbuild/protobuf/dist/esm/message.js");
/* harmony import */ var _proto3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../proto3.js */ "./node_modules/@bufbuild/protobuf/dist/esm/proto3.js");
// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * `Any` contains an arbitrary serialized protocol buffer message along with a
 * URL that describes the type of the serialized message.
 *
 * Protobuf library provides support to pack/unpack Any values in the form
 * of utility functions or additional generated methods of the Any type.
 *
 * Example 1: Pack and unpack a message in C++.
 *
 *     Foo foo = ...;
 *     Any any;
 *     any.PackFrom(foo);
 *     ...
 *     if (any.UnpackTo(&foo)) {
 *       ...
 *     }
 *
 * Example 2: Pack and unpack a message in Java.
 *
 *     Foo foo = ...;
 *     Any any = Any.pack(foo);
 *     ...
 *     if (any.is(Foo.class)) {
 *       foo = any.unpack(Foo.class);
 *     }
 *     // or ...
 *     if (any.isSameTypeAs(Foo.getDefaultInstance())) {
 *       foo = any.unpack(Foo.getDefaultInstance());
 *     }
 *
 *  Example 3: Pack and unpack a message in Python.
 *
 *     foo = Foo(...)
 *     any = Any()
 *     any.Pack(foo)
 *     ...
 *     if any.Is(Foo.DESCRIPTOR):
 *       any.Unpack(foo)
 *       ...
 *
 *  Example 4: Pack and unpack a message in Go
 *
 *      foo := &pb.Foo{...}
 *      any, err := anypb.New(foo)
 *      if err != nil {
 *        ...
 *      }
 *      ...
 *      foo := &pb.Foo{}
 *      if err := any.UnmarshalTo(foo); err != nil {
 *        ...
 *      }
 *
 * The pack methods provided by protobuf library will by default use
 * 'type.googleapis.com/full.type.name' as the type URL and the unpack
 * methods only use the fully qualified type name after the last '/'
 * in the type URL, for example "foo.bar.com/x/y.z" will yield type
 * name "y.z".
 *
 * JSON
 * ====
 * The JSON representation of an `Any` value uses the regular
 * representation of the deserialized, embedded message, with an
 * additional field `@type` which contains the type URL. Example:
 *
 *     package google.profile;
 *     message Person {
 *       string first_name = 1;
 *       string last_name = 2;
 *     }
 *
 *     {
 *       "@type": "type.googleapis.com/google.profile.Person",
 *       "firstName": <string>,
 *       "lastName": <string>
 *     }
 *
 * If the embedded message type is well-known and has a custom JSON
 * representation, that representation will be embedded adding a field
 * `value` which holds the custom JSON in addition to the `@type`
 * field. Example (for message [google.protobuf.Duration][]):
 *
 *     {
 *       "@type": "type.googleapis.com/google.protobuf.Duration",
 *       "value": "1.212s"
 *     }
 *
 *
 * @generated from message google.protobuf.Any
 */
class Any extends _message_js__WEBPACK_IMPORTED_MODULE_0__.Message {
    constructor(data) {
        super();
        /**
         * A URL/resource name that uniquely identifies the type of the serialized
         * protocol buffer message. This string must contain at least
         * one "/" character. The last segment of the URL's path must represent
         * the fully qualified name of the type (as in
         * `path/google.protobuf.Duration`). The name should be in a canonical form
         * (e.g., leading "." is not accepted).
         *
         * In practice, teams usually precompile into the binary all types that they
         * expect it to use in the context of Any. However, for URLs which use the
         * scheme `http`, `https`, or no scheme, one can optionally set up a type
         * server that maps type URLs to message definitions as follows:
         *
         * * If no scheme is provided, `https` is assumed.
         * * An HTTP GET on the URL must yield a [google.protobuf.Type][]
         *   value in binary format, or produce an error.
         * * Applications are allowed to cache lookup results based on the
         *   URL, or have them precompiled into a binary to avoid any
         *   lookup. Therefore, binary compatibility needs to be preserved
         *   on changes to types. (Use versioned type names to manage
         *   breaking changes.)
         *
         * Note: this functionality is not currently available in the official
         * protobuf release, and it is not used for type URLs beginning with
         * type.googleapis.com. As of May 2023, there are no widely used type server
         * implementations and no plans to implement one.
         *
         * Schemes other than `http`, `https` (or the empty scheme) might be
         * used with implementation specific semantics.
         *
         *
         * @generated from field: string type_url = 1;
         */
        this.typeUrl = "";
        /**
         * Must be a valid serialized protocol buffer of the above specified type.
         *
         * @generated from field: bytes value = 2;
         */
        this.value = new Uint8Array(0);
        _proto3_js__WEBPACK_IMPORTED_MODULE_1__.proto3.util.initPartial(data, this);
    }
    toJson(options) {
        var _a;
        if (this.typeUrl === "") {
            return {};
        }
        const typeName = this.typeUrlToName(this.typeUrl);
        const messageType = (_a = options === null || options === void 0 ? void 0 : options.typeRegistry) === null || _a === void 0 ? void 0 : _a.findMessage(typeName);
        if (!messageType) {
            throw new Error(`cannot encode message google.protobuf.Any to JSON: "${this.typeUrl}" is not in the type registry`);
        }
        const message = messageType.fromBinary(this.value);
        let json = message.toJson(options);
        if (typeName.startsWith("google.protobuf.") || (json === null || Array.isArray(json) || typeof json !== "object")) {
            json = { value: json };
        }
        json["@type"] = this.typeUrl;
        return json;
    }
    fromJson(json, options) {
        var _a;
        if (json === null || Array.isArray(json) || typeof json != "object") {
            throw new Error(`cannot decode message google.protobuf.Any from JSON: expected object but got ${json === null ? "null" : Array.isArray(json) ? "array" : typeof json}`);
        }
        if (Object.keys(json).length == 0) {
            return this;
        }
        const typeUrl = json["@type"];
        if (typeof typeUrl != "string" || typeUrl == "") {
            throw new Error(`cannot decode message google.protobuf.Any from JSON: "@type" is empty`);
        }
        const typeName = this.typeUrlToName(typeUrl), messageType = (_a = options === null || options === void 0 ? void 0 : options.typeRegistry) === null || _a === void 0 ? void 0 : _a.findMessage(typeName);
        if (!messageType) {
            throw new Error(`cannot decode message google.protobuf.Any from JSON: ${typeUrl} is not in the type registry`);
        }
        let message;
        if (typeName.startsWith("google.protobuf.") && Object.prototype.hasOwnProperty.call(json, "value")) {
            message = messageType.fromJson(json["value"], options);
        }
        else {
            const copy = Object.assign({}, json);
            delete copy["@type"];
            message = messageType.fromJson(copy, options);
        }
        this.packFrom(message);
        return this;
    }
    packFrom(message) {
        this.value = message.toBinary();
        this.typeUrl = this.typeNameToUrl(message.getType().typeName);
    }
    unpackTo(target) {
        if (!this.is(target.getType())) {
            return false;
        }
        target.fromBinary(this.value);
        return true;
    }
    unpack(registry) {
        if (this.typeUrl === "") {
            return undefined;
        }
        const messageType = registry.findMessage(this.typeUrlToName(this.typeUrl));
        if (!messageType) {
            return undefined;
        }
        return messageType.fromBinary(this.value);
    }
    is(type) {
        if (this.typeUrl === '') {
            return false;
        }
        const name = this.typeUrlToName(this.typeUrl);
        let typeName = '';
        if (typeof type === 'string') {
            typeName = type;
        }
        else {
            typeName = type.typeName;
        }
        return name === typeName;
    }
    typeNameToUrl(name) {
        return `type.googleapis.com/${name}`;
    }
    typeUrlToName(url) {
        if (!url.length) {
            throw new Error(`invalid type url: ${url}`);
        }
        const slash = url.lastIndexOf("/");
        const name = slash >= 0 ? url.substring(slash + 1) : url;
        if (!name.length) {
            throw new Error(`invalid type url: ${url}`);
        }
        return name;
    }
    static pack(message) {
        const any = new Any();
        any.packFrom(message);
        return any;
    }
    static fromBinary(bytes, options) {
        return new Any().fromBinary(bytes, options);
    }
    static fromJson(jsonValue, options) {
        return new Any().fromJson(jsonValue, options);
    }
    static fromJsonString(jsonString, options) {
        return new Any().fromJsonString(jsonString, options);
    }
    static equals(a, b) {
        return _proto3_js__WEBPACK_IMPORTED_MODULE_1__.proto3.util.equals(Any, a, b);
    }
}
Any.runtime = _proto3_js__WEBPACK_IMPORTED_MODULE_1__.proto3;
Any.typeName = "google.protobuf.Any";
Any.fields = _proto3_js__WEBPACK_IMPORTED_MODULE_1__.proto3.util.newFieldList(() => [
    { no: 1, name: "type_url", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "value", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
]);


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/code.js":
/*!***********************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/code.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Code: () => (/* binding */ Code)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Connect represents categories of errors as codes, and each code maps to a
 * specific HTTP status code. The codes and their semantics were chosen to
 * match gRPC. Only the codes below are valid — there are no user-defined
 * codes.
 *
 * See the specification at https://connectrpc.com/docs/protocol#error-codes
 * for details.
 */
var Code;
(function (Code) {
    /**
     * Canceled, usually be the user
     */
    Code[Code["Canceled"] = 1] = "Canceled";
    /**
     * Unknown error
     */
    Code[Code["Unknown"] = 2] = "Unknown";
    /**
     * Argument invalid regardless of system state
     */
    Code[Code["InvalidArgument"] = 3] = "InvalidArgument";
    /**
     * Operation expired, may or may not have completed.
     */
    Code[Code["DeadlineExceeded"] = 4] = "DeadlineExceeded";
    /**
     * Entity not found.
     */
    Code[Code["NotFound"] = 5] = "NotFound";
    /**
     * Entity already exists.
     */
    Code[Code["AlreadyExists"] = 6] = "AlreadyExists";
    /**
     * Operation not authorized.
     */
    Code[Code["PermissionDenied"] = 7] = "PermissionDenied";
    /**
     * Quota exhausted.
     */
    Code[Code["ResourceExhausted"] = 8] = "ResourceExhausted";
    /**
     * Argument invalid in current system state.
     */
    Code[Code["FailedPrecondition"] = 9] = "FailedPrecondition";
    /**
     * Operation aborted.
     */
    Code[Code["Aborted"] = 10] = "Aborted";
    /**
     * Out of bounds, use instead of FailedPrecondition.
     */
    Code[Code["OutOfRange"] = 11] = "OutOfRange";
    /**
     * Operation not implemented or disabled.
     */
    Code[Code["Unimplemented"] = 12] = "Unimplemented";
    /**
     * Internal error, reserved for "serious errors".
     */
    Code[Code["Internal"] = 13] = "Internal";
    /**
     * Unavailable, client should back off and retry.
     */
    Code[Code["Unavailable"] = 14] = "Unavailable";
    /**
     * Unrecoverable data loss or corruption.
     */
    Code[Code["DataLoss"] = 15] = "DataLoss";
    /**
     * Request isn't authenticated.
     */
    Code[Code["Unauthenticated"] = 16] = "Unauthenticated";
})(Code || (Code = {}));


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js":
/*!********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/connect-error.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectError: () => (/* binding */ ConnectError)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _protocol_connect_code_string_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./protocol-connect/code-string.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/code-string.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * ConnectError captures four pieces of information: a Code, an error
 * message, an optional cause of the error, and an optional collection of
 * arbitrary Protobuf messages called  "details".
 *
 * Because developer tools typically show just the error message, we prefix
 * it with the status code, so that the most important information is always
 * visible immediately.
 *
 * Error details are wrapped with google.protobuf.Any on the wire, so that
 * a server or middleware can attach arbitrary data to an error. Use the
 * method findDetails() to retrieve the details.
 */
class ConnectError extends Error {
    /**
     * Create a new ConnectError.
     * If no code is provided, code "unknown" is used.
     * Outgoing details are only relevant for the server side - a service may
     * raise an error with details, and it is up to the protocol implementation
     * to encode and send the details along with error.
     */
    constructor(message, code = _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unknown, metadata, outgoingDetails, cause) {
        super(createMessage(message, code));
        this.name = "ConnectError";
        // see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-2-2.html#example
        Object.setPrototypeOf(this, new.target.prototype);
        this.rawMessage = message;
        this.code = code;
        this.metadata = new Headers(metadata !== null && metadata !== void 0 ? metadata : {});
        this.details = outgoingDetails !== null && outgoingDetails !== void 0 ? outgoingDetails : [];
        this.cause = cause;
    }
    /**
     * Convert any value - typically a caught error into a ConnectError,
     * following these rules:
     * - If the value is already a ConnectError, return it as is.
     * - If the value is an AbortError from the fetch API, return the message
     *   of the AbortError with code Canceled.
     * - For other Errors, return the error message with code Unknown by default.
     * - For other values, return the values String representation as a message,
     *   with the code Unknown by default.
     * The original value will be used for the "cause" property for the new
     * ConnectError.
     */
    static from(reason, code = _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unknown) {
        if (reason instanceof ConnectError) {
            return reason;
        }
        if (reason instanceof Error) {
            if (reason.name == "AbortError") {
                // Fetch requests can only be canceled with an AbortController.
                // We detect that condition by looking at the name of the raised
                // error object, and translate to the appropriate status code.
                return new ConnectError(reason.message, _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Canceled);
            }
            return new ConnectError(reason.message, code, undefined, undefined, reason);
        }
        return new ConnectError(String(reason), code, undefined, undefined, reason);
    }
    static [Symbol.hasInstance](v) {
        if (!(v instanceof Error)) {
            return false;
        }
        if (Object.getPrototypeOf(v) === ConnectError.prototype) {
            return true;
        }
        return (v.name === "ConnectError" &&
            "code" in v &&
            typeof v.code === "number" &&
            "metadata" in v &&
            "details" in v &&
            Array.isArray(v.details) &&
            "rawMessage" in v &&
            typeof v.rawMessage == "string" &&
            "cause" in v);
    }
    findDetails(typeOrRegistry) {
        const registry = "typeName" in typeOrRegistry
            ? {
                findMessage: (typeName) => typeName === typeOrRegistry.typeName ? typeOrRegistry : undefined,
            }
            : typeOrRegistry;
        const details = [];
        for (const data of this.details) {
            if ("getType" in data) {
                if (registry.findMessage(data.getType().typeName)) {
                    details.push(data);
                }
                continue;
            }
            const type = registry.findMessage(data.type);
            if (type) {
                try {
                    details.push(type.fromBinary(data.value));
                }
                catch (_) {
                    // We silently give up if we are unable to parse the detail, because
                    // that appears to be the least worst behavior.
                    // It is very unlikely that a user surrounds a catch body handling the
                    // error with another try-catch statement, and we do not want to
                    // recommend doing so.
                }
            }
        }
        return details;
    }
}
/**
 * Create an error message, prefixing the given code.
 */
function createMessage(message, code) {
    return message.length
        ? `[${(0,_protocol_connect_code_string_js__WEBPACK_IMPORTED_MODULE_1__.codeToString)(code)}] ${message}`
        : `[${(0,_protocol_connect_code_string_js__WEBPACK_IMPORTED_MODULE_1__.codeToString)(code)}]`;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/http-headers.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/http-headers.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   appendHeaders: () => (/* binding */ appendHeaders),
/* harmony export */   decodeBinaryHeader: () => (/* binding */ decodeBinaryHeader),
/* harmony export */   encodeBinaryHeader: () => (/* binding */ encodeBinaryHeader)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/proto-base64.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Encode a single binary header value according to the Connect
 * and gRPC specifications.
 *
 * This function accepts raw binary data from a buffer, a string
 * with UTF-8 text, or a protobuf message. It encodes the input
 * with unpadded base64 and returns a string that can be used for
 * a header whose name ends with `-bin`.
 */
function encodeBinaryHeader(value) {
    let bytes;
    if (typeof value == "object" && "getType" in value) {
        bytes = value.toBinary();
    }
    else if (typeof value == "string") {
        bytes = new TextEncoder().encode(value);
    }
    else {
        bytes = value instanceof Uint8Array ? value : new Uint8Array(value);
    }
    return _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__.protoBase64.enc(bytes).replace(/=+$/, "");
}
function decodeBinaryHeader(value, type, options) {
    try {
        const bytes = _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__.protoBase64.dec(value);
        if (type) {
            return type.fromBinary(bytes, options);
        }
        return bytes;
    }
    catch (e) {
        throw _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError.from(e, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.DataLoss);
    }
}
/**
 * Merge two or more Headers objects by appending all fields from
 * all inputs to a new Headers object.
 */
function appendHeaders(...headers) {
    const h = new Headers();
    for (const e of headers) {
        e.forEach((value, key) => {
            h.append(key, value);
        });
    }
    return h;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/interceptor.js":
/*!******************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/interceptor.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyInterceptors: () => (/* binding */ applyInterceptors)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * applyInterceptors takes the given UnaryFn or ServerStreamingFn, and wraps
 * it with each of the given interceptors, returning a new UnaryFn or
 * ServerStreamingFn.
 */
function applyInterceptors(next, interceptors) {
    var _a;
    return ((_a = interceptors === null || interceptors === void 0 ? void 0 : interceptors.concat().reverse().reduce(
    // eslint-disable-next-line @typescript-eslint/no-unsafe-argument
    (n, i) => i(n), next)) !== null && _a !== void 0 ? _a : next);
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/code-string.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/code-string.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   codeFromString: () => (/* binding */ codeFromString),
/* harmony export */   codeToString: () => (/* binding */ codeToString)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * codeToString returns the string representation of a Code.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function codeToString(value) {
    const name = _code_js__WEBPACK_IMPORTED_MODULE_0__.Code[value];
    if (typeof name != "string") {
        return value.toString();
    }
    return (name[0].toLowerCase() +
        name.substring(1).replace(/[A-Z]/g, (c) => "_" + c.toLowerCase()));
}
let stringToCode;
/**
 * codeFromString parses the string representation of a Code in snake_case.
 * For example, the string "permission_denied" parses into Code.PermissionDenied.
 *
 * If the given string cannot be parsed, the function returns undefined.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function codeFromString(value) {
    if (!stringToCode) {
        stringToCode = {};
        for (const value of Object.values(_code_js__WEBPACK_IMPORTED_MODULE_0__.Code)) {
            if (typeof value == "string") {
                continue;
            }
            stringToCode[codeToString(value)] = value;
        }
    }
    return stringToCode[value];
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/content-type.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/content-type.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentTypeRegExp: () => (/* binding */ contentTypeRegExp),
/* harmony export */   contentTypeStreamJson: () => (/* binding */ contentTypeStreamJson),
/* harmony export */   contentTypeStreamProto: () => (/* binding */ contentTypeStreamProto),
/* harmony export */   contentTypeStreamRegExp: () => (/* binding */ contentTypeStreamRegExp),
/* harmony export */   contentTypeUnaryJson: () => (/* binding */ contentTypeUnaryJson),
/* harmony export */   contentTypeUnaryProto: () => (/* binding */ contentTypeUnaryProto),
/* harmony export */   contentTypeUnaryRegExp: () => (/* binding */ contentTypeUnaryRegExp),
/* harmony export */   parseContentType: () => (/* binding */ parseContentType),
/* harmony export */   parseEncodingQuery: () => (/* binding */ parseEncodingQuery)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Regular Expression that matches any valid Connect Content-Type header value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const contentTypeRegExp = /^application\/(connect\+)?(?:(json)(?:; ?charset=utf-?8)?|(proto))$/i;
/**
 * Regular Expression that matches a Connect unary Content-Type header value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const contentTypeUnaryRegExp = /^application\/(?:json(?:; ?charset=utf-?8)?|proto)$/i;
/**
 * Regular Expression that matches a Connect streaming Content-Type header value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const contentTypeStreamRegExp = /^application\/connect\+?(?:json(?:; ?charset=utf-?8)?|proto)$/i;
const contentTypeUnaryProto = "application/proto";
const contentTypeUnaryJson = "application/json";
const contentTypeStreamProto = "application/connect+proto";
const contentTypeStreamJson = "application/connect+json";
const encodingProto = "proto";
const encodingJson = "json";
/**
 * Parse a Connect Content-Type header.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseContentType(contentType) {
    const match = contentType === null || contentType === void 0 ? void 0 : contentType.match(contentTypeRegExp);
    if (!match) {
        return undefined;
    }
    const stream = !!match[1];
    const binary = !!match[3];
    return { stream, binary };
}
/**
 * Parse a Connect Get encoding query parameter.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseEncodingQuery(encoding) {
    switch (encoding) {
        case encodingProto:
            return { stream: false, binary: true };
        case encodingJson:
            return { stream: false, binary: false };
        default:
            return undefined;
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/end-stream.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/end-stream.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createEndStreamSerialization: () => (/* binding */ createEndStreamSerialization),
/* harmony export */   endStreamFlag: () => (/* binding */ endStreamFlag),
/* harmony export */   endStreamFromJson: () => (/* binding */ endStreamFromJson),
/* harmony export */   endStreamToJson: () => (/* binding */ endStreamToJson)
/* harmony export */ });
/* harmony import */ var _error_json_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./error-json.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js");
/* harmony import */ var _http_headers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../http-headers.js */ "./node_modules/@connectrpc/connect/dist/esm/http-headers.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * endStreamFlag indicates that the data in a EnvelopedMessage
 * is a EndStreamResponse of the Connect protocol.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const endStreamFlag = 0b00000010;
/**
 * Parse an EndStreamResponse of the Connect protocol.
 * Throws a ConnectError on malformed input.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function endStreamFromJson(data) {
    const parseErr = new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("invalid end stream", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
    let jsonValue;
    try {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
        jsonValue = JSON.parse(typeof data == "string" ? data : new TextDecoder().decode(data));
    }
    catch (e) {
        throw parseErr;
    }
    if (typeof jsonValue != "object" ||
        jsonValue == null ||
        Array.isArray(jsonValue)) {
        throw parseErr;
    }
    const metadata = new Headers();
    if ("metadata" in jsonValue) {
        if (typeof jsonValue.metadata != "object" ||
            jsonValue.metadata == null ||
            Array.isArray(jsonValue.metadata)) {
            throw parseErr;
        }
        for (const [key, values] of Object.entries(jsonValue.metadata)) {
            if (!Array.isArray(values) ||
                values.some((value) => typeof value != "string")) {
                throw parseErr;
            }
            for (const value of values) {
                metadata.append(key, value);
            }
        }
    }
    const error = "error" in jsonValue
        ? (0,_error_json_js__WEBPACK_IMPORTED_MODULE_2__.errorFromJson)(jsonValue.error, metadata, parseErr)
        : undefined;
    return { metadata, error };
}
/**
 * Serialize the given EndStreamResponse to JSON.
 *
 * The JSON serialization options are required to produce the optional
 * human-readable representation of error details if the detail uses
 * google.protobuf.Any.
 *
 * See https://connectrpc.com/docs/protocol#error-end-stream
 *
 * @private Internal code, does not follow semantic versioning.
 */
function endStreamToJson(metadata, error, jsonWriteOptions) {
    const es = {};
    if (error !== undefined) {
        es.error = (0,_error_json_js__WEBPACK_IMPORTED_MODULE_2__.errorToJson)(error, jsonWriteOptions);
        metadata = (0,_http_headers_js__WEBPACK_IMPORTED_MODULE_3__.appendHeaders)(metadata, error.metadata);
    }
    let hasMetadata = false;
    const md = {};
    metadata.forEach((value, key) => {
        hasMetadata = true;
        md[key] = [value];
    });
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    if (hasMetadata) {
        es.metadata = md;
    }
    return es;
}
/**
 * Create a Serialization object that serializes a Connect EndStreamResponse.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createEndStreamSerialization(options) {
    const textEncoder = new TextEncoder();
    return {
        serialize(data) {
            try {
                const jsonObject = endStreamToJson(data.metadata, data.error, options);
                const jsonString = JSON.stringify(jsonObject);
                return textEncoder.encode(jsonString);
            }
            catch (e) {
                const m = e instanceof Error ? e.message : String(e);
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`failed to serialize EndStreamResponse: ${m}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Internal);
            }
        },
        parse(data) {
            try {
                return endStreamFromJson(data);
            }
            catch (e) {
                const m = e instanceof Error ? e.message : String(e);
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`failed to parse EndStreamResponse: ${m}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
            }
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   errorFromJson: () => (/* binding */ errorFromJson),
/* harmony export */   errorFromJsonBytes: () => (/* binding */ errorFromJsonBytes),
/* harmony export */   errorToJson: () => (/* binding */ errorToJson),
/* harmony export */   errorToJsonBytes: () => (/* binding */ errorToJsonBytes)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/proto-base64.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_string_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code-string.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/code-string.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};




/**
 * Parse a Connect error from a JSON value.
 * Will return a ConnectError, and throw the provided fallback if parsing failed.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function errorFromJson(jsonValue, metadata, fallback) {
    if (metadata) {
        new Headers(metadata).forEach((value, key) => fallback.metadata.append(key, value));
    }
    if (typeof jsonValue !== "object" ||
        jsonValue == null ||
        Array.isArray(jsonValue) ||
        !("code" in jsonValue) ||
        typeof jsonValue.code !== "string") {
        throw fallback;
    }
    const code = (0,_code_string_js__WEBPACK_IMPORTED_MODULE_0__.codeFromString)(jsonValue.code);
    if (code === undefined) {
        throw fallback;
    }
    const message = jsonValue.message;
    if (message != null && typeof message !== "string") {
        throw fallback;
    }
    const error = new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(message !== null && message !== void 0 ? message : "", code, metadata);
    if ("details" in jsonValue && Array.isArray(jsonValue.details)) {
        for (const detail of jsonValue.details) {
            if (detail === null ||
                typeof detail != "object" ||
                Array.isArray(detail) ||
                typeof detail.type != "string" ||
                typeof detail.value != "string" ||
                ("debug" in detail && typeof detail.debug != "object")) {
                throw fallback;
            }
            try {
                error.details.push({
                    type: detail.type,
                    value: _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.protoBase64.dec(detail.value),
                    debug: detail.debug,
                });
            }
            catch (e) {
                throw fallback;
            }
        }
    }
    return error;
}
/**
 * Parse a Connect error from a serialized JSON value.
 * Will return a ConnectError, and throw the provided fallback if parsing failed.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function errorFromJsonBytes(bytes, metadata, fallback) {
    let jsonValue;
    try {
        jsonValue = JSON.parse(new TextDecoder().decode(bytes));
    }
    catch (e) {
        throw fallback;
    }
    return errorFromJson(jsonValue, metadata, fallback);
}
/**
 * Serialize the given error to JSON.
 *
 * The JSON serialization options are required to produce the optional
 * human-readable representation in the "debug" key if the detail uses
 * google.protobuf.Any. If serialization of the "debug" value fails, it
 * is silently disregarded.
 *
 * See https://connectrpc.com/docs/protocol#error-end-stream
 *
 * @private Internal code, does not follow semantic versioning.
 */
function errorToJson(error, jsonWriteOptions) {
    const o = {
        code: (0,_code_string_js__WEBPACK_IMPORTED_MODULE_0__.codeToString)(error.code),
    };
    if (error.rawMessage.length > 0) {
        o.message = error.rawMessage;
    }
    if (error.details.length > 0) {
        o.details = error.details
            .map((value) => {
            if ("getType" in value) {
                const i = {
                    type: value.getType().typeName,
                    value: value.toBinary(),
                };
                try {
                    i.debug = value.toJson(jsonWriteOptions);
                }
                catch (e) {
                    // We deliberately ignore errors that may occur when serializing
                    // a message to JSON (the message contains an Any).
                    // The rationale is that we are only trying to provide optional
                    // debug information.
                }
                return i;
            }
            return value;
        })
            .map((_a) => {
            var { value } = _a, rest = __rest(_a, ["value"]);
            return (Object.assign(Object.assign({}, rest), { value: _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.protoBase64.enc(value) }));
        });
    }
    return o;
}
/**
 * Serialize the given error to JSON. This calls errorToJson(), but stringifies
 * the result, and converts it into a UInt8Array.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function errorToJsonBytes(error, jsonWriteOptions) {
    const textEncoder = new TextEncoder();
    try {
        const jsonObject = errorToJson(error, jsonWriteOptions);
        const jsonString = JSON.stringify(jsonObject);
        return textEncoder.encode(jsonString);
    }
    catch (e) {
        const m = e instanceof Error ? e.message : String(e);
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`failed to serialize Connect Error: ${m}`, _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Internal);
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/get-request.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/get-request.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   transformConnectPostToGetRequest: () => (/* binding */ transformConnectPostToGetRequest)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/proto-base64.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./version.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/version.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



const contentTypePrefix = "application/";
function encodeMessageForUrl(message, useBase64) {
    if (useBase64) {
        // TODO(jchadwick-buf): Three regex replaces seems excessive.
        // Can we make protoBase64.enc more flexible?
        return _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__.protoBase64
            .enc(message)
            .replace(/\+/g, "-")
            .replace(/\//g, "_")
            .replace(/=+$/, "");
    }
    else {
        return encodeURIComponent(new TextDecoder().decode(message));
    }
}
/**
 * @private Internal code, does not follow semantic versioning.
 */
function transformConnectPostToGetRequest(request, message, useBase64) {
    let query = `?connect=v${_version_js__WEBPACK_IMPORTED_MODULE_1__.protocolVersion}`;
    const contentType = request.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerContentType);
    if ((contentType === null || contentType === void 0 ? void 0 : contentType.indexOf(contentTypePrefix)) === 0) {
        query +=
            "&encoding=" +
                encodeURIComponent(contentType.slice(contentTypePrefix.length));
    }
    const compression = request.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerUnaryEncoding);
    if (compression !== null && compression !== "identity") {
        query += "&compression=" + encodeURIComponent(compression);
        // Force base64 for compressed payloads.
        useBase64 = true;
    }
    if (useBase64) {
        query += "&base64=1";
    }
    query += "&message=" + encodeMessageForUrl(message, useBase64);
    const url = request.url + query;
    // Omit headers that are not used for unary GET requests.
    const header = new Headers(request.header);
    [
        _headers_js__WEBPACK_IMPORTED_MODULE_2__.headerProtocolVersion,
        _headers_js__WEBPACK_IMPORTED_MODULE_2__.headerContentType,
        _headers_js__WEBPACK_IMPORTED_MODULE_2__.headerUnaryContentLength,
        _headers_js__WEBPACK_IMPORTED_MODULE_2__.headerUnaryEncoding,
        _headers_js__WEBPACK_IMPORTED_MODULE_2__.headerUnaryAcceptEncoding,
    ].forEach((h) => header.delete(h));
    return Object.assign(Object.assign({}, request), { init: Object.assign(Object.assign({}, request.init), { method: "GET" }), url,
        header });
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   headerContentType: () => (/* binding */ headerContentType),
/* harmony export */   headerProtocolVersion: () => (/* binding */ headerProtocolVersion),
/* harmony export */   headerStreamAcceptEncoding: () => (/* binding */ headerStreamAcceptEncoding),
/* harmony export */   headerStreamEncoding: () => (/* binding */ headerStreamEncoding),
/* harmony export */   headerTimeout: () => (/* binding */ headerTimeout),
/* harmony export */   headerUnaryAcceptEncoding: () => (/* binding */ headerUnaryAcceptEncoding),
/* harmony export */   headerUnaryContentLength: () => (/* binding */ headerUnaryContentLength),
/* harmony export */   headerUnaryEncoding: () => (/* binding */ headerUnaryEncoding),
/* harmony export */   headerUserAgent: () => (/* binding */ headerUserAgent)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * @private Internal code, does not follow semantic versioning.
 */
const headerContentType = "Content-Type";
const headerUnaryContentLength = "Content-Length";
const headerUnaryEncoding = "Content-Encoding";
const headerStreamEncoding = "Connect-Content-Encoding";
const headerUnaryAcceptEncoding = "Accept-Encoding";
const headerStreamAcceptEncoding = "Connect-Accept-Encoding";
const headerTimeout = "Connect-Timeout-Ms";
const headerProtocolVersion = "Connect-Protocol-Version";
const headerUserAgent = "User-Agent";


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/http-status.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/http-status.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   codeFromHttpStatus: () => (/* binding */ codeFromHttpStatus),
/* harmony export */   codeToHttpStatus: () => (/* binding */ codeToHttpStatus)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * Determine the Connect error code for the given HTTP status code.
 * See https://connectrpc.com/docs/protocol#error-codes
 *
 * @private Internal code, does not follow semantic versioning.
 */
function codeFromHttpStatus(httpStatus) {
    switch (httpStatus) {
        case 400: // Bad Request
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.InvalidArgument;
        case 401: // Unauthorized
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unauthenticated;
        case 403: // Forbidden
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.PermissionDenied;
        case 404: // Not Found
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unimplemented;
        case 408: // Request Timeout
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.DeadlineExceeded;
        case 409: // Conflict
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Aborted;
        case 412: // Precondition Failed
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.FailedPrecondition;
        case 413: // Payload Too Large
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.ResourceExhausted;
        case 415: // Unsupported Media Type
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Internal;
        case 429: // Too Many Requests
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 431: // Request Header Fields Too Large
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.ResourceExhausted;
        case 502: // Bad Gateway
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 503: // Service Unavailable
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 504: // Gateway Timeout
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        default:
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unknown;
    }
}
/**
 * Returns a HTTP status code for the given Connect code.
 * See https://connectrpc.com/docs/protocol#error-codes
 *
 * @private Internal code, does not follow semantic versioning.
 */
function codeToHttpStatus(code) {
    switch (code) {
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Canceled:
            return 408; // Request Timeout
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unknown:
            return 500; // Internal Server Error
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.InvalidArgument:
            return 400; // Bad Request
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.DeadlineExceeded:
            return 408; // Request Timeout
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.NotFound:
            return 404; // Not Found
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.AlreadyExists:
            return 409; // Conflict
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.PermissionDenied:
            return 403; // Forbidden
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.ResourceExhausted:
            return 429; // Too Many Requests
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.FailedPrecondition:
            return 412; // Precondition Failed
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Aborted:
            return 409; // Conflict
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.OutOfRange:
            return 400; // Bad Request
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unimplemented:
            return 404; // Not Found
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Internal:
            return 500; // Internal Server Error
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable:
            return 503; // Service Unavailable
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.DataLoss:
            return 500; // Internal Server Error
        case _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unauthenticated:
            return 401; // Unauthorized
        default:
            return 500; // same as CodeUnknown
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/query-params.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/query-params.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   paramBase64: () => (/* binding */ paramBase64),
/* harmony export */   paramCompression: () => (/* binding */ paramCompression),
/* harmony export */   paramConnectVersion: () => (/* binding */ paramConnectVersion),
/* harmony export */   paramEncoding: () => (/* binding */ paramEncoding),
/* harmony export */   paramMessage: () => (/* binding */ paramMessage)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * @private Internal code, does not follow semantic versioning.
 */
const paramConnectVersion = "connect";
const paramEncoding = "encoding";
const paramCompression = "compression";
const paramBase64 = "base64";
const paramMessage = "message";


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/request-header.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/request-header.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   requestHeader: () => (/* binding */ requestHeader),
/* harmony export */   requestHeaderWithCompression: () => (/* binding */ requestHeaderWithCompression)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./version.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/version.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/content-type.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Creates headers for a Connect request.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requestHeader(methodKind, useBinaryFormat, timeoutMs, userProvidedHeaders, setUserAgent) {
    const result = new Headers(userProvidedHeaders !== null && userProvidedHeaders !== void 0 ? userProvidedHeaders : {});
    if (timeoutMs !== undefined) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerTimeout, `${timeoutMs}`);
    }
    result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerContentType, methodKind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.Unary
        ? useBinaryFormat
            ? _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeUnaryProto
            : _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeUnaryJson
        : useBinaryFormat
            ? _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeStreamProto
            : _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeStreamJson);
    result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerProtocolVersion, _version_js__WEBPACK_IMPORTED_MODULE_3__.protocolVersion);
    if (setUserAgent) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUserAgent, "connect-es/1.4.0");
    }
    return result;
}
/**
 * Creates headers for a Connect request with compression.
 *
 * Note that we always set the Content-Encoding header for unary methods.
 * It is up to the caller to decide whether to apply compression - and remove
 * the header if compression is not used, for example because the payload is
 * too small to make compression effective.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requestHeaderWithCompression(methodKind, useBinaryFormat, timeoutMs, userProvidedHeaders, acceptCompression, sendCompression, setUserAgent) {
    const result = requestHeader(methodKind, useBinaryFormat, timeoutMs, userProvidedHeaders, setUserAgent);
    if (sendCompression != null) {
        const name = methodKind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.Unary
            ? _headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUnaryEncoding
            : _headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStreamEncoding;
        result.set(name, sendCompression.name);
    }
    if (acceptCompression.length > 0) {
        const name = methodKind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.Unary
            ? _headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUnaryAcceptEncoding
            : _headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStreamAcceptEncoding;
        result.set(name, acceptCompression.map((c) => c.name).join(","));
    }
    return result;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/trailer-mux.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/trailer-mux.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   trailerDemux: () => (/* binding */ trailerDemux),
/* harmony export */   trailerMux: () => (/* binding */ trailerMux)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * In unary RPCs, Connect transports trailing metadata as response header
 * fields, prefixed with "trailer-".
 *
 * This function demuxes headers and trailers into two separate Headers
 * objects.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function trailerDemux(header) {
    const h = new Headers(), t = new Headers();
    header.forEach((value, key) => {
        if (key.toLowerCase().startsWith("trailer-")) {
            t.set(key.substring(8), value);
        }
        else {
            h.set(key, value);
        }
    });
    return [h, t];
}
/**
 * In unary RPCs, Connect transports trailing metadata as response header
 * fields, prefixed with "trailer-".
 *
 * This function muxes a header and a trailer into a single Headers object.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function trailerMux(header, trailer) {
    const h = new Headers(header);
    trailer.forEach((value, key) => {
        h.set(`trailer-${key}`, value);
    });
    return h;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/validate-response.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/validate-response.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   validateResponse: () => (/* binding */ validateResponse),
/* harmony export */   validateResponseWithCompression: () => (/* binding */ validateResponseWithCompression)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _http_status_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./http-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/http-status.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/content-type.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Validates response status and header for the Connect protocol.
 * Throws a ConnectError if the header indicates an error, or if
 * the content type is unexpected, with the following exception:
 * For unary RPCs with an HTTP error status, this returns an error
 * derived from the HTTP status instead of throwing it, giving an
 * implementation a chance to parse a Connect error from the wire.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateResponse(methodKind, status, headers) {
    const mimeType = headers.get("Content-Type");
    const parsedType = (0,_content_type_js__WEBPACK_IMPORTED_MODULE_0__.parseContentType)(mimeType);
    if (status !== 200) {
        const errorFromStatus = new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`HTTP ${status}`, (0,_http_status_js__WEBPACK_IMPORTED_MODULE_2__.codeFromHttpStatus)(status), headers);
        // If parsedType is defined and it is not binary, then this is a unary JSON response
        if (methodKind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodKind.Unary && parsedType && !parsedType.binary) {
            return { isUnaryError: true, unaryError: errorFromStatus };
        }
        throw errorFromStatus;
    }
    return { isUnaryError: false };
}
/**
 * Validates response status and header for the Connect protocol.
 * This function is identical to validateResponse(), but also verifies
 * that a given encoding header is acceptable.
 *
 * @private
 */
function validateResponseWithCompression(methodKind, acceptCompression, status, headers) {
    let compression;
    const encoding = headers.get(methodKind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodKind.Unary ? _headers_js__WEBPACK_IMPORTED_MODULE_4__.headerUnaryEncoding : _headers_js__WEBPACK_IMPORTED_MODULE_4__.headerStreamEncoding);
    if (encoding != null && encoding.toLowerCase() !== "identity") {
        compression = acceptCompression.find((c) => c.name === encoding);
        if (!compression) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`unsupported response encoding "${encoding}"`, _code_js__WEBPACK_IMPORTED_MODULE_5__.Code.InvalidArgument, headers);
        }
    }
    return Object.assign({ compression }, validateResponse(methodKind, status, headers));
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/version.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/version.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   protocolVersion: () => (/* binding */ protocolVersion),
/* harmony export */   requireProtocolVersionHeader: () => (/* binding */ requireProtocolVersionHeader),
/* harmony export */   requireProtocolVersionParam: () => (/* binding */ requireProtocolVersionParam)
/* harmony export */ });
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _query_params_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./query-params.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/query-params.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * The only know value for the header Connect-Protocol-Version.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const protocolVersion = "1";
/**
 * Requires the Connect-Protocol-Version header to be present with the expected
 * value. Raises a ConnectError with Code.InvalidArgument otherwise.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requireProtocolVersionHeader(requestHeader) {
    const v = requestHeader.get(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerProtocolVersion);
    if (v === null) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`missing required header: set ${_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerProtocolVersion} to "${protocolVersion}"`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
    }
    else if (v !== protocolVersion) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`${_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerProtocolVersion} must be "${protocolVersion}": got "${v}"`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
    }
}
/**
 * Requires the connect query parameter to be present with the expected value.
 * Raises a ConnectError with Code.InvalidArgument otherwise.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requireProtocolVersionParam(queryParams) {
    const v = queryParams.get(_query_params_js__WEBPACK_IMPORTED_MODULE_3__.paramConnectVersion);
    if (v === null) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`missing required parameter: set ${_query_params_js__WEBPACK_IMPORTED_MODULE_3__.paramConnectVersion} to "v${protocolVersion}"`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
    }
    else if (v !== `v${protocolVersion}`) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`${_query_params_js__WEBPACK_IMPORTED_MODULE_3__.paramConnectVersion} must be "v${protocolVersion}": got "${v}"`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/content-type.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/content-type.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentTypeJson: () => (/* binding */ contentTypeJson),
/* harmony export */   contentTypeProto: () => (/* binding */ contentTypeProto),
/* harmony export */   contentTypeRegExp: () => (/* binding */ contentTypeRegExp),
/* harmony export */   parseContentType: () => (/* binding */ parseContentType)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Regular Expression that matches any valid gRPC-web Content-Type header value.
 * Note that this includes application/grpc-web-text with the additional base64
 * encoding.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const contentTypeRegExp = /^application\/grpc-web(-text)?(?:\+(?:(json)(?:; ?charset=utf-?8)?|proto))?$/i;
const contentTypeProto = "application/grpc-web+proto";
const contentTypeJson = "application/grpc-web+json";
/**
 * Parse a gRPC-web Content-Type header value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseContentType(contentType) {
    const match = contentType === null || contentType === void 0 ? void 0 : contentType.match(contentTypeRegExp);
    if (!match) {
        return undefined;
    }
    const text = !!match[1];
    const binary = !match[2];
    return { text, binary };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/headers.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/headers.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   headerAcceptEncoding: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerAcceptEncoding),
/* harmony export */   headerContentType: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerContentType),
/* harmony export */   headerEncoding: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerEncoding),
/* harmony export */   headerGrpcMessage: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcMessage),
/* harmony export */   headerGrpcStatus: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcStatus),
/* harmony export */   headerStatusDetailsBin: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStatusDetailsBin),
/* harmony export */   headerTimeout: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerTimeout),
/* harmony export */   headerUserAgent: () => (/* reexport safe */ _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUserAgent),
/* harmony export */   headerXGrpcWeb: () => (/* binding */ headerXGrpcWeb),
/* harmony export */   headerXUserAgent: () => (/* binding */ headerXUserAgent)
/* harmony export */ });
/* harmony import */ var _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol-grpc/headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * @private Internal code, does not follow semantic versioning.
 */

/**
 * gRPC-web does not use the standard header User-Agent.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const headerXUserAgent = "X-User-Agent";
/**
 * The canonical grpc/grpc-web JavaScript implementation sets
 * this request header with value "1".
 * Some servers may rely on the header to identify gRPC-web
 * requests. For example the proxy by improbable:
 * https://github.com/improbable-eng/grpc-web/blob/53aaf4cdc0fede7103c1b06f0cfc560c003a5c41/go/grpcweb/wrapper.go#L231
 *
 * @private Internal code, does not follow semantic versioning.
 */
const headerXGrpcWeb = "X-Grpc-Web";


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/trailer.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/trailer.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTrailerSerialization: () => (/* binding */ createTrailerSerialization),
/* harmony export */   trailerFlag: () => (/* binding */ trailerFlag),
/* harmony export */   trailerParse: () => (/* binding */ trailerParse),
/* harmony export */   trailerSerialize: () => (/* binding */ trailerSerialize)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * trailerFlag indicates that the data in a EnvelopedMessage
 * is a set of trailers of the gRPC-web protocol.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const trailerFlag = 0b10000000;
/**
 * Parse a gRPC-web trailer, a set of header fields separated by CRLF.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function trailerParse(data) {
    const headers = new Headers();
    const lines = new TextDecoder().decode(data).split("\r\n");
    for (const line of lines) {
        if (line === "") {
            continue;
        }
        const i = line.indexOf(":");
        if (i > 0) {
            const name = line.substring(0, i).trim();
            const value = line.substring(i + 1).trim();
            headers.append(name, value);
        }
    }
    return headers;
}
/**
 * Serialize a Headers object as a gRPC-web trailer.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function trailerSerialize(trailer) {
    const lines = [];
    trailer.forEach((value, key) => {
        lines.push(`${key}: ${value}\r\n`);
    });
    return new TextEncoder().encode(lines.join(""));
}
/**
 * Create a Serialization object that serializes a gRPC-web trailer, a Headers
 * object that is serialized as a set of header fields, separated by CRLF.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createTrailerSerialization() {
    return {
        serialize: trailerSerialize,
        parse: trailerParse,
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/gen/status_pb.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/gen/status_pb.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Status: () => (/* binding */ Status)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/message.js");
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/proto3.js");
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/google/protobuf/any_pb.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * The `Status` type defines a logical error model that is suitable for different
 * programming environments, including REST APIs and RPC APIs. It is used by
 * [gRPC](https://github.com/grpc). The error model is designed to be:
 *
 * - Simple to use and understand for most users
 * - Flexible enough to meet unexpected needs
 *
 * # Overview
 *
 * The `Status` message contains three pieces of data: error code, error message,
 * and error details. The error code should be an enum value of
 * [google.rpc.Code][google.rpc.Code], but it may accept additional error codes if needed.  The
 * error message should be a developer-facing English message that helps
 * developers *understand* and *resolve* the error. If a localized user-facing
 * error message is needed, put the localized message in the error details or
 * localize it in the client. The optional error details may contain arbitrary
 * information about the error. There is a predefined set of error detail types
 * in the package `google.rpc` which can be used for common error conditions.
 *
 * # Language mapping
 *
 * The `Status` message is the logical representation of the error model, but it
 * is not necessarily the actual wire format. When the `Status` message is
 * exposed in different client libraries and different wire protocols, it can be
 * mapped differently. For example, it will likely be mapped to some exceptions
 * in Java, but more likely mapped to some error codes in C.
 *
 * # Other uses
 *
 * The error model and the `Status` message can be used in a variety of
 * environments, either with or without APIs, to provide a
 * consistent developer experience across different environments.
 *
 * Example uses of this error model include:
 *
 * - Partial errors. If a service needs to return partial errors to the client,
 *     it may embed the `Status` in the normal response to indicate the partial
 *     errors.
 *
 * - Workflow errors. A typical workflow has multiple steps. Each step may
 *     have a `Status` message for error reporting purpose.
 *
 * - Batch operations. If a client uses batch request and batch response, the
 *     `Status` message should be used directly inside batch response, one for
 *     each error sub-response.
 *
 * - Asynchronous operations. If an API call embeds asynchronous operation
 *     results in its response, the status of those operations should be
 *     represented directly using the `Status` message.
 *
 * - Logging. If some API errors are stored in logs, the message `Status` could
 *     be used directly after any stripping needed for security/privacy reasons.
 *
 * @generated from message google.rpc.Status
 */
class Status extends _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_0__.Message {
    constructor(data) {
        super();
        /**
         * The status code, which should be an enum value of [google.rpc.Code][google.rpc.Code].
         *
         * @generated from field: int32 code = 1;
         */
        this.code = 0;
        /**
         * A developer-facing error message, which should be in English. Any
         * user-facing error message should be localized and sent in the
         * [google.rpc.Status.details][google.rpc.Status.details] field, or localized by the client.
         *
         * @generated from field: string message = 2;
         */
        this.message = "";
        /**
         * A list of messages that carry the error details.  There will be a
         * common set of message types for APIs to use.
         *
         * @generated from field: repeated google.protobuf.Any details = 3;
         */
        this.details = [];
        _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.proto3.util.initPartial(data, this);
    }
    static fromBinary(bytes, options) {
        return new Status().fromBinary(bytes, options);
    }
    static fromJson(jsonValue, options) {
        return new Status().fromJson(jsonValue, options);
    }
    static fromJsonString(jsonString, options) {
        return new Status().fromJsonString(jsonString, options);
    }
    static equals(a, b) {
        return _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.proto3.util.equals(Status, a, b);
    }
}
Status.runtime = _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.proto3;
Status.typeName = "google.rpc.Status";
Status.fields = _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.proto3.util.newFieldList(() => [
    { no: 1, name: "code", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "details", kind: "message", T: _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.Any, repeated: true },
]);


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   headerAcceptEncoding: () => (/* binding */ headerAcceptEncoding),
/* harmony export */   headerContentType: () => (/* binding */ headerContentType),
/* harmony export */   headerEncoding: () => (/* binding */ headerEncoding),
/* harmony export */   headerGrpcMessage: () => (/* binding */ headerGrpcMessage),
/* harmony export */   headerGrpcStatus: () => (/* binding */ headerGrpcStatus),
/* harmony export */   headerMessageType: () => (/* binding */ headerMessageType),
/* harmony export */   headerStatusDetailsBin: () => (/* binding */ headerStatusDetailsBin),
/* harmony export */   headerTimeout: () => (/* binding */ headerTimeout),
/* harmony export */   headerUserAgent: () => (/* binding */ headerUserAgent)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * @private Internal code, does not follow semantic versioning.
 */
const headerContentType = "Content-Type";
const headerEncoding = "Grpc-Encoding";
const headerAcceptEncoding = "Grpc-Accept-Encoding";
const headerTimeout = "Grpc-Timeout";
const headerGrpcStatus = "Grpc-Status";
const headerGrpcMessage = "Grpc-Message";
const headerStatusDetailsBin = "Grpc-Status-Details-Bin";
const headerMessageType = "Grpc-Message-Type";
const headerUserAgent = "User-Agent";


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   findTrailerError: () => (/* binding */ findTrailerError),
/* harmony export */   grpcStatusOk: () => (/* binding */ grpcStatusOk),
/* harmony export */   setTrailerStatus: () => (/* binding */ setTrailerStatus)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/google/protobuf/any_pb.js");
/* harmony import */ var _gen_status_pb_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./gen/status_pb.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/gen/status_pb.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _http_headers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../http-headers.js */ "./node_modules/@connectrpc/connect/dist/esm/http-headers.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * The value of the Grpc-Status header or trailer in case of success.
 * Used by the gRPC and gRPC-web protocols.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const grpcStatusOk = "0";
/**
 * Sets the fields "grpc-status" and "grpc-message" in the given
 * Headers object.
 * If an error is given and contains error details, the function
 * will also set the field "grpc-status-details-bin" with an encoded
 * google.rpc.Status message including the error details.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function setTrailerStatus(target, error) {
    if (error) {
        target.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcStatus, error.code.toString(10));
        target.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcMessage, encodeURIComponent(error.rawMessage));
        if (error.details.length > 0) {
            const status = new _gen_status_pb_js__WEBPACK_IMPORTED_MODULE_1__.Status({
                code: error.code,
                message: error.rawMessage,
                details: error.details.map((value) => "getType" in value
                    ? _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.Any.pack(value)
                    : new _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.Any({
                        typeUrl: `type.googleapis.com/${value.type}`,
                        value: value.value,
                    })),
            });
            target.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStatusDetailsBin, (0,_http_headers_js__WEBPACK_IMPORTED_MODULE_3__.encodeBinaryHeader)(status));
        }
    }
    else {
        target.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcStatus, grpcStatusOk.toString());
    }
    return target;
}
/**
 * Find an error status in the given Headers object, which can be either
 * a trailer, or a header (as allowed for so-called trailers-only responses).
 * The field "grpc-status-details-bin" is inspected, and if not present,
 * the fields "grpc-status" and "grpc-message" are used.
 * Returns an error only if the gRPC status code is > 0.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function findTrailerError(headerOrTrailer) {
    // TODO
    // let code: Code;
    // let message: string = "";
    var _a;
    // Prefer the protobuf-encoded data to the grpc-status header.
    const statusBytes = headerOrTrailer.get(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStatusDetailsBin);
    if (statusBytes != null) {
        const status = (0,_http_headers_js__WEBPACK_IMPORTED_MODULE_3__.decodeBinaryHeader)(statusBytes, _gen_status_pb_js__WEBPACK_IMPORTED_MODULE_1__.Status);
        if (status.code == 0) {
            return undefined;
        }
        const error = new _connect_error_js__WEBPACK_IMPORTED_MODULE_4__.ConnectError(status.message, status.code, headerOrTrailer);
        error.details = status.details.map((any) => ({
            type: any.typeUrl.substring(any.typeUrl.lastIndexOf("/") + 1),
            value: any.value,
        }));
        return error;
    }
    const grpcStatus = headerOrTrailer.get(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcStatus);
    if (grpcStatus != null) {
        if (grpcStatus === grpcStatusOk) {
            return undefined;
        }
        const code = parseInt(grpcStatus, 10);
        if (code in _code_js__WEBPACK_IMPORTED_MODULE_5__.Code) {
            return new _connect_error_js__WEBPACK_IMPORTED_MODULE_4__.ConnectError(decodeURIComponent((_a = headerOrTrailer.get(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerGrpcMessage)) !== null && _a !== void 0 ? _a : ""), code, headerOrTrailer);
        }
        return new _connect_error_js__WEBPACK_IMPORTED_MODULE_4__.ConnectError(`invalid grpc-status: ${grpcStatus}`, _code_js__WEBPACK_IMPORTED_MODULE_5__.Code.Internal, headerOrTrailer);
    }
    return undefined;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   compressedFlag: () => (/* binding */ compressedFlag),
/* harmony export */   compressionNegotiate: () => (/* binding */ compressionNegotiate)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * compressedFlag indicates that the data in a EnvelopedMessage is
 * compressed. It has the same meaning in the gRPC-Web, gRPC-HTTP2,
 * and Connect protocols.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const compressedFlag = 0b00000001;
/**
 * Validates the request encoding and determines the accepted response encoding.
 *
 * Returns the request and response compression to use. If the client requested
 * an encoding that is not available, the returned object contains an error that
 * must be used for the response.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function compressionNegotiate(available, requested, // e.g. the value of the Grpc-Encoding header
accepted, // e.g. the value of the Grpc-Accept-Encoding header
headerNameAcceptEncoding) {
    let request = null;
    let response = null;
    let error = undefined;
    if (requested !== null && requested !== "identity") {
        const found = available.find((c) => c.name === requested);
        if (found) {
            request = found;
        }
        else {
            // To comply with https://github.com/grpc/grpc/blob/master/doc/compression.md
            // and the Connect protocol, we return code "unimplemented" and specify
            // acceptable compression(s).
            const acceptable = available.map((c) => c.name).join(",");
            error = new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`unknown compression "${requested}": supported encodings are ${acceptable}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Unimplemented, {
                [headerNameAcceptEncoding]: acceptable,
            });
        }
    }
    if (accepted === null || accepted === "") {
        // Support asymmetric compression. This logic follows
        // https://github.com/grpc/grpc/blob/master/doc/compression.md and common
        // sense.
        response = request;
    }
    else {
        const acceptNames = accepted.split(",").map((n) => n.trim());
        for (const name of acceptNames) {
            const found = available.find((c) => c.name === name);
            if (found) {
                response = found;
                break;
            }
        }
    }
    return { request, response, error };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createMethodUrl: () => (/* binding */ createMethodUrl)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Create a URL for the given RPC. This simply adds the qualified
 * service name, a slash, and the method name to the path of the given
 * baseUrl.
 *
 * For example, the baseUri https://example.com and method "Say" from
 * the service example.ElizaService results in:
 * https://example.com/example.ElizaService/Say
 *
 * This format is used by the protocols Connect, gRPC and Twirp.
 *
 * Note that this function also accepts a protocol-relative baseUrl.
 * If given an empty string or "/" as a baseUrl, it returns just the
 * path.
 */
function createMethodUrl(baseUrl, service, method) {
    const s = typeof service == "string" ? service : service.typeName;
    const m = typeof method == "string" ? method : method.name;
    return baseUrl.toString().replace(/\/?$/, `/${s}/${m}`);
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/envelope.js":
/*!************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/envelope.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createEnvelopeReadableStream: () => (/* binding */ createEnvelopeReadableStream),
/* harmony export */   encodeEnvelope: () => (/* binding */ encodeEnvelope),
/* harmony export */   encodeEnvelopes: () => (/* binding */ encodeEnvelopes),
/* harmony export */   envelopeCompress: () => (/* binding */ envelopeCompress),
/* harmony export */   envelopeDecompress: () => (/* binding */ envelopeDecompress)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _compression_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./compression.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Create a WHATWG ReadableStream of enveloped messages from a ReadableStream
 * of bytes.
 *
 * Ideally, this would simply be a TransformStream, but ReadableStream.pipeThrough
 * does not have the necessary availability at this time.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createEnvelopeReadableStream(stream) {
    let reader;
    let buffer = new Uint8Array(0);
    function append(chunk) {
        const n = new Uint8Array(buffer.length + chunk.length);
        n.set(buffer);
        n.set(chunk, buffer.length);
        buffer = n;
    }
    return new ReadableStream({
        start() {
            reader = stream.getReader();
        },
        async pull(controller) {
            let header = undefined;
            for (;;) {
                if (header === undefined && buffer.byteLength >= 5) {
                    let length = 0;
                    for (let i = 1; i < 5; i++) {
                        length = (length << 8) + buffer[i];
                    }
                    header = { flags: buffer[0], length };
                }
                if (header !== undefined && buffer.byteLength >= header.length + 5) {
                    break;
                }
                const result = await reader.read();
                if (result.done) {
                    break;
                }
                append(result.value);
            }
            if (header === undefined) {
                if (buffer.byteLength == 0) {
                    controller.close();
                    return;
                }
                controller.error(new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("premature end of stream", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.DataLoss));
                return;
            }
            const data = buffer.subarray(5, 5 + header.length);
            buffer = buffer.subarray(5 + header.length);
            controller.enqueue({
                flags: header.flags,
                data,
            });
        },
    });
}
/**
 * Compress an EnvelopedMessage.
 *
 * Raises Internal if an enveloped message is already compressed.
 *
 * @private Internal code, does not follow semantic versioning.
 */
async function envelopeCompress(envelope, compression, compressMinBytes) {
    let { flags, data } = envelope;
    if ((flags & _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag) === _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("invalid envelope, already compressed", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Internal);
    }
    if (compression && data.byteLength >= compressMinBytes) {
        data = await compression.compress(data);
        flags = flags | _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag;
    }
    return { data, flags };
}
/**
 * Decompress an EnvelopedMessage.
 *
 * Raises InvalidArgument if an envelope is compressed, but compression is null.
 *
 * Relies on the provided Compression to raise ResourceExhausted if the
 * *decompressed* message size is larger than readMaxBytes. If the envelope is
 * not compressed, readMaxBytes is not honored.
 *
 * @private Internal code, does not follow semantic versioning.
 */
async function envelopeDecompress(envelope, compression, readMaxBytes) {
    let { flags, data } = envelope;
    if ((flags & _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag) === _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag) {
        if (!compression) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("received compressed envelope, but do not know how to decompress", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
        }
        data = await compression.decompress(data, readMaxBytes);
        flags = flags ^ _compression_js__WEBPACK_IMPORTED_MODULE_2__.compressedFlag;
    }
    return { data, flags };
}
/**
 * Encode a single enveloped message.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function encodeEnvelope(flags, data) {
    const bytes = new Uint8Array(data.length + 5);
    bytes.set(data, 5);
    const v = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
    v.setUint8(0, flags); // first byte is flags
    v.setUint32(1, data.length); // 4 bytes message length
    return bytes;
}
/**
 * Encode a set of enveloped messages.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function encodeEnvelopes(...envelopes) {
    const len = envelopes.reduce((previousValue, currentValue) => previousValue + currentValue.data.length + 5, 0);
    const bytes = new Uint8Array(len);
    const v = new DataView(bytes.buffer);
    let offset = 0;
    for (const e of envelopes) {
        v.setUint8(offset, e.flags); // first byte is flags
        v.setUint32(offset + 1, e.data.length); // 4 bytes message length
        bytes.set(e.data, offset + 5);
        offset += e.data.length + 5;
    }
    return bytes;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/limit-io.js":
/*!************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/limit-io.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertReadMaxBytes: () => (/* binding */ assertReadMaxBytes),
/* harmony export */   assertWriteMaxBytes: () => (/* binding */ assertWriteMaxBytes),
/* harmony export */   validateReadWriteMaxBytes: () => (/* binding */ validateReadWriteMaxBytes)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * At most, allow ~4GiB to be received or sent per message.
 * zlib used by Node.js caps maxOutputLength at this value. It also happens to
 * be the maximum theoretical message size supported by protobuf-es.
 */
const maxReadMaxBytes = 0xffffffff;
const maxWriteMaxBytes = maxReadMaxBytes;
/**
 * The default value for the compressMinBytes option. The CPU cost of compressing
 * very small messages usually isn't worth the small reduction in network I/O, so
 * the default value is 1 kibibyte.
 */
const defaultCompressMinBytes = 1024;
/**
 * Asserts that the options writeMaxBytes, readMaxBytes, and compressMinBytes
 * are within sane limits, and returns default values where no value is
 * provided.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateReadWriteMaxBytes(readMaxBytes, writeMaxBytes, compressMinBytes) {
    writeMaxBytes !== null && writeMaxBytes !== void 0 ? writeMaxBytes : (writeMaxBytes = maxWriteMaxBytes);
    readMaxBytes !== null && readMaxBytes !== void 0 ? readMaxBytes : (readMaxBytes = maxReadMaxBytes);
    compressMinBytes !== null && compressMinBytes !== void 0 ? compressMinBytes : (compressMinBytes = defaultCompressMinBytes);
    if (writeMaxBytes < 1 || writeMaxBytes > maxWriteMaxBytes) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`writeMaxBytes ${writeMaxBytes} must be >= 1 and <= ${maxWriteMaxBytes}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Internal);
    }
    if (readMaxBytes < 1 || readMaxBytes > maxReadMaxBytes) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`readMaxBytes ${readMaxBytes} must be >= 1 and <= ${maxReadMaxBytes}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Internal);
    }
    return {
        readMaxBytes,
        writeMaxBytes,
        compressMinBytes,
    };
}
/**
 * Raise an error ResourceExhausted if more than writeMaxByte are written.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function assertWriteMaxBytes(writeMaxBytes, bytesWritten) {
    if (bytesWritten > writeMaxBytes) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`message size ${bytesWritten} is larger than configured writeMaxBytes ${writeMaxBytes}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.ResourceExhausted);
    }
}
/**
 * Raise an error ResourceExhausted if more than readMaxBytes are read.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function assertReadMaxBytes(readMaxBytes, bytesRead, totalSizeKnown = false) {
    if (bytesRead > readMaxBytes) {
        let message = `message size is larger than configured readMaxBytes ${readMaxBytes}`;
        if (totalSizeKnown) {
            message = `message size ${bytesRead} is larger than configured readMaxBytes ${readMaxBytes}`;
        }
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(message, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.ResourceExhausted);
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/normalize.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/normalize.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalize: () => (/* binding */ normalize),
/* harmony export */   normalizeIterable: () => (/* binding */ normalizeIterable)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 *  Takes a partial protobuf messages of the
 *  specified message type as input, and returns full instances.
 */
function normalize(type, message) {
    return message instanceof type
        ? message
        : new type(message);
}
/**
 * Takes an AsyncIterable of partial protobuf messages of the
 * specified message type as input, and yields full instances.
 */
function normalizeIterable(messageType, input) {
    function transform(result) {
        if (result.done === true) {
            return result;
        }
        return {
            done: result.done,
            value: normalize(messageType, result.value),
        };
    }
    return {
        [Symbol.asyncIterator]() {
            const it = input[Symbol.asyncIterator]();
            const res = {
                next: () => it.next().then(transform),
            };
            if (it.throw !== undefined) {
                res.throw = (e) => it.throw(e).then(transform); // eslint-disable-line @typescript-eslint/no-non-null-assertion
            }
            if (it.return !== undefined) {
                res.return = (v) => it.return(v).then(transform); // eslint-disable-line @typescript-eslint/no-non-null-assertion
            }
            return res;
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/run-call.js":
/*!************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/run-call.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   runStreamingCall: () => (/* binding */ runStreamingCall),
/* harmony export */   runUnaryCall: () => (/* binding */ runUnaryCall)
/* harmony export */ });
/* harmony import */ var _interceptor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../interceptor.js */ "./node_modules/@connectrpc/connect/dist/esm/interceptor.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _signals_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./signals.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/signals.js");
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./normalize.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/normalize.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Runs a unary method with the given interceptors. Note that this function
 * is only used when implementing a Transport.
 */
function runUnaryCall(opt) {
    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_0__.applyInterceptors)(opt.next, opt.interceptors);
    const [signal, abort, done] = setupSignal(opt);
    const req = Object.assign(Object.assign({}, opt.req), { message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_1__.normalize)(opt.req.method.I, opt.req.message), signal });
    return next(req).then((res) => {
        done();
        return res;
    }, abort);
}
/**
 * Runs a server-streaming method with the given interceptors. Note that this
 * function is only used when implementing a Transport.
 */
function runStreamingCall(opt) {
    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_0__.applyInterceptors)(opt.next, opt.interceptors);
    const [signal, abort, done] = setupSignal(opt);
    const req = Object.assign(Object.assign({}, opt.req), { message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_1__.normalizeIterable)(opt.req.method.I, opt.req.message), signal });
    let doneCalled = false;
    // Call return on the request iterable to indicate
    // that we will no longer consume it and it should
    // cleanup any allocated resources.
    signal.addEventListener("abort", function () {
        var _a, _b;
        const it = opt.req.message[Symbol.asyncIterator]();
        // If the signal is aborted due to an error, we want to throw
        // the error to the request iterator.
        if (!doneCalled) {
            (_a = it.throw) === null || _a === void 0 ? void 0 : _a.call(it, this.reason).catch(() => {
                // throw returns a promise, which we don't care about.
                //
                // Uncaught promises are thrown at sometime/somewhere by the event loop,
                // this is to ensure error is caught and ignored.
            });
        }
        (_b = it.return) === null || _b === void 0 ? void 0 : _b.call(it).catch(() => {
            // return returns a promise, which we don't care about.
            //
            // Uncaught promises are thrown at sometime/somewhere by the event loop,
            // this is to ensure error is caught and ignored.
        });
    });
    return next(req).then((res) => {
        return Object.assign(Object.assign({}, res), { message: {
                [Symbol.asyncIterator]() {
                    const it = res.message[Symbol.asyncIterator]();
                    return {
                        next() {
                            return it.next().then((r) => {
                                if (r.done == true) {
                                    doneCalled = true;
                                    done();
                                }
                                return r;
                            }, abort);
                        },
                        // We deliberately omit throw/return.
                    };
                },
            } });
    }, abort);
}
/**
 * Create an AbortSignal for Transport implementations. The signal is available
 * in UnaryRequest and StreamingRequest, and is triggered when the call is
 * aborted (via a timeout or explicit cancellation), errored (e.g. when reading
 * an error from the server from the wire), or finished successfully.
 *
 * Transport implementations can pass the signal to HTTP clients to ensure that
 * there are no unused connections leak.
 *
 * Returns a tuple:
 * [0]: The signal, which is also aborted if the optional deadline is reached.
 * [1]: Function to call if the Transport encountered an error.
 * [2]: Function to call if the Transport finished without an error.
 */
function setupSignal(opt) {
    const { signal, cleanup } = (0,_signals_js__WEBPACK_IMPORTED_MODULE_2__.createDeadlineSignal)(opt.timeoutMs);
    const controller = (0,_signals_js__WEBPACK_IMPORTED_MODULE_2__.createLinkedAbortController)(opt.signal, signal);
    return [
        controller.signal,
        function abort(reason) {
            // We peek at the deadline signal because fetch() will throw an error on
            // abort that discards the signal reason.
            const e = _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError.from(signal.aborted ? (0,_signals_js__WEBPACK_IMPORTED_MODULE_2__.getAbortSignalReason)(signal) : reason);
            controller.abort(e);
            cleanup();
            return Promise.reject(e);
        },
        function done() {
            cleanup();
            controller.abort();
        },
    ];
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createBinarySerialization: () => (/* binding */ createBinarySerialization),
/* harmony export */   createClientMethodSerializers: () => (/* binding */ createClientMethodSerializers),
/* harmony export */   createJsonSerialization: () => (/* binding */ createJsonSerialization),
/* harmony export */   createMethodSerializationLookup: () => (/* binding */ createMethodSerializationLookup),
/* harmony export */   getJsonOptions: () => (/* binding */ getJsonOptions),
/* harmony export */   limitSerialization: () => (/* binding */ limitSerialization)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _limit_io_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./limit-io.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/limit-io.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Sets default JSON serialization options for connect-es.
 *
 * With standard protobuf JSON serialization, unknown JSON fields are
 * rejected by default. In connect-es, unknown JSON fields are ignored
 * by default.
 */
function getJsonOptions(options) {
    var _a;
    const o = Object.assign({}, options);
    (_a = o.ignoreUnknownFields) !== null && _a !== void 0 ? _a : (o.ignoreUnknownFields = true);
    return o;
}
/**
 * Create an object that provides convenient access to request and response
 * message serialization for a given method.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createMethodSerializationLookup(method, binaryOptions, jsonOptions, limitOptions) {
    const inputBinary = limitSerialization(createBinarySerialization(method.I, binaryOptions), limitOptions);
    const inputJson = limitSerialization(createJsonSerialization(method.I, jsonOptions), limitOptions);
    const outputBinary = limitSerialization(createBinarySerialization(method.O, binaryOptions), limitOptions);
    const outputJson = limitSerialization(createJsonSerialization(method.O, jsonOptions), limitOptions);
    return {
        getI(useBinaryFormat) {
            return useBinaryFormat ? inputBinary : inputJson;
        },
        getO(useBinaryFormat) {
            return useBinaryFormat ? outputBinary : outputJson;
        },
    };
}
/**
 * Returns functions to normalize and serialize the input message
 * of an RPC, and to parse the output message of an RPC.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createClientMethodSerializers(method, useBinaryFormat, jsonOptions, binaryOptions) {
    const input = useBinaryFormat
        ? createBinarySerialization(method.I, binaryOptions)
        : createJsonSerialization(method.I, jsonOptions);
    const output = useBinaryFormat
        ? createBinarySerialization(method.O, binaryOptions)
        : createJsonSerialization(method.O, jsonOptions);
    return { parse: output.parse, serialize: input.serialize };
}
/**
 * Apply I/O limits to a Serialization object, returning a new object.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function limitSerialization(serialization, limitOptions) {
    return {
        serialize(data) {
            const bytes = serialization.serialize(data);
            (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_0__.assertWriteMaxBytes)(limitOptions.writeMaxBytes, bytes.byteLength);
            return bytes;
        },
        parse(data) {
            (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_0__.assertReadMaxBytes)(limitOptions.readMaxBytes, data.byteLength, true);
            return serialization.parse(data);
        },
    };
}
/**
 * Creates a Serialization object for serializing the given protobuf message
 * with the protobuf binary format.
 */
function createBinarySerialization(messageType, options) {
    return {
        parse(data) {
            try {
                return messageType.fromBinary(data, options);
            }
            catch (e) {
                const m = e instanceof Error ? e.message : String(e);
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`parse binary: ${m}`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
            }
        },
        serialize(data) {
            try {
                return data.toBinary(options);
            }
            catch (e) {
                const m = e instanceof Error ? e.message : String(e);
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError(`serialize binary: ${m}`, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.Internal);
            }
        },
    };
}
/**
 * Creates a Serialization object for serializing the given protobuf message
 * with the protobuf canonical JSON encoding.
 *
 * By default, unknown fields are ignored.
 */
function createJsonSerialization(messageType, options) {
    var _a, _b;
    const textEncoder = (_a = options === null || options === void 0 ? void 0 : options.textEncoder) !== null && _a !== void 0 ? _a : new TextEncoder();
    const textDecoder = (_b = options === null || options === void 0 ? void 0 : options.textDecoder) !== null && _b !== void 0 ? _b : new TextDecoder();
    const o = getJsonOptions(options);
    return {
        parse(data) {
            try {
                const json = textDecoder.decode(data);
                return messageType.fromJsonString(json, o);
            }
            catch (e) {
                throw _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError.from(e, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.InvalidArgument);
            }
        },
        serialize(data) {
            try {
                const json = data.toJsonString(o);
                return textEncoder.encode(json);
            }
            catch (e) {
                throw _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError.from(e, _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.Internal);
            }
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/signals.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/signals.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDeadlineSignal: () => (/* binding */ createDeadlineSignal),
/* harmony export */   createLinkedAbortController: () => (/* binding */ createLinkedAbortController),
/* harmony export */   getAbortSignalReason: () => (/* binding */ getAbortSignalReason)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Create an AbortController that is automatically aborted if one of the given
 * signals is aborted.
 *
 * For convenience, the linked AbortSignals can be undefined.
 *
 * If the controller or any of the signals is aborted, all event listeners are
 * removed.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createLinkedAbortController(...signals) {
    const controller = new AbortController();
    const sa = signals
        .filter((s) => s !== undefined)
        .concat(controller.signal);
    for (const signal of sa) {
        if (signal.aborted) {
            onAbort.apply(signal);
            break;
        }
        signal.addEventListener("abort", onAbort);
    }
    function onAbort() {
        if (!controller.signal.aborted) {
            controller.abort(getAbortSignalReason(this));
        }
        for (const signal of sa) {
            signal.removeEventListener("abort", onAbort);
        }
    }
    return controller;
}
/**
 * Create a deadline signal. The returned object contains an AbortSignal, but
 * also a cleanup function to stop the timer, which must be called once the
 * calling code is no longer interested in the signal.
 *
 * Ideally, we would simply use AbortSignal.timeout(), but it is not widely
 * available yet.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createDeadlineSignal(timeoutMs) {
    const controller = new AbortController();
    const listener = () => {
        controller.abort(new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("the operation timed out", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.DeadlineExceeded));
    };
    let timeoutId;
    if (timeoutMs !== undefined) {
        if (timeoutMs <= 0)
            listener();
        else
            timeoutId = setTimeout(listener, timeoutMs);
    }
    return {
        signal: controller.signal,
        cleanup: () => clearTimeout(timeoutId),
    };
}
/**
 * Returns the reason why an AbortSignal was aborted. Returns undefined if the
 * signal has not been aborted.
 *
 * The property AbortSignal.reason is not widely available. This function
 * returns an AbortError if the signal is aborted, but reason is undefined.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function getAbortSignalReason(signal) {
    if (!signal.aborted) {
        return undefined;
    }
    if (signal.reason !== undefined) {
        return signal.reason;
    }
    // AbortSignal.reason is available in Node.js v16, v18, and later,
    // and in all browsers since early 2022.
    const e = new Error("This operation was aborted");
    e.name = "AbortError";
    return e;
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_connectrpc_connect_dist_esm_protocol-connect_end-stream_js-node_modules_-08d26d.788f1626067de85b3a99.js.map