"use strict";
(self["webpackChunkcodeium_jupyter"] = self["webpackChunkcodeium_jupyter"] || []).push([["vendors-node_modules_connectrpc_connect_dist_esm_index_js"],{

/***/ "./node_modules/@connectrpc/connect/dist/esm/any-client.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/any-client.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeAnyClient: () => (/* binding */ makeAnyClient)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Create any client for the given service.
 *
 * The given createMethod function is called for each method definition
 * of the service. The function it returns is added to the client object
 * as a method.
 */
function makeAnyClient(service, createMethod) {
    const client = {};
    for (const [localName, methodInfo] of Object.entries(service.methods)) {
        const method = createMethod(Object.assign(Object.assign({}, methodInfo), { localName,
            service }));
        if (method != null) {
            client[localName] = method;
        }
    }
    return client;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/callback-client.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/callback-client.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCallbackClient: () => (/* binding */ createCallbackClient)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _any_client_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./any-client.js */ "./node_modules/@connectrpc/connect/dist/esm/any-client.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};





/**
 * Create a CallbackClient for the given service, invoking RPCs through the
 * given transport.
 */
function createCallbackClient(service, transport) {
    return (0,_any_client_js__WEBPACK_IMPORTED_MODULE_0__.makeAnyClient)(service, (method) => {
        switch (method.kind) {
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.Unary:
                return createUnaryFn(transport, service, method);
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.ServerStreaming:
                return createServerStreamingFn(transport, service, method);
            default:
                return null;
        }
    });
}
function createUnaryFn(transport, service, method) {
    return function (requestMessage, callback, options) {
        const abort = new AbortController();
        options = wrapSignal(abort, options);
        transport
            .unary(service, method, abort.signal, options.timeoutMs, options.headers, requestMessage, options.contextValues)
            .then((response) => {
            var _a, _b;
            (_a = options === null || options === void 0 ? void 0 : options.onHeader) === null || _a === void 0 ? void 0 : _a.call(options, response.header);
            (_b = options === null || options === void 0 ? void 0 : options.onTrailer) === null || _b === void 0 ? void 0 : _b.call(options, response.trailer);
            callback(undefined, response.message);
        }, (reason) => {
            const err = _connect_error_js__WEBPACK_IMPORTED_MODULE_2__.ConnectError.from(reason, _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Internal);
            if (err.code === _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Canceled && abort.signal.aborted) {
                // As documented, discard Canceled errors if canceled by the user.
                return;
            }
            callback(err, new method.O());
        });
        return () => abort.abort();
    };
}
function createServerStreamingFn(transport, service, method) {
    return function (input, onResponse, onClose, options) {
        const abort = new AbortController();
        async function run() {
            var _a, e_1, _b, _c;
            var _d, _e;
            options = wrapSignal(abort, options);
            const response = await transport.stream(service, method, options.signal, options.timeoutMs, options.headers, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_4__.createAsyncIterable)([input]), options.contextValues);
            (_d = options.onHeader) === null || _d === void 0 ? void 0 : _d.call(options, response.header);
            try {
                for (var _f = true, _g = __asyncValues(response.message), _h; _h = await _g.next(), _a = _h.done, !_a; _f = true) {
                    _c = _h.value;
                    _f = false;
                    const message = _c;
                    onResponse(message);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (!_f && !_a && (_b = _g.return)) await _b.call(_g);
                }
                finally { if (e_1) throw e_1.error; }
            }
            (_e = options.onTrailer) === null || _e === void 0 ? void 0 : _e.call(options, response.trailer);
            onClose(undefined);
        }
        run().catch((reason) => {
            const err = _connect_error_js__WEBPACK_IMPORTED_MODULE_2__.ConnectError.from(reason, _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Internal);
            if (err.code === _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Canceled && abort.signal.aborted) {
                // As documented, discard Canceled errors if canceled by the user,
                // but do invoke the close-callback.
                onClose(undefined);
            }
            else {
                onClose(err);
            }
        });
        return () => abort.abort();
    };
}
function wrapSignal(abort, options) {
    if (options === null || options === void 0 ? void 0 : options.signal) {
        options.signal.addEventListener("abort", () => abort.abort());
        if (options.signal.aborted) {
            abort.abort();
        }
    }
    return Object.assign(Object.assign({}, options), { signal: abort.signal });
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/context-values.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/context-values.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createContextKey: () => (/* binding */ createContextKey),
/* harmony export */   createContextValues: () => (/* binding */ createContextValues)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * createContextValues creates a new ContextValues.
 */
function createContextValues() {
    return {
        get(key) {
            return key.id in this ? this[key.id] : key.defaultValue;
        },
        set(key, value) {
            this[key.id] = value;
            return this;
        },
        delete(key) {
            delete this[key.id];
            return this;
        },
    };
}
/**
 * createContextKey creates a new ContextKey.
 */
function createContextKey(defaultValue, options) {
    return { id: Symbol(options === null || options === void 0 ? void 0 : options.description), defaultValue };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/cors.js":
/*!***********************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/cors.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cors: () => (/* binding */ cors)
/* harmony export */ });
/* harmony import */ var _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./protocol-connect/headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./protocol-grpc-web/headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
/* harmony import */ var _protocol_grpc_web_headers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./protocol-grpc-web/headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/headers.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * CORS prevents rogue scripts in a web browser from making arbitrary requests
 * to other web servers.
 *
 * This object provides helpful constants to configure CORS middleware for
 * cross-domain requests with the protocols supported by Connect.
 *
 * Make sure to add application-specific headers that your application
 * uses as well.
 */
const cors = {
    /**
     * Request methods that scripts running in the browser are permitted to use.
     *
     * To support cross-domain requests with the protocols supported by Connect,
     * these headers fields must be included in the preflight response header
     * Access-Control-Allow-Methods.
     */
    allowedMethods: ["POST", "GET"],
    /**
     * Header fields that scripts running in the browser are permitted to send.
     *
     * To support cross-domain requests with the protocols supported by Connect,
     * these field names must be included in the preflight response header
     * Access-Control-Allow-Headers.
     *
     * Make sure to include any application-specific headers your browser client
     * may send.
     */
    allowedHeaders: [
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerContentType,
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerProtocolVersion,
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerTimeout,
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStreamEncoding, // Unused in web browsers, but added for future-proofing
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStreamAcceptEncoding, // Unused in web browsers, but added for future-proofing
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUnaryEncoding, // Unused in web browsers, but added for future-proofing
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUnaryAcceptEncoding, // Unused in web browsers, but added for future-proofing
        _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerMessageType, // Unused in web browsers, but added for future-proofing
        _protocol_grpc_web_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerXGrpcWeb,
        _protocol_grpc_web_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerXUserAgent,
        _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerTimeout,
    ],
    /**
     * Header fields that scripts running the browser are permitted to see.
     *
     * To support cross-domain requests with the protocols supported by Connect,
     * these field names must be included in header Access-Control-Expose-Headers
     * of the actual response.
     *
     * Make sure to include any application-specific headers your browser client
     * should see. If your application uses trailers, they will be sent as header
     * fields with a `Trailer-` prefix for Connect unary RPCs - make sure to
     * expose them as well if you want them to be visible in all supported
     * protocols.
     */
    exposedHeaders: [
        _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerGrpcStatus, // Crucial for gRPC-web
        _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerGrpcMessage, // Crucial for gRPC-web
        _protocol_grpc_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerStatusDetailsBin, // Error details in gRPC, gRPC-web
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUnaryEncoding, // Unused in web browsers, but added for future-proofing
        _protocol_connect_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerStreamEncoding, // Unused in web browsers, but added for future-proofing
    ],
};


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/implementation.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/implementation.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHandlerContext: () => (/* binding */ createHandlerContext),
/* harmony export */   createMethodImplSpec: () => (/* binding */ createMethodImplSpec),
/* harmony export */   createServiceImplSpec: () => (/* binding */ createServiceImplSpec)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _protocol_signals_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./protocol/signals.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/signals.js");
/* harmony import */ var _context_values_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context-values.js */ "./node_modules/@connectrpc/connect/dist/esm/context-values.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Create a new HandlerContext.
 *
 * The context is usually automatically created by handlers, but if a service
 * implementation is used in unit tests, this function can be used to create
 * a context.
 */
function createHandlerContext(init) {
    var _a;
    let timeoutMs;
    if (init.timeoutMs !== undefined) {
        const date = new Date(Date.now() + init.timeoutMs);
        timeoutMs = () => date.getTime() - Date.now();
    }
    else {
        timeoutMs = () => undefined;
    }
    const deadline = (0,_protocol_signals_js__WEBPACK_IMPORTED_MODULE_0__.createDeadlineSignal)(init.timeoutMs);
    const abortController = (0,_protocol_signals_js__WEBPACK_IMPORTED_MODULE_0__.createLinkedAbortController)(deadline.signal, init.requestSignal, init.shutdownSignal);
    return Object.assign(Object.assign({}, init), { signal: abortController.signal, timeoutMs, requestHeader: new Headers(init.requestHeader), responseHeader: new Headers(init.responseHeader), responseTrailer: new Headers(init.responseTrailer), abort(reason) {
            deadline.cleanup();
            abortController.abort(reason);
        }, values: (_a = init.contextValues) !== null && _a !== void 0 ? _a : (0,_context_values_js__WEBPACK_IMPORTED_MODULE_1__.createContextValues)() });
}
/**
 * Create an MethodImplSpec - a user-provided implementation for a method,
 * wrapped in a discriminated union type along with service and method metadata.
 */
function createMethodImplSpec(service, method, impl) {
    return {
        kind: method.kind,
        service,
        method,
        impl,
    };
}
/**
 * Create an ServiceImplSpec - a user-provided service implementation wrapped
 * with metadata.
 */
function createServiceImplSpec(service, impl) {
    const s = { service, methods: {} };
    for (const [localName, methodInfo] of Object.entries(service.methods)) {
        let fn = impl[localName];
        if (typeof fn == "function") {
            fn = fn.bind(impl);
        }
        else {
            const message = `${service.typeName}.${methodInfo.name} is not implemented`;
            fn = function unimplemented() {
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_2__.ConnectError(message, _code_js__WEBPACK_IMPORTED_MODULE_3__.Code.Unimplemented);
            };
        }
        s.methods[localName] = createMethodImplSpec(service, methodInfo, fn);
    }
    return s;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Code: () => (/* reexport safe */ _code_js__WEBPACK_IMPORTED_MODULE_1__.Code),
/* harmony export */   ConnectError: () => (/* reexport safe */ _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError),
/* harmony export */   appendHeaders: () => (/* reexport safe */ _http_headers_js__WEBPACK_IMPORTED_MODULE_2__.appendHeaders),
/* harmony export */   cors: () => (/* reexport safe */ _cors_js__WEBPACK_IMPORTED_MODULE_7__.cors),
/* harmony export */   createCallbackClient: () => (/* reexport safe */ _callback_client_js__WEBPACK_IMPORTED_MODULE_3__.createCallbackClient),
/* harmony export */   createConnectRouter: () => (/* reexport safe */ _router_js__WEBPACK_IMPORTED_MODULE_5__.createConnectRouter),
/* harmony export */   createContextKey: () => (/* reexport safe */ _context_values_js__WEBPACK_IMPORTED_MODULE_8__.createContextKey),
/* harmony export */   createContextValues: () => (/* reexport safe */ _context_values_js__WEBPACK_IMPORTED_MODULE_8__.createContextValues),
/* harmony export */   createHandlerContext: () => (/* reexport safe */ _implementation_js__WEBPACK_IMPORTED_MODULE_6__.createHandlerContext),
/* harmony export */   createMethodImplSpec: () => (/* reexport safe */ _implementation_js__WEBPACK_IMPORTED_MODULE_6__.createMethodImplSpec),
/* harmony export */   createPromiseClient: () => (/* reexport safe */ _promise_client_js__WEBPACK_IMPORTED_MODULE_4__.createPromiseClient),
/* harmony export */   createRouterTransport: () => (/* reexport safe */ _router_transport_js__WEBPACK_IMPORTED_MODULE_10__.createRouterTransport),
/* harmony export */   createServiceImplSpec: () => (/* reexport safe */ _implementation_js__WEBPACK_IMPORTED_MODULE_6__.createServiceImplSpec),
/* harmony export */   decodeBinaryHeader: () => (/* reexport safe */ _http_headers_js__WEBPACK_IMPORTED_MODULE_2__.decodeBinaryHeader),
/* harmony export */   encodeBinaryHeader: () => (/* reexport safe */ _http_headers_js__WEBPACK_IMPORTED_MODULE_2__.encodeBinaryHeader),
/* harmony export */   makeAnyClient: () => (/* reexport safe */ _any_client_js__WEBPACK_IMPORTED_MODULE_9__.makeAnyClient)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _http_headers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./http-headers.js */ "./node_modules/@connectrpc/connect/dist/esm/http-headers.js");
/* harmony import */ var _callback_client_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./callback-client.js */ "./node_modules/@connectrpc/connect/dist/esm/callback-client.js");
/* harmony import */ var _promise_client_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./promise-client.js */ "./node_modules/@connectrpc/connect/dist/esm/promise-client.js");
/* harmony import */ var _router_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./router.js */ "./node_modules/@connectrpc/connect/dist/esm/router.js");
/* harmony import */ var _implementation_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/implementation.js");
/* harmony import */ var _cors_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./cors.js */ "./node_modules/@connectrpc/connect/dist/esm/cors.js");
/* harmony import */ var _context_values_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./context-values.js */ "./node_modules/@connectrpc/connect/dist/esm/context-values.js");
/* harmony import */ var _any_client_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./any-client.js */ "./node_modules/@connectrpc/connect/dist/esm/any-client.js");
/* harmony import */ var _router_transport_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./router-transport.js */ "./node_modules/@connectrpc/connect/dist/esm/router-transport.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.









// Symbols above should be relevant to end users.
// Symbols below should only be relevant for other libraries.





/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/promise-client.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/promise-client.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createBiDiStreamingFn: () => (/* binding */ createBiDiStreamingFn),
/* harmony export */   createClientStreamingFn: () => (/* binding */ createClientStreamingFn),
/* harmony export */   createPromiseClient: () => (/* binding */ createPromiseClient),
/* harmony export */   createServerStreamingFn: () => (/* binding */ createServerStreamingFn),
/* harmony export */   createUnaryFn: () => (/* binding */ createUnaryFn)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _any_client_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./any-client.js */ "./node_modules/@connectrpc/connect/dist/esm/any-client.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncDelegator = (undefined && undefined.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
};
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};





/**
 * Create a PromiseClient for the given service, invoking RPCs through the
 * given transport.
 */
function createPromiseClient(service, transport) {
    return (0,_any_client_js__WEBPACK_IMPORTED_MODULE_0__.makeAnyClient)(service, (method) => {
        switch (method.kind) {
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.Unary:
                return createUnaryFn(transport, service, method);
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.ServerStreaming:
                return createServerStreamingFn(transport, service, method);
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.ClientStreaming:
                return createClientStreamingFn(transport, service, method);
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_1__.MethodKind.BiDiStreaming:
                return createBiDiStreamingFn(transport, service, method);
            default:
                return null;
        }
    });
}
function createUnaryFn(transport, service, method) {
    return async function (input, options) {
        var _a, _b;
        const response = await transport.unary(service, method, options === null || options === void 0 ? void 0 : options.signal, options === null || options === void 0 ? void 0 : options.timeoutMs, options === null || options === void 0 ? void 0 : options.headers, input, options === null || options === void 0 ? void 0 : options.contextValues);
        (_a = options === null || options === void 0 ? void 0 : options.onHeader) === null || _a === void 0 ? void 0 : _a.call(options, response.header);
        (_b = options === null || options === void 0 ? void 0 : options.onTrailer) === null || _b === void 0 ? void 0 : _b.call(options, response.trailer);
        return response.message;
    };
}
function createServerStreamingFn(transport, service, method) {
    return function (input, options) {
        return handleStreamResponse(transport.stream(service, method, options === null || options === void 0 ? void 0 : options.signal, options === null || options === void 0 ? void 0 : options.timeoutMs, options === null || options === void 0 ? void 0 : options.headers, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_2__.createAsyncIterable)([input]), options === null || options === void 0 ? void 0 : options.contextValues), options);
    };
}
function createClientStreamingFn(transport, service, method) {
    return async function (request, options) {
        var _a, e_1, _b, _c;
        var _d, _e;
        const response = await transport.stream(service, method, options === null || options === void 0 ? void 0 : options.signal, options === null || options === void 0 ? void 0 : options.timeoutMs, options === null || options === void 0 ? void 0 : options.headers, request, options === null || options === void 0 ? void 0 : options.contextValues);
        (_d = options === null || options === void 0 ? void 0 : options.onHeader) === null || _d === void 0 ? void 0 : _d.call(options, response.header);
        let singleMessage;
        try {
            for (var _f = true, _g = __asyncValues(response.message), _h; _h = await _g.next(), _a = _h.done, !_a; _f = true) {
                _c = _h.value;
                _f = false;
                const message = _c;
                singleMessage = message;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (!_f && !_a && (_b = _g.return)) await _b.call(_g);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (!singleMessage) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError("protocol error: missing response message", _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.Internal);
        }
        (_e = options === null || options === void 0 ? void 0 : options.onTrailer) === null || _e === void 0 ? void 0 : _e.call(options, response.trailer);
        return singleMessage;
    };
}
function createBiDiStreamingFn(transport, service, method) {
    return function (request, options) {
        return handleStreamResponse(transport.stream(service, method, options === null || options === void 0 ? void 0 : options.signal, options === null || options === void 0 ? void 0 : options.timeoutMs, options === null || options === void 0 ? void 0 : options.headers, request, options === null || options === void 0 ? void 0 : options.contextValues), options);
    };
}
function handleStreamResponse(stream, options) {
    const it = (function () {
        var _a, _b;
        return __asyncGenerator(this, arguments, function* () {
            const response = yield __await(stream);
            (_a = options === null || options === void 0 ? void 0 : options.onHeader) === null || _a === void 0 ? void 0 : _a.call(options, response.header);
            yield __await(yield* __asyncDelegator(__asyncValues(response.message)));
            (_b = options === null || options === void 0 ? void 0 : options.onTrailer) === null || _b === void 0 ? void 0 : _b.call(options, response.trailer);
        });
    })()[Symbol.asyncIterator]();
    // Create a new iterable to omit throw/return.
    return {
        [Symbol.asyncIterator]: () => ({
            next: () => it.next(),
        }),
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/handler-factory.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/handler-factory.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHandlerFactory: () => (/* binding */ createHandlerFactory)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/proto-base64.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _implementation_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/implementation.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/content-type.js");
/* harmony import */ var _end_stream_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./end-stream.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/end-stream.js");
/* harmony import */ var _error_json_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./error-json.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _http_status_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./http-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/http-status.js");
/* harmony import */ var _parse_timeout_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./parse-timeout.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/parse-timeout.js");
/* harmony import */ var _query_params_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./query-params.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/query-params.js");
/* harmony import */ var _trailer_mux_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./trailer-mux.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/trailer-mux.js");
/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./version.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/version.js");
/* harmony import */ var _protocol_compression_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../protocol/compression.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js");
/* harmony import */ var _protocol_serialization_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../protocol/serialization.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol/universal-handler.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js");
/* harmony import */ var _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../protocol/universal.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
/* harmony import */ var _protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../protocol/content-type-matcher.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js");
/* harmony import */ var _protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../protocol/create-method-url.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../protocol/invoke-implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/invoke-implementation.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





















const protocolName = "connect";
const methodPost = "POST";
const methodGet = "GET";
/**
 * Create a factory that creates Connect handlers.
 */
function createHandlerFactory(options) {
    const opt = (0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.validateUniversalHandlerOptions)(options);
    const endStreamSerialization = (0,_end_stream_js__WEBPACK_IMPORTED_MODULE_1__.createEndStreamSerialization)(opt.jsonOptions);
    function fact(spec) {
        let h;
        let contentTypeRegExp;
        const serialization = (0,_protocol_serialization_js__WEBPACK_IMPORTED_MODULE_2__.createMethodSerializationLookup)(spec.method, opt.binaryOptions, opt.jsonOptions, opt);
        switch (spec.kind) {
            case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodKind.Unary:
                contentTypeRegExp = _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeUnaryRegExp;
                h = createUnaryHandler(opt, spec, serialization);
                break;
            default:
                contentTypeRegExp = _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeStreamRegExp;
                h = createStreamHandler(opt, spec, serialization, endStreamSerialization);
                break;
        }
        const allowedMethods = [methodPost];
        if (spec.method.idempotency === _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodIdempotency.NoSideEffects) {
            allowedMethods.push(methodGet);
        }
        return Object.assign(h, {
            protocolNames: [protocolName],
            supportedContentType: (0,_protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_5__.contentTypeMatcher)(contentTypeRegExp),
            allowedMethods,
            requestPath: (0,_protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_6__.createMethodUrl)("/", spec.service, spec.method),
            service: spec.service,
            method: spec.method,
        });
    }
    fact.protocolName = protocolName;
    return fact;
}
function createUnaryHandler(opt, spec, serialization) {
    return async function handle(req) {
        const isGet = req.method == methodGet;
        if (isGet && spec.method.idempotency != _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodIdempotency.NoSideEffects) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseMethodNotAllowed;
        }
        const queryParams = new URL(req.url).searchParams;
        const compressionRequested = isGet
            ? queryParams.get(_query_params_js__WEBPACK_IMPORTED_MODULE_8__.paramCompression)
            : req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryEncoding);
        const type = isGet
            ? (0,_content_type_js__WEBPACK_IMPORTED_MODULE_4__.parseEncodingQuery)(queryParams.get(_query_params_js__WEBPACK_IMPORTED_MODULE_8__.paramEncoding))
            : (0,_content_type_js__WEBPACK_IMPORTED_MODULE_4__.parseContentType)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerContentType));
        if (type == undefined || type.stream) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseUnsupportedMediaType;
        }
        const timeout = (0,_parse_timeout_js__WEBPACK_IMPORTED_MODULE_10__.parseTimeout)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerTimeout), opt.maxTimeoutMs);
        const context = (0,_implementation_js__WEBPACK_IMPORTED_MODULE_11__.createHandlerContext)(Object.assign(Object.assign({}, spec), { requestMethod: req.method, protocolName, timeoutMs: timeout.timeoutMs, shutdownSignal: opt.shutdownSignal, requestSignal: req.signal, requestHeader: req.header, url: req.url, responseHeader: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerContentType]: type.binary
                    ? _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeUnaryProto
                    : _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeUnaryJson,
            }, contextValues: req.contextValues }));
        const compression = (0,_protocol_compression_js__WEBPACK_IMPORTED_MODULE_12__.compressionNegotiate)(opt.acceptCompression, compressionRequested, req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryAcceptEncoding), _headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryAcceptEncoding);
        let status = _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseOk.status;
        let body;
        try {
            if (opt.requireConnectProtocolHeader) {
                if (isGet) {
                    (0,_version_js__WEBPACK_IMPORTED_MODULE_13__.requireProtocolVersionParam)(queryParams);
                }
                else {
                    (0,_version_js__WEBPACK_IMPORTED_MODULE_13__.requireProtocolVersionHeader)(req.header);
                }
            }
            // raise compression error to serialize it as a error response
            if (compression.error) {
                throw compression.error;
            }
            // raise timeout parsing error to serialize it as a trailer status
            if (timeout.error) {
                throw timeout.error;
            }
            let reqBody;
            if (isGet) {
                reqBody = await readUnaryMessageFromQuery(opt.readMaxBytes, compression.request, queryParams);
            }
            else {
                reqBody = await readUnaryMessageFromBody(opt.readMaxBytes, compression.request, req);
            }
            const input = parseUnaryMessage(spec.method, type.binary, serialization, reqBody);
            const output = await (0,_protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_14__.invokeUnaryImplementation)(spec, context, input, opt.interceptors);
            body = serialization.getO(type.binary).serialize(output);
        }
        catch (e) {
            let error;
            if (e instanceof _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError) {
                error = e;
            }
            else {
                error = new _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError("internal error", _code_js__WEBPACK_IMPORTED_MODULE_16__.Code.Internal, undefined, undefined, e);
            }
            status = (0,_http_status_js__WEBPACK_IMPORTED_MODULE_17__.codeToHttpStatus)(error.code);
            context.responseHeader.set(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerContentType, _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeUnaryJson);
            error.metadata.forEach((value, key) => {
                context.responseHeader.set(key, value);
            });
            body = (0,_error_json_js__WEBPACK_IMPORTED_MODULE_18__.errorToJsonBytes)(error, opt.jsonOptions);
        }
        finally {
            context.abort();
        }
        if (compression.response && body.byteLength >= opt.compressMinBytes) {
            body = await compression.response.compress(body);
            context.responseHeader.set(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryEncoding, compression.response.name);
        }
        const header = (0,_trailer_mux_js__WEBPACK_IMPORTED_MODULE_19__.trailerMux)(context.responseHeader, context.responseTrailer);
        header.set(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryContentLength, body.byteLength.toString(10));
        return {
            status,
            body: (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.createAsyncIterable)([body]),
            header,
        };
    };
}
async function readUnaryMessageFromBody(readMaxBytes, compression, request) {
    if (typeof request.body == "object" &&
        request.body !== null &&
        Symbol.asyncIterator in request.body) {
        let reqBytes = await (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.readAllBytes)(request.body, readMaxBytes, request.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerUnaryContentLength));
        if (compression) {
            reqBytes = await compression.decompress(reqBytes, readMaxBytes);
        }
        return reqBytes;
    }
    return request.body;
}
async function readUnaryMessageFromQuery(readMaxBytes, compression, queryParams) {
    var _a;
    const base64 = queryParams.get(_query_params_js__WEBPACK_IMPORTED_MODULE_8__.paramBase64);
    const message = (_a = queryParams.get(_query_params_js__WEBPACK_IMPORTED_MODULE_8__.paramMessage)) !== null && _a !== void 0 ? _a : "";
    let decoded;
    if (base64 === "1") {
        decoded = _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_21__.protoBase64.dec(message);
    }
    else {
        decoded = new TextEncoder().encode(message);
    }
    if (compression) {
        decoded = await compression.decompress(decoded, readMaxBytes);
    }
    return decoded;
}
function parseUnaryMessage(method, useBinaryFormat, serialization, input) {
    if (input instanceof Uint8Array) {
        return serialization.getI(useBinaryFormat).parse(input);
    }
    if (useBinaryFormat) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError("received parsed JSON request body, but content-type indicates binary format", _code_js__WEBPACK_IMPORTED_MODULE_16__.Code.Internal);
    }
    try {
        return method.I.fromJson(input);
    }
    catch (e) {
        throw _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError.from(e, _code_js__WEBPACK_IMPORTED_MODULE_16__.Code.InvalidArgument);
    }
}
function createStreamHandler(opt, spec, serialization, endStreamSerialization) {
    return async function handle(req) {
        (0,_protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.assertByteStreamRequest)(req);
        const type = (0,_content_type_js__WEBPACK_IMPORTED_MODULE_4__.parseContentType)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerContentType));
        if (type == undefined || !type.stream) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseUnsupportedMediaType;
        }
        if (req.method !== methodPost) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseMethodNotAllowed;
        }
        const timeout = (0,_parse_timeout_js__WEBPACK_IMPORTED_MODULE_10__.parseTimeout)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerTimeout), opt.maxTimeoutMs);
        const context = (0,_implementation_js__WEBPACK_IMPORTED_MODULE_11__.createHandlerContext)(Object.assign(Object.assign({}, spec), { requestMethod: req.method, protocolName, timeoutMs: timeout.timeoutMs, shutdownSignal: opt.shutdownSignal, requestSignal: req.signal, requestHeader: req.header, url: req.url, responseHeader: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerContentType]: type.binary
                    ? _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeStreamProto
                    : _content_type_js__WEBPACK_IMPORTED_MODULE_4__.contentTypeStreamJson,
            }, contextValues: req.contextValues }));
        const compression = (0,_protocol_compression_js__WEBPACK_IMPORTED_MODULE_12__.compressionNegotiate)(opt.acceptCompression, req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerStreamEncoding), req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerStreamAcceptEncoding), _headers_js__WEBPACK_IMPORTED_MODULE_9__.headerStreamAcceptEncoding);
        if (compression.response) {
            context.responseHeader.set(_headers_js__WEBPACK_IMPORTED_MODULE_9__.headerStreamEncoding, compression.response.name);
        }
        // We split the pipeline into two parts: The request iterator, and the
        // response iterator. We do this because the request iterator is responsible
        // for parsing the request body, and we don't want write errors of the response
        // iterator to affect the request iterator.
        const inputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.pipe)(req.body, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformPrepend)(() => {
            if (opt.requireConnectProtocolHeader) {
                (0,_version_js__WEBPACK_IMPORTED_MODULE_13__.requireProtocolVersionHeader)(req.header);
            }
            // raise compression error to serialize it as the end stream response
            if (compression.error)
                throw compression.error;
            // raise timeout parsing error to serialize it as a trailer status
            if (timeout.error)
                throw timeout.error;
            return undefined;
        }), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformSplitEnvelope)(opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformDecompressEnvelope)(compression.request, opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformParseEnvelope)(serialization.getI(type.binary), _end_stream_js__WEBPACK_IMPORTED_MODULE_1__.endStreamFlag));
        const it = (0,_protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_14__.transformInvokeImplementation)(spec, context, opt.interceptors)(inputIt)[Symbol.asyncIterator]();
        const outputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.pipe)(
        // We wrap the iterator in an async iterator to ensure that the
        // abort signal is aborted when the iterator is done.
        {
            [Symbol.asyncIterator]() {
                return {
                    next: () => it.next(),
                    throw: (e) => {
                        var _a, _b;
                        context.abort(e);
                        return (_b = (_a = it.throw) === null || _a === void 0 ? void 0 : _a.call(it, e)) !== null && _b !== void 0 ? _b : Promise.reject({ done: true });
                    },
                    return: (v) => {
                        var _a, _b;
                        context.abort();
                        return ((_b = (_a = it.return) === null || _a === void 0 ? void 0 : _a.call(it, v)) !== null && _b !== void 0 ? _b : Promise.resolve({ done: true, value: v }));
                    },
                };
            },
        }, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformSerializeEnvelope)(serialization.getO(type.binary)), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformCatchFinally)((e) => {
            context.abort();
            const end = {
                metadata: context.responseTrailer,
            };
            if (e instanceof _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError) {
                end.error = e;
            }
            else if (e !== undefined) {
                end.error = new _connect_error_js__WEBPACK_IMPORTED_MODULE_15__.ConnectError("internal error", _code_js__WEBPACK_IMPORTED_MODULE_16__.Code.Internal, undefined, undefined, e);
            }
            return {
                flags: _end_stream_js__WEBPACK_IMPORTED_MODULE_1__.endStreamFlag,
                data: endStreamSerialization.serialize(end),
            };
        }), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformCompressEnvelope)(compression.response, opt.compressMinBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.transformJoinEnvelopes)(), { propagateDownStreamError: true });
        return Object.assign(Object.assign({}, _protocol_universal_js__WEBPACK_IMPORTED_MODULE_7__.uResponseOk), { 
            // We wait for the first response body bytes before resolving, so that
            // implementations have a chance to add headers before an adapter commits
            // them to the wire.
            body: await (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_20__.untilFirst)(outputIt), header: context.responseHeader });
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/parse-timeout.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/parse-timeout.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseTimeout: () => (/* binding */ parseTimeout)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Parse a Connect Timeout (Deadline) header.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseTimeout(value, maxTimeoutMs) {
    if (value === null) {
        return {};
    }
    const results = /^\d{1,10}$/.exec(value);
    if (results === null) {
        return {
            error: new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`protocol error: invalid connect timeout value: ${value}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument),
        };
    }
    const timeoutMs = parseInt(results[0]);
    if (timeoutMs > maxTimeoutMs) {
        return {
            timeoutMs: timeoutMs,
            error: new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`timeout ${timeoutMs}ms must be <= ${maxTimeoutMs}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument),
        };
    }
    return {
        timeoutMs: parseInt(results[0]),
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/transport.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-connect/transport.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTransport: () => (/* binding */ createTransport)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _request_header_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./request-header.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/request-header.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/headers.js");
/* harmony import */ var _validate_response_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./validate-response.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/validate-response.js");
/* harmony import */ var _trailer_mux_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./trailer-mux.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/trailer-mux.js");
/* harmony import */ var _error_json_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./error-json.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js");
/* harmony import */ var _end_stream_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./end-stream.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/end-stream.js");
/* harmony import */ var _get_request_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./get-request.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/get-request.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _http_headers_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../http-headers.js */ "./node_modules/@connectrpc/connect/dist/esm/http-headers.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
/* harmony import */ var _protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../protocol/create-method-url.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _protocol_run_call_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../protocol/run-call.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/run-call.js");
/* harmony import */ var _protocol_serialization_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol/serialization.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _context_values_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../context-values.js */ "./node_modules/@connectrpc/connect/dist/esm/context-values.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
















/**
 * Create a Transport for the Connect protocol.
 */
function createTransport(opt) {
    return {
        async unary(service, method, signal, timeoutMs, header, message, contextValues) {
            const serialization = (0,_protocol_serialization_js__WEBPACK_IMPORTED_MODULE_0__.createMethodSerializationLookup)(method, opt.binaryOptions, opt.jsonOptions, opt);
            timeoutMs =
                timeoutMs === undefined
                    ? opt.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return await (0,_protocol_run_call_js__WEBPACK_IMPORTED_MODULE_1__.runUnaryCall)({
                interceptors: opt.interceptors,
                signal,
                timeoutMs,
                req: {
                    stream: false,
                    service,
                    method,
                    url: (0,_protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_2__.createMethodUrl)(opt.baseUrl, service, method),
                    init: {},
                    header: (0,_request_header_js__WEBPACK_IMPORTED_MODULE_3__.requestHeaderWithCompression)(method.kind, opt.useBinaryFormat, timeoutMs, header, opt.acceptCompression, opt.sendCompression, true),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_context_values_js__WEBPACK_IMPORTED_MODULE_4__.createContextValues)(),
                    message,
                },
                next: async (req) => {
                    var _a;
                    let requestBody = serialization
                        .getI(opt.useBinaryFormat)
                        .serialize(req.message);
                    if (opt.sendCompression &&
                        requestBody.byteLength > opt.compressMinBytes) {
                        requestBody = await opt.sendCompression.compress(requestBody);
                        req.header.set(_headers_js__WEBPACK_IMPORTED_MODULE_5__.headerUnaryEncoding, opt.sendCompression.name);
                    }
                    else {
                        req.header.delete(_headers_js__WEBPACK_IMPORTED_MODULE_5__.headerUnaryEncoding);
                    }
                    const useGet = opt.useHttpGet === true &&
                        method.idempotency === _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_6__.MethodIdempotency.NoSideEffects;
                    let body;
                    if (useGet) {
                        req = (0,_get_request_js__WEBPACK_IMPORTED_MODULE_7__.transformConnectPostToGetRequest)(req, requestBody, opt.useBinaryFormat);
                    }
                    else {
                        body = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.createAsyncIterable)([requestBody]);
                    }
                    const universalResponse = await opt.httpClient({
                        url: req.url,
                        method: (_a = req.init.method) !== null && _a !== void 0 ? _a : "POST",
                        header: req.header,
                        signal: req.signal,
                        body,
                    });
                    const { compression, isUnaryError, unaryError } = (0,_validate_response_js__WEBPACK_IMPORTED_MODULE_9__.validateResponseWithCompression)(method.kind, opt.acceptCompression, universalResponse.status, universalResponse.header);
                    const [header, trailer] = (0,_trailer_mux_js__WEBPACK_IMPORTED_MODULE_10__.trailerDemux)(universalResponse.header);
                    let responseBody = await (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.pipeTo)(universalResponse.body, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.sinkAllBytes)(opt.readMaxBytes, universalResponse.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_5__.headerUnaryContentLength)), { propagateDownStreamError: false });
                    if (compression) {
                        responseBody = await compression.decompress(responseBody, opt.readMaxBytes);
                    }
                    if (isUnaryError) {
                        throw (0,_error_json_js__WEBPACK_IMPORTED_MODULE_11__.errorFromJsonBytes)(responseBody, (0,_http_headers_js__WEBPACK_IMPORTED_MODULE_12__.appendHeaders)(header, trailer), unaryError);
                    }
                    return {
                        stream: false,
                        service,
                        method,
                        header,
                        message: serialization
                            .getO(opt.useBinaryFormat)
                            .parse(responseBody),
                        trailer,
                    };
                },
            });
        },
        async stream(service, method, signal, timeoutMs, header, input, contextValues) {
            const serialization = (0,_protocol_serialization_js__WEBPACK_IMPORTED_MODULE_0__.createMethodSerializationLookup)(method, opt.binaryOptions, opt.jsonOptions, opt);
            const endStreamSerialization = (0,_end_stream_js__WEBPACK_IMPORTED_MODULE_13__.createEndStreamSerialization)(opt.jsonOptions);
            timeoutMs =
                timeoutMs === undefined
                    ? opt.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return (0,_protocol_run_call_js__WEBPACK_IMPORTED_MODULE_1__.runStreamingCall)({
                interceptors: opt.interceptors,
                signal,
                timeoutMs,
                req: {
                    stream: true,
                    service,
                    method,
                    url: (0,_protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_2__.createMethodUrl)(opt.baseUrl, service, method),
                    init: {
                        method: "POST",
                        redirect: "error",
                        mode: "cors",
                    },
                    header: (0,_request_header_js__WEBPACK_IMPORTED_MODULE_3__.requestHeaderWithCompression)(method.kind, opt.useBinaryFormat, timeoutMs, header, opt.acceptCompression, opt.sendCompression, true),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_context_values_js__WEBPACK_IMPORTED_MODULE_4__.createContextValues)(),
                    message: input,
                },
                next: async (req) => {
                    const uRes = await opt.httpClient({
                        url: req.url,
                        method: "POST",
                        header: req.header,
                        signal: req.signal,
                        body: (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.pipe)(req.message, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformSerializeEnvelope)(serialization.getI(opt.useBinaryFormat)), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformCompressEnvelope)(opt.sendCompression, opt.compressMinBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformJoinEnvelopes)(), { propagateDownStreamError: true }),
                    });
                    const { compression } = (0,_validate_response_js__WEBPACK_IMPORTED_MODULE_9__.validateResponseWithCompression)(method.kind, opt.acceptCompression, uRes.status, uRes.header);
                    const res = Object.assign(Object.assign({}, req), { header: uRes.header, trailer: new Headers(), message: (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.pipe)(uRes.body, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformSplitEnvelope)(opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformDecompressEnvelope)(compression !== null && compression !== void 0 ? compression : null, opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_8__.transformParseEnvelope)(serialization.getO(opt.useBinaryFormat), _end_stream_js__WEBPACK_IMPORTED_MODULE_13__.endStreamFlag, endStreamSerialization), function (iterable) {
                            return __asyncGenerator(this, arguments, function* () {
                                var _a, e_1, _b, _c;
                                let endStreamReceived = false;
                                try {
                                    for (var _d = true, iterable_1 = __asyncValues(iterable), iterable_1_1; iterable_1_1 = yield __await(iterable_1.next()), _a = iterable_1_1.done, !_a; _d = true) {
                                        _c = iterable_1_1.value;
                                        _d = false;
                                        const chunk = _c;
                                        if (chunk.end) {
                                            if (endStreamReceived) {
                                                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_14__.ConnectError("protocol error: received extra EndStreamResponse", _code_js__WEBPACK_IMPORTED_MODULE_15__.Code.InvalidArgument);
                                            }
                                            endStreamReceived = true;
                                            if (chunk.value.error) {
                                                const error = chunk.value.error;
                                                uRes.header.forEach((value, key) => {
                                                    error.metadata.append(key, value);
                                                });
                                                throw error;
                                            }
                                            chunk.value.metadata.forEach((value, key) => res.trailer.set(key, value));
                                            continue;
                                        }
                                        if (endStreamReceived) {
                                            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_14__.ConnectError("protocol error: received extra message after EndStreamResponse", _code_js__WEBPACK_IMPORTED_MODULE_15__.Code.InvalidArgument);
                                        }
                                        yield yield __await(chunk.value);
                                    }
                                }
                                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                                finally {
                                    try {
                                        if (!_d && !_a && (_b = iterable_1.return)) yield __await(_b.call(iterable_1));
                                    }
                                    finally { if (e_1) throw e_1.error; }
                                }
                                if (!endStreamReceived) {
                                    throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_14__.ConnectError("protocol error: missing EndStreamResponse", _code_js__WEBPACK_IMPORTED_MODULE_15__.Code.InvalidArgument);
                                }
                            });
                        }, { propagateDownStreamError: true }) });
                    return res;
                },
            });
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/handler-factory.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/handler-factory.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHandlerFactory: () => (/* binding */ createHandlerFactory)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _implementation_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/implementation.js");
/* harmony import */ var _trailer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./trailer.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/trailer.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/content-type.js");
/* harmony import */ var _protocol_grpc_parse_timeout_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../protocol-grpc/parse-timeout.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/parse-timeout.js");
/* harmony import */ var _protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../protocol-grpc/trailer-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
/* harmony import */ var _protocol_compression_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../protocol/compression.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js");
/* harmony import */ var _protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../protocol/content-type-matcher.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js");
/* harmony import */ var _protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../protocol/create-method-url.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../protocol/invoke-implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/invoke-implementation.js");
/* harmony import */ var _protocol_serialization_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../protocol/serialization.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol/universal-handler.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js");
/* harmony import */ var _protocol_universal_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../protocol/universal.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
















const protocolName = "grpc-web";
const methodPost = "POST";
/**
 * Create a factory that creates gRPC-web handlers.
 */
function createHandlerFactory(options) {
    const opt = (0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.validateUniversalHandlerOptions)(options);
    const trailerSerialization = (0,_trailer_js__WEBPACK_IMPORTED_MODULE_1__.createTrailerSerialization)();
    function fact(spec) {
        const h = createHandler(opt, trailerSerialization, spec);
        return Object.assign(h, {
            protocolNames: [protocolName],
            allowedMethods: [methodPost],
            supportedContentType: (0,_protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeMatcher)(_content_type_js__WEBPACK_IMPORTED_MODULE_3__.contentTypeRegExp),
            requestPath: (0,_protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_4__.createMethodUrl)("/", spec.service, spec.method),
            service: spec.service,
            method: spec.method,
        });
    }
    fact.protocolName = protocolName;
    return fact;
}
function createHandler(opt, trailerSerialization, spec) {
    const serialization = (0,_protocol_serialization_js__WEBPACK_IMPORTED_MODULE_5__.createMethodSerializationLookup)(spec.method, opt.binaryOptions, opt.jsonOptions, opt);
    return async function handle(req) {
        (0,_protocol_universal_js__WEBPACK_IMPORTED_MODULE_6__.assertByteStreamRequest)(req);
        const type = (0,_content_type_js__WEBPACK_IMPORTED_MODULE_3__.parseContentType)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerContentType));
        if (type == undefined || type.text) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_6__.uResponseUnsupportedMediaType;
        }
        if (req.method !== methodPost) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_6__.uResponseMethodNotAllowed;
        }
        const timeout = (0,_protocol_grpc_parse_timeout_js__WEBPACK_IMPORTED_MODULE_8__.parseTimeout)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerTimeout), opt.maxTimeoutMs);
        const context = (0,_implementation_js__WEBPACK_IMPORTED_MODULE_9__.createHandlerContext)(Object.assign(Object.assign({}, spec), { requestMethod: req.method, protocolName, timeoutMs: timeout.timeoutMs, shutdownSignal: opt.shutdownSignal, requestSignal: req.signal, requestHeader: req.header, url: req.url, responseHeader: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerContentType]: type.binary ? _content_type_js__WEBPACK_IMPORTED_MODULE_3__.contentTypeProto : _content_type_js__WEBPACK_IMPORTED_MODULE_3__.contentTypeJson,
            }, responseTrailer: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerGrpcStatus]: _protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_10__.grpcStatusOk,
            }, contextValues: req.contextValues }));
        const compression = (0,_protocol_compression_js__WEBPACK_IMPORTED_MODULE_11__.compressionNegotiate)(opt.acceptCompression, req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerEncoding), req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerAcceptEncoding), _headers_js__WEBPACK_IMPORTED_MODULE_7__.headerAcceptEncoding);
        if (compression.response) {
            context.responseHeader.set(_headers_js__WEBPACK_IMPORTED_MODULE_7__.headerEncoding, compression.response.name);
        }
        // We split the pipeline into two parts: The request iterator, and the
        // response iterator. We do this because the request iterator is responsible
        // for parsing the request body, and we don't want write errors of the response
        // iterator to affect the request iterator.
        const inputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.pipe)(req.body, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformPrepend)(() => {
            // raise compression error to serialize it as a trailer status
            if (compression.error)
                throw compression.error;
            // raise timeout parsing error to serialize it as a trailer status
            if (timeout.error)
                throw timeout.error;
            return undefined;
        }), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformSplitEnvelope)(opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformDecompressEnvelope)(compression.request, opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformParseEnvelope)(serialization.getI(type.binary), _trailer_js__WEBPACK_IMPORTED_MODULE_1__.trailerFlag));
        const it = (0,_protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_13__.transformInvokeImplementation)(spec, context, opt.interceptors)(inputIt)[Symbol.asyncIterator]();
        const outputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.pipe)(
        // We wrap the iterator in an async iterator to ensure that the
        // abort signal is aborted when the iterator is done.
        {
            [Symbol.asyncIterator]() {
                return {
                    next: () => it.next(),
                    throw: (e) => {
                        var _a, _b;
                        context.abort(e);
                        return (_b = (_a = it.throw) === null || _a === void 0 ? void 0 : _a.call(it, e)) !== null && _b !== void 0 ? _b : Promise.reject({ done: true });
                    },
                    return: (v) => {
                        var _a, _b;
                        context.abort();
                        return ((_b = (_a = it.return) === null || _a === void 0 ? void 0 : _a.call(it, v)) !== null && _b !== void 0 ? _b : Promise.resolve({ done: true, value: v }));
                    },
                };
            },
        }, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformSerializeEnvelope)(serialization.getO(type.binary)), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformCatchFinally)((e) => {
            context.abort();
            if (e instanceof _connect_error_js__WEBPACK_IMPORTED_MODULE_14__.ConnectError) {
                (0,_protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_10__.setTrailerStatus)(context.responseTrailer, e);
            }
            else if (e !== undefined) {
                (0,_protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_10__.setTrailerStatus)(context.responseTrailer, new _connect_error_js__WEBPACK_IMPORTED_MODULE_14__.ConnectError("internal error", _code_js__WEBPACK_IMPORTED_MODULE_15__.Code.Internal, undefined, undefined, e));
            }
            return {
                flags: _trailer_js__WEBPACK_IMPORTED_MODULE_1__.trailerFlag,
                data: trailerSerialization.serialize(context.responseTrailer),
            };
        }), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformCompressEnvelope)(compression.response, opt.compressMinBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.transformJoinEnvelopes)(), { propagateDownStreamError: true });
        return Object.assign(Object.assign({}, _protocol_universal_js__WEBPACK_IMPORTED_MODULE_6__.uResponseOk), { 
            // We wait for the first response body bytes before resolving, so that
            // implementations have a chance to add headers before an adapter commits
            // them to the wire.
            body: await (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_12__.untilFirst)(outputIt), header: context.responseHeader });
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/content-type.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/content-type.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentTypeJson: () => (/* binding */ contentTypeJson),
/* harmony export */   contentTypeProto: () => (/* binding */ contentTypeProto),
/* harmony export */   contentTypeRegExp: () => (/* binding */ contentTypeRegExp),
/* harmony export */   parseContentType: () => (/* binding */ parseContentType)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Regular Expression that matches any valid gRPC Content-Type header value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
const contentTypeRegExp = /^application\/grpc(?:\+(?:(json)(?:; ?charset=utf-?8)?|proto))?$/i;
const contentTypeProto = "application/grpc+proto";
const contentTypeJson = "application/grpc+json";
/**
 * Parse a gRPC Content-Type header.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseContentType(contentType) {
    const match = contentType === null || contentType === void 0 ? void 0 : contentType.match(contentTypeRegExp);
    if (!match) {
        return undefined;
    }
    const binary = !match[1];
    return { binary };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/handler-factory.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/handler-factory.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHandlerFactory: () => (/* binding */ createHandlerFactory)
/* harmony export */ });
/* harmony import */ var _implementation_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/implementation.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/content-type.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
/* harmony import */ var _trailer_status_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./trailer-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js");
/* harmony import */ var _parse_timeout_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./parse-timeout.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/parse-timeout.js");
/* harmony import */ var _protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../protocol/async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
/* harmony import */ var _protocol_compression_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../protocol/compression.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/compression.js");
/* harmony import */ var _protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../protocol/content-type-matcher.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js");
/* harmony import */ var _protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../protocol/create-method-url.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../protocol/invoke-implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/invoke-implementation.js");
/* harmony import */ var _protocol_serialization_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../protocol/serialization.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol/universal-handler.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js");
/* harmony import */ var _protocol_universal_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../protocol/universal.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















const protocolName = "grpc";
const methodPost = "POST";
/**
 * Create a factory that creates gRPC handlers.
 */
function createHandlerFactory(options) {
    const opt = (0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.validateUniversalHandlerOptions)(options);
    function fact(spec) {
        const h = createHandler(opt, spec);
        return Object.assign(h, {
            protocolNames: [protocolName],
            allowedMethods: [methodPost],
            supportedContentType: (0,_protocol_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_1__.contentTypeMatcher)(_content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeRegExp),
            requestPath: (0,_protocol_create_method_url_js__WEBPACK_IMPORTED_MODULE_3__.createMethodUrl)("/", spec.service, spec.method),
            service: spec.service,
            method: spec.method,
        });
    }
    fact.protocolName = protocolName;
    return fact;
}
function createHandler(opt, spec) {
    const serialization = (0,_protocol_serialization_js__WEBPACK_IMPORTED_MODULE_4__.createMethodSerializationLookup)(spec.method, opt.binaryOptions, opt.jsonOptions, opt);
    return async function handle(req) {
        (0,_protocol_universal_js__WEBPACK_IMPORTED_MODULE_5__.assertByteStreamRequest)(req);
        const type = (0,_content_type_js__WEBPACK_IMPORTED_MODULE_2__.parseContentType)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerContentType));
        if (type == undefined) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_5__.uResponseUnsupportedMediaType;
        }
        if (req.method !== methodPost) {
            return _protocol_universal_js__WEBPACK_IMPORTED_MODULE_5__.uResponseMethodNotAllowed;
        }
        const timeout = (0,_parse_timeout_js__WEBPACK_IMPORTED_MODULE_7__.parseTimeout)(req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerTimeout), opt.maxTimeoutMs);
        const context = (0,_implementation_js__WEBPACK_IMPORTED_MODULE_8__.createHandlerContext)(Object.assign(Object.assign({}, spec), { requestMethod: req.method, protocolName, timeoutMs: timeout.timeoutMs, shutdownSignal: opt.shutdownSignal, requestSignal: req.signal, requestHeader: req.header, url: req.url, responseHeader: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerContentType]: type.binary ? _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeProto : _content_type_js__WEBPACK_IMPORTED_MODULE_2__.contentTypeJson,
            }, responseTrailer: {
                [_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerGrpcStatus]: _trailer_status_js__WEBPACK_IMPORTED_MODULE_9__.grpcStatusOk,
            }, contextValues: req.contextValues }));
        const compression = (0,_protocol_compression_js__WEBPACK_IMPORTED_MODULE_10__.compressionNegotiate)(opt.acceptCompression, req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerEncoding), req.header.get(_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerAcceptEncoding), _headers_js__WEBPACK_IMPORTED_MODULE_6__.headerAcceptEncoding);
        if (compression.response) {
            context.responseHeader.set(_headers_js__WEBPACK_IMPORTED_MODULE_6__.headerEncoding, compression.response.name);
        }
        // We split the pipeline into two parts: The request iterator, and the
        // response iterator. We do this because the request iterator is responsible
        // for parsing the request body, and we don't want write errors of the response
        // iterator to affect the request iterator.
        const inputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.pipe)(req.body, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformPrepend)(() => {
            // raise compression error to serialize it as a trailer status
            if (compression.error)
                throw compression.error;
            // raise timeout parsing error to serialize it as a trailer status
            if (timeout.error)
                throw timeout.error;
            return undefined;
        }), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformSplitEnvelope)(opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformDecompressEnvelope)(compression.request, opt.readMaxBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformParseEnvelope)(serialization.getI(type.binary)));
        const it = (0,_protocol_invoke_implementation_js__WEBPACK_IMPORTED_MODULE_12__.transformInvokeImplementation)(spec, context, opt.interceptors)(inputIt)[Symbol.asyncIterator]();
        const outputIt = (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.pipe)(
        // We wrap the iterator in an async iterator to ensure that the
        // abort signal is aborted when the iterator is done.
        {
            [Symbol.asyncIterator]() {
                return {
                    next: () => it.next(),
                    throw: (e) => {
                        var _a, _b;
                        context.abort(e);
                        return (_b = (_a = it.throw) === null || _a === void 0 ? void 0 : _a.call(it, e)) !== null && _b !== void 0 ? _b : Promise.reject({ done: true });
                    },
                    return: (v) => {
                        var _a, _b;
                        context.abort();
                        return ((_b = (_a = it.return) === null || _a === void 0 ? void 0 : _a.call(it, v)) !== null && _b !== void 0 ? _b : Promise.resolve({ done: true, value: v }));
                    },
                };
            },
        }, (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformSerializeEnvelope)(serialization.getO(type.binary)), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformCompressEnvelope)(compression.response, opt.compressMinBytes), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformJoinEnvelopes)(), (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.transformCatchFinally)((e) => {
            context.abort();
            if (e instanceof _connect_error_js__WEBPACK_IMPORTED_MODULE_13__.ConnectError) {
                (0,_trailer_status_js__WEBPACK_IMPORTED_MODULE_9__.setTrailerStatus)(context.responseTrailer, e);
            }
            else if (e !== undefined) {
                (0,_trailer_status_js__WEBPACK_IMPORTED_MODULE_9__.setTrailerStatus)(context.responseTrailer, new _connect_error_js__WEBPACK_IMPORTED_MODULE_13__.ConnectError("internal error", _code_js__WEBPACK_IMPORTED_MODULE_14__.Code.Internal, undefined, undefined, e));
            }
        }), { propagateDownStreamError: true });
        return Object.assign(Object.assign({}, _protocol_universal_js__WEBPACK_IMPORTED_MODULE_5__.uResponseOk), { 
            // We wait for the first response body bytes before resolving, so that
            // implementations have a chance to add headers before an adapter commits
            // them to the wire.
            body: await (0,_protocol_async_iterable_js__WEBPACK_IMPORTED_MODULE_11__.untilFirst)(outputIt), header: context.responseHeader, trailer: context.responseTrailer });
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/parse-timeout.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/parse-timeout.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseTimeout: () => (/* binding */ parseTimeout)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Parse a gRPC Timeout (Deadline) header.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function parseTimeout(value, maxTimeoutMs) {
    if (value === null) {
        return {};
    }
    const results = /^(\d{1,8})([HMSmun])$/.exec(value);
    if (results === null) {
        return {
            error: new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`protocol error: invalid grpc timeout value: ${value}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument),
        };
    }
    const unitToMultiplicand = {
        H: 60 * 60 * 1000, // hour
        M: 60 * 1000, // minute
        S: 1000, // second
        m: 1, // millisecond
        u: 0.001, // microsecond
        n: 0.000001, // nanosecond
    };
    const timeoutMs = unitToMultiplicand[results[2]] *
        parseInt(results[1]);
    if (timeoutMs > maxTimeoutMs) {
        return {
            timeoutMs: timeoutMs,
            error: new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`timeout ${timeoutMs}ms must be <= ${maxTimeoutMs}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument),
        };
    }
    return {
        timeoutMs,
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAsyncIterable: () => (/* binding */ createAsyncIterable),
/* harmony export */   createWritableIterable: () => (/* binding */ createWritableIterable),
/* harmony export */   makeIterableAbortable: () => (/* binding */ makeIterableAbortable),
/* harmony export */   pipe: () => (/* binding */ pipe),
/* harmony export */   pipeTo: () => (/* binding */ pipeTo),
/* harmony export */   readAllBytes: () => (/* binding */ readAllBytes),
/* harmony export */   sinkAll: () => (/* binding */ sinkAll),
/* harmony export */   sinkAllBytes: () => (/* binding */ sinkAllBytes),
/* harmony export */   transformAppend: () => (/* binding */ transformAppend),
/* harmony export */   transformCatch: () => (/* binding */ transformCatch),
/* harmony export */   transformCatchFinally: () => (/* binding */ transformCatchFinally),
/* harmony export */   transformCompressEnvelope: () => (/* binding */ transformCompressEnvelope),
/* harmony export */   transformDecompressEnvelope: () => (/* binding */ transformDecompressEnvelope),
/* harmony export */   transformJoinEnvelopes: () => (/* binding */ transformJoinEnvelopes),
/* harmony export */   transformParseEnvelope: () => (/* binding */ transformParseEnvelope),
/* harmony export */   transformPrepend: () => (/* binding */ transformPrepend),
/* harmony export */   transformReadAllBytes: () => (/* binding */ transformReadAllBytes),
/* harmony export */   transformSerializeEnvelope: () => (/* binding */ transformSerializeEnvelope),
/* harmony export */   transformSplitEnvelope: () => (/* binding */ transformSplitEnvelope),
/* harmony export */   untilFirst: () => (/* binding */ untilFirst)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _envelope_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./envelope.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/envelope.js");
/* harmony import */ var _limit_io_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./limit-io.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/limit-io.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __asyncDelegator = (undefined && undefined.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
};




function pipeTo(source, ...rest) {
    const [transforms, sink, opt] = pickTransformsAndSink(rest);
    let iterable = source;
    let abortable;
    if ((opt === null || opt === void 0 ? void 0 : opt.propagateDownStreamError) === true) {
        iterable = abortable = makeIterableAbortable(iterable);
    }
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    iterable = pipe(iterable, ...transforms, { propagateDownStreamError: false });
    return sink(iterable).catch((reason) => {
        if (abortable) {
            return abortable.abort(reason).then(() => Promise.reject(reason));
        }
        return Promise.reject(reason);
    });
}
// pick transforms, the sink, and options from the pipeTo() rest parameter
function pickTransformsAndSink(rest) {
    let opt;
    if (typeof rest[rest.length - 1] != "function") {
        opt = rest.pop();
    }
    const sink = rest.pop();
    return [rest, sink, opt];
}
/**
 * Creates an AsyncIterableSink that concatenates all elements from the input.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function sinkAll() {
    return async function (iterable) {
        var _a, e_1, _b, _c;
        const all = [];
        try {
            for (var _d = true, iterable_1 = __asyncValues(iterable), iterable_1_1; iterable_1_1 = await iterable_1.next(), _a = iterable_1_1.done, !_a; _d = true) {
                _c = iterable_1_1.value;
                _d = false;
                const chunk = _c;
                all.push(chunk);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (!_d && !_a && (_b = iterable_1.return)) await _b.call(iterable_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return all;
    };
}
/**
 * Creates an AsyncIterableSink that concatenates all chunks from the input into
 * a single Uint8Array.
 *
 * The iterable raises an error if the more than readMaxBytes are read.
 *
 * An optional length hint can be provided to optimize allocation and validation.
 * If more or less bytes are present in the source that the length hint indicates,
 * and error is raised.
 * If the length hint is larger than readMaxBytes, an error is raised.
 * If the length hint is not a positive integer, it is ignored.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function sinkAllBytes(readMaxBytes, lengthHint) {
    return async function (iterable) {
        return await readAllBytes(iterable, readMaxBytes, lengthHint);
    };
}
function pipe(source, ...rest) {
    var _a;
    return __asyncGenerator(this, arguments, function* pipe_1() {
        const [transforms, opt] = pickTransforms(rest);
        let abortable;
        const sourceIt = source[Symbol.asyncIterator]();
        const cachedSource = {
            [Symbol.asyncIterator]() {
                return sourceIt;
            },
        };
        let iterable = cachedSource;
        if ((opt === null || opt === void 0 ? void 0 : opt.propagateDownStreamError) === true) {
            iterable = abortable = makeIterableAbortable(iterable);
        }
        for (const t of transforms) {
            iterable = t(iterable);
        }
        const it = iterable[Symbol.asyncIterator]();
        try {
            for (;;) {
                const r = yield __await(it.next());
                if (r.done === true) {
                    break;
                }
                if (!abortable) {
                    yield yield __await(r.value);
                    continue;
                }
                try {
                    yield yield __await(r.value);
                }
                catch (e) {
                    yield __await(abortable.abort(e)); // propagate downstream error to the source
                    throw e;
                }
            }
        }
        finally {
            if ((opt === null || opt === void 0 ? void 0 : opt.propagateDownStreamError) === true) {
                // Call return on the source iterable to indicate
                // that we will no longer consume it and it should
                // cleanup any allocated resources.
                (_a = sourceIt.return) === null || _a === void 0 ? void 0 : _a.call(sourceIt).catch(() => {
                    // return returns a promise, which we don't care about.
                    //
                    // Uncaught promises are thrown at sometime/somewhere by the event loop,
                    // this is to ensure error is caught and ignored.
                });
            }
        }
    });
}
function pickTransforms(rest) {
    let opt;
    if (typeof rest[rest.length - 1] != "function") {
        opt = rest.pop();
    }
    return [rest, opt];
}
/**
 * Creates an AsyncIterableTransform that catches any error from the input, and
 * passes it to the given catchError function.
 *
 * The catchError function may return a final value.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformCatch(catchError) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            // we deliberate avoid a for-await loop because we only want to catch upstream
            // errors, not downstream errors (yield).
            const it = iterable[Symbol.asyncIterator]();
            for (;;) {
                let r;
                try {
                    r = yield __await(it.next());
                }
                catch (e) {
                    const caught = yield __await(catchError(e));
                    if (caught !== undefined) {
                        yield yield __await(caught);
                    }
                    break;
                }
                if (r.done === true) {
                    break;
                }
                yield yield __await(r.value);
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that catches any error from the input, and
 * passes it to the given function. Unlike transformCatch(), the given function
 * is also called when no error is raised.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformCatchFinally(catchFinally) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            // we deliberate avoid a for-await loop because we only want to catch upstream
            // errors, not downstream errors (yield).
            let err;
            const it = iterable[Symbol.asyncIterator]();
            for (;;) {
                let r;
                try {
                    r = yield __await(it.next());
                }
                catch (e) {
                    err = e;
                    break;
                }
                if (r.done === true) {
                    break;
                }
                yield yield __await(r.value);
            }
            const caught = yield __await(catchFinally(err));
            if (caught !== undefined) {
                yield yield __await(caught);
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that appends a value.
 *
 * The element to append is provided by a function. If the function returns
 * undefined, no element is appended.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformAppend(provide) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_2, _b, _c;
            try {
                for (var _d = true, iterable_2 = __asyncValues(iterable), iterable_2_1; iterable_2_1 = yield __await(iterable_2.next()), _a = iterable_2_1.done, !_a; _d = true) {
                    _c = iterable_2_1.value;
                    _d = false;
                    const chunk = _c;
                    yield yield __await(chunk);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_2.return)) yield __await(_b.call(iterable_2));
                }
                finally { if (e_2) throw e_2.error; }
            }
            const append = yield __await(provide());
            if (append !== undefined) {
                yield yield __await(append);
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that prepends an element.
 *
 * The element to prepend is provided by a function. If the function returns
 * undefined, no element is appended.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformPrepend(provide) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_3, _b, _c;
            const prepend = yield __await(provide());
            if (prepend !== undefined) {
                yield yield __await(prepend);
            }
            try {
                for (var _d = true, iterable_3 = __asyncValues(iterable), iterable_3_1; iterable_3_1 = yield __await(iterable_3.next()), _a = iterable_3_1.done, !_a; _d = true) {
                    _c = iterable_3_1.value;
                    _d = false;
                    const chunk = _c;
                    yield yield __await(chunk);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_3.return)) yield __await(_b.call(iterable_3));
                }
                finally { if (e_3) throw e_3.error; }
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that reads all bytes from the input, and
 * concatenates them to a single Uint8Array.
 *
 * The iterable raises an error if the more than readMaxBytes are read.
 *
 * An optional length hint can be provided to optimize allocation and validation.
 * If more or less bytes are present in the source that the length hint indicates,
 * and error is raised.
 * If the length hint is larger than readMaxBytes, an error is raised.
 * If the length hint is not a positive integer, it is ignored.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformReadAllBytes(readMaxBytes, lengthHint) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            yield yield __await(yield __await(readAllBytes(iterable, readMaxBytes, lengthHint)));
        });
    };
}
function transformSerializeEnvelope(serialization, endStreamFlag, endSerialization) {
    if (endStreamFlag === undefined || endSerialization === undefined) {
        return function (iterable) {
            return __asyncGenerator(this, arguments, function* () {
                var _a, e_4, _b, _c;
                try {
                    for (var _d = true, iterable_4 = __asyncValues(iterable), iterable_4_1; iterable_4_1 = yield __await(iterable_4.next()), _a = iterable_4_1.done, !_a; _d = true) {
                        _c = iterable_4_1.value;
                        _d = false;
                        const chunk = _c;
                        const data = serialization.serialize(chunk);
                        yield yield __await({ flags: 0, data });
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (!_d && !_a && (_b = iterable_4.return)) yield __await(_b.call(iterable_4));
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            });
        };
    }
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_5, _b, _c;
            try {
                for (var _d = true, iterable_5 = __asyncValues(iterable), iterable_5_1; iterable_5_1 = yield __await(iterable_5.next()), _a = iterable_5_1.done, !_a; _d = true) {
                    _c = iterable_5_1.value;
                    _d = false;
                    const chunk = _c;
                    let data;
                    let flags = 0;
                    if (chunk.end) {
                        flags = flags | endStreamFlag;
                        data = endSerialization.serialize(chunk.value);
                    }
                    else {
                        data = serialization.serialize(chunk.value);
                    }
                    yield yield __await({ flags, data });
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_5.return)) yield __await(_b.call(iterable_5));
                }
                finally { if (e_5) throw e_5.error; }
            }
        });
    };
}
function transformParseEnvelope(serialization, endStreamFlag, endSerialization) {
    // code path always yields ParsedEnvelopedMessage<T, E>
    if (endSerialization && endStreamFlag !== undefined) {
        return function (iterable) {
            return __asyncGenerator(this, arguments, function* () {
                var _a, e_6, _b, _c;
                try {
                    for (var _d = true, iterable_6 = __asyncValues(iterable), iterable_6_1; iterable_6_1 = yield __await(iterable_6.next()), _a = iterable_6_1.done, !_a; _d = true) {
                        _c = iterable_6_1.value;
                        _d = false;
                        const { flags, data } = _c;
                        if ((flags & endStreamFlag) === endStreamFlag) {
                            yield yield __await({ value: endSerialization.parse(data), end: true });
                        }
                        else {
                            yield yield __await({ value: serialization.parse(data), end: false });
                        }
                    }
                }
                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                finally {
                    try {
                        if (!_d && !_a && (_b = iterable_6.return)) yield __await(_b.call(iterable_6));
                    }
                    finally { if (e_6) throw e_6.error; }
                }
            });
        };
    }
    // code path always yields T
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_7, _b, _c;
            try {
                for (var _d = true, iterable_7 = __asyncValues(iterable), iterable_7_1; iterable_7_1 = yield __await(iterable_7.next()), _a = iterable_7_1.done, !_a; _d = true) {
                    _c = iterable_7_1.value;
                    _d = false;
                    const { flags, data } = _c;
                    if (endStreamFlag !== undefined &&
                        (flags & endStreamFlag) === endStreamFlag) {
                        if (endSerialization === null) {
                            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError("unexpected end flag", _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
                        }
                        // skips end-of-stream envelope
                        continue;
                    }
                    yield yield __await(serialization.parse(data));
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_7.return)) yield __await(_b.call(iterable_7));
                }
                finally { if (e_7) throw e_7.error; }
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that takes enveloped messages as a source,
 * and compresses them if they are larger than compressMinBytes.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformCompressEnvelope(compression, compressMinBytes) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_8, _b, _c;
            try {
                for (var _d = true, iterable_8 = __asyncValues(iterable), iterable_8_1; iterable_8_1 = yield __await(iterable_8.next()), _a = iterable_8_1.done, !_a; _d = true) {
                    _c = iterable_8_1.value;
                    _d = false;
                    const env = _c;
                    yield yield __await(yield __await((0,_envelope_js__WEBPACK_IMPORTED_MODULE_2__.envelopeCompress)(env, compression, compressMinBytes)));
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_8.return)) yield __await(_b.call(iterable_8));
                }
                finally { if (e_8) throw e_8.error; }
            }
        });
    };
}
/**
 * Creates an AsyncIterableTransform that takes enveloped messages as a source,
 * and decompresses them using the given compression.
 *
 * The iterable raises an error if the decompressed payload of an enveloped
 * message is larger than readMaxBytes, or if no compression is provided.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformDecompressEnvelope(compression, readMaxBytes) {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_9, _b, _c;
            try {
                for (var _d = true, iterable_9 = __asyncValues(iterable), iterable_9_1; iterable_9_1 = yield __await(iterable_9.next()), _a = iterable_9_1.done, !_a; _d = true) {
                    _c = iterable_9_1.value;
                    _d = false;
                    const env = _c;
                    yield yield __await(yield __await((0,_envelope_js__WEBPACK_IMPORTED_MODULE_2__.envelopeDecompress)(env, compression, readMaxBytes)));
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_9.return)) yield __await(_b.call(iterable_9));
                }
                finally { if (e_9) throw e_9.error; }
            }
        });
    };
}
/**
 * Create an AsyncIterableTransform that takes enveloped messages as a source,
 * and joins them into a stream of raw bytes.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformJoinEnvelopes() {
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_10, _b, _c;
            try {
                for (var _d = true, iterable_10 = __asyncValues(iterable), iterable_10_1; iterable_10_1 = yield __await(iterable_10.next()), _a = iterable_10_1.done, !_a; _d = true) {
                    _c = iterable_10_1.value;
                    _d = false;
                    const { flags, data } = _c;
                    yield yield __await((0,_envelope_js__WEBPACK_IMPORTED_MODULE_2__.encodeEnvelope)(flags, data));
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_10.return)) yield __await(_b.call(iterable_10));
                }
                finally { if (e_10) throw e_10.error; }
            }
        });
    };
}
/**
 * Create an AsyncIterableTransform that takes raw bytes as a source, and splits
 * them into enveloped messages.
 *
 * The iterable raises an error
 * - if the payload of an enveloped message is larger than readMaxBytes,
 * - if the stream ended before an enveloped message fully arrived,
 * - or if the stream ended with extraneous data.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformSplitEnvelope(readMaxBytes) {
    // append chunk to buffer, returning updated buffer
    function append(buffer, chunk) {
        const n = new Uint8Array(buffer.byteLength + chunk.byteLength);
        n.set(buffer);
        n.set(chunk, buffer.length);
        return n;
    }
    // tuple 0: envelope, or undefined if incomplete
    // tuple 1: remainder of the buffer
    function shiftEnvelope(buffer, header) {
        if (buffer.byteLength < 5 + header.length) {
            return [undefined, buffer];
        }
        return [
            { flags: header.flags, data: buffer.subarray(5, 5 + header.length) },
            buffer.subarray(5 + header.length),
        ];
    }
    // undefined: header is incomplete
    function peekHeader(buffer) {
        if (buffer.byteLength < 5) {
            return undefined;
        }
        const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
        const length = view.getUint32(1); // 4 bytes message length
        const flags = view.getUint8(0); // first byte is flags
        return { length, flags };
    }
    return function (iterable) {
        return __asyncGenerator(this, arguments, function* () {
            var _a, e_11, _b, _c;
            let buffer = new Uint8Array(0);
            try {
                for (var _d = true, iterable_11 = __asyncValues(iterable), iterable_11_1; iterable_11_1 = yield __await(iterable_11.next()), _a = iterable_11_1.done, !_a; _d = true) {
                    _c = iterable_11_1.value;
                    _d = false;
                    const chunk = _c;
                    buffer = append(buffer, chunk);
                    for (;;) {
                        const header = peekHeader(buffer);
                        if (!header) {
                            break;
                        }
                        (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_3__.assertReadMaxBytes)(readMaxBytes, header.length, true);
                        let env;
                        [env, buffer] = shiftEnvelope(buffer, header);
                        if (!env) {
                            break;
                        }
                        yield yield __await(env);
                    }
                }
            }
            catch (e_11_1) { e_11 = { error: e_11_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = iterable_11.return)) yield __await(_b.call(iterable_11));
                }
                finally { if (e_11) throw e_11.error; }
            }
            if (buffer.byteLength > 0) {
                const header = peekHeader(buffer);
                let message = "protocol error: incomplete envelope";
                if (header) {
                    message = `protocol error: promised ${header.length} bytes in enveloped message, got ${buffer.byteLength - 5} bytes`;
                }
                throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(message, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
            }
        });
    };
}
/**
 * Reads all bytes from the source, and concatenates them to a single Uint8Array.
 *
 * Raises an error if:
 * - more than readMaxBytes are read
 * - lengthHint is a positive integer, but larger than readMaxBytes
 * - lengthHint is a positive integer, and the source contains more or less bytes
 *   than promised
 *
 * @private Internal code, does not follow semantic versioning.
 */
async function readAllBytes(iterable, readMaxBytes, lengthHint) {
    var _a, e_12, _b, _c, _d, e_13, _e, _f;
    const [ok, hint] = parseLengthHint(lengthHint);
    if (ok) {
        if (hint > readMaxBytes) {
            (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_3__.assertReadMaxBytes)(readMaxBytes, hint, true);
        }
        const buffer = new Uint8Array(hint);
        let offset = 0;
        try {
            for (var _g = true, iterable_12 = __asyncValues(iterable), iterable_12_1; iterable_12_1 = await iterable_12.next(), _a = iterable_12_1.done, !_a; _g = true) {
                _c = iterable_12_1.value;
                _g = false;
                const chunk = _c;
                if (offset + chunk.byteLength > hint) {
                    throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`protocol error: promised ${hint} bytes, received ${offset + chunk.byteLength}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
                }
                buffer.set(chunk, offset);
                offset += chunk.byteLength;
            }
        }
        catch (e_12_1) { e_12 = { error: e_12_1 }; }
        finally {
            try {
                if (!_g && !_a && (_b = iterable_12.return)) await _b.call(iterable_12);
            }
            finally { if (e_12) throw e_12.error; }
        }
        if (offset < hint) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`protocol error: promised ${hint} bytes, received ${offset}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.InvalidArgument);
        }
        return buffer;
    }
    const chunks = [];
    let count = 0;
    try {
        for (var _h = true, iterable_13 = __asyncValues(iterable), iterable_13_1; iterable_13_1 = await iterable_13.next(), _d = iterable_13_1.done, !_d; _h = true) {
            _f = iterable_13_1.value;
            _h = false;
            const chunk = _f;
            count += chunk.byteLength;
            (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_3__.assertReadMaxBytes)(readMaxBytes, count);
            chunks.push(chunk);
        }
    }
    catch (e_13_1) { e_13 = { error: e_13_1 }; }
    finally {
        try {
            if (!_h && !_d && (_e = iterable_13.return)) await _e.call(iterable_13);
        }
        finally { if (e_13) throw e_13.error; }
    }
    const all = new Uint8Array(count);
    let offset = 0;
    for (let chunk = chunks.shift(); chunk; chunk = chunks.shift()) {
        all.set(chunk, offset);
        offset += chunk.byteLength;
    }
    return all;
}
// parse the lengthHint argument of readAllBytes()
function parseLengthHint(lengthHint) {
    if (lengthHint === undefined || lengthHint === null) {
        return [false, 0];
    }
    const n = typeof lengthHint == "string" ? parseInt(lengthHint, 10) : lengthHint;
    if (!Number.isSafeInteger(n) || n < 0) {
        return [false, n];
    }
    return [true, n];
}
/**
 * Wait for the first element of an iterable without modifying the iterable.
 * This consumes the first element, but pushes it back on the stack.
 *
 * @private Internal code, does not follow semantic versioning.
 */
async function untilFirst(iterable) {
    const it = iterable[Symbol.asyncIterator]();
    let first = await it.next();
    return {
        [Symbol.asyncIterator]() {
            const w = {
                async next() {
                    if (first !== null) {
                        const n = first;
                        first = null;
                        return n;
                    }
                    return await it.next();
                },
            };
            if (it.throw !== undefined) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- can't handle mutated object sensibly
                w.throw = (e) => it.throw(e);
            }
            if (it.return !== undefined) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion,@typescript-eslint/no-explicit-any -- can't handle mutated object sensibly
                w.return = (value) => it.return(value);
            }
            return w;
        },
    };
}
/**
 * Wrap the given iterable and return an iterable with an abort() method.
 *
 * This function exists purely for convenience. Where one would typically have
 * to access the iterator directly, advance through all elements, and call
 * AsyncIterator.throw() to notify the upstream iterable, this function allows
 * to use convenient for-await loops and still notify the upstream iterable:
 *
 * ```ts
 * const abortable = makeIterableAbortable(iterable);
 * for await (const ele of abortable) {
 *   await abortable.abort("ERR");
 * }
 * ```
 * There are a couple of limitations of this function:
 * - the given async iterable must implement throw
 * - the async iterable cannot be re-use
 * - if source catches errors and yields values for them, they are ignored, and
 *   the source may still dangle
 *
 * There are four possible ways an async function* can handle yield errors:
 * 1. don't catch errors at all - Abortable.abort() will resolve "rethrown"
 * 2. catch errors and rethrow - Abortable.abort() will resolve "rethrown"
 * 3. catch errors and return - Abortable.abort() will resolve "completed"
 * 4. catch errors and yield a value - Abortable.abort() will resolve "caught"
 *
 * Note that catching errors and yielding a value is problematic, and it should
 * be documented that this may leave the source in a dangling state.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function makeIterableAbortable(iterable) {
    const innerCandidate = iterable[Symbol.asyncIterator]();
    if (innerCandidate.throw === undefined) {
        throw new Error("AsyncIterable does not implement throw");
    }
    const inner = innerCandidate;
    let aborted;
    let resultPromise;
    let it = {
        next() {
            resultPromise = inner.next().finally(() => {
                resultPromise = undefined;
            });
            return resultPromise;
        },
        throw(e) {
            return inner.throw(e);
        },
    };
    if (innerCandidate.return !== undefined) {
        it = Object.assign(Object.assign({}, it), { return(value) {
                return inner.return(value);
            } });
    }
    let used = false;
    return {
        abort(reason) {
            if (aborted) {
                return aborted.state;
            }
            const f = () => {
                return inner.throw(reason).then((r) => (r.done === true ? "completed" : "caught"), () => "rethrown");
            };
            if (resultPromise) {
                aborted = { reason, state: resultPromise.then(f, f) };
                return aborted.state;
            }
            aborted = { reason, state: f() };
            return aborted.state;
        },
        [Symbol.asyncIterator]() {
            if (used) {
                throw new Error("AsyncIterable cannot be re-used");
            }
            used = true;
            return it;
        },
    };
}
/**
 * Create a new WritableIterable.
 */
function createWritableIterable() {
    // We start with two queues to capture the read and write attempts.
    //
    // The writes and reads each check of their counterpart is
    // already available and either interact/add themselves to the queue.
    const readQueue = [];
    const writeQueue = [];
    let err = undefined;
    let nextResolve;
    let nextReject;
    let nextPromise = new Promise((resolve, reject) => {
        nextResolve = resolve;
        nextReject = reject;
    });
    let closed = false;
    // drain the readQueue in case of error/writer is closed by sending a
    // done result.
    function drain() {
        for (const next of readQueue.splice(0, readQueue.length)) {
            next({ done: true, value: undefined });
        }
    }
    return {
        close() {
            closed = true;
            drain();
        },
        async write(payload) {
            if (closed) {
                throw err !== null && err !== void 0 ? err : new Error("cannot write, WritableIterable already closed");
            }
            const read = readQueue.shift();
            if (read === undefined) {
                // We didn't find a pending read so we add the payload to the write queue.
                writeQueue.push(payload);
            }
            else {
                // We found a pending read so we respond with the payload.
                read({ done: false, value: payload });
                if (readQueue.length > 0) {
                    // If there are more in the read queue we can mark the write as complete.
                    // as the error reporting is not guaranteed to be sequential and therefore cannot
                    // to linked to a specific write.
                    return;
                }
            }
            // We await the next call for as many times as there are items in the queue + 1
            //
            // If there are no items in the write queue that means write happened and we just have
            // to wait for one more call likewise if we are the nth write in the queue we
            // have to wait for n writes to complete and one more.
            const limit = writeQueue.length + 1;
            for (let i = 0; i < limit; i++) {
                await nextPromise;
            }
        },
        [Symbol.asyncIterator]() {
            return {
                next() {
                    // Resolve the nextPromise to indicate
                    // pending writes that a read attempt has been made
                    // after their write.
                    //
                    // We also need to reset the promise for future writes.
                    nextResolve();
                    nextPromise = new Promise((resolve, reject) => {
                        nextResolve = resolve;
                        nextReject = reject;
                    });
                    const write = writeQueue.shift();
                    if (write !== undefined) {
                        // We found a pending write so response with the payload.
                        return Promise.resolve({ done: false, value: write });
                    }
                    if (closed) {
                        return Promise.resolve({ done: true, value: undefined });
                    }
                    // We return a promise immediately that is either resolved/rejected
                    // as writes happen.
                    let readResolve;
                    const readPromise = new Promise((resolve) => (readResolve = resolve));
                    readQueue.push(readResolve); // eslint-disable-line @typescript-eslint/no-non-null-assertion
                    return readPromise;
                },
                throw(throwErr) {
                    err = throwErr;
                    closed = true;
                    writeQueue.splice(0, writeQueue.length);
                    nextPromise.catch(() => {
                        // To make sure that the nextPromise is always resolved.
                    });
                    // This will reject all pending writes.
                    nextReject(err);
                    drain();
                    return Promise.resolve({ done: true, value: undefined });
                },
                return() {
                    closed = true;
                    writeQueue.splice(0, writeQueue.length);
                    // Resolve once for the write awaiting confirmation.
                    nextResolve();
                    // Reject all future writes.
                    nextPromise = Promise.reject(new Error("cannot write, consumer called return"));
                    nextPromise.catch(() => {
                        // To make sure that the nextPromise is always resolved.
                    });
                    drain();
                    return Promise.resolve({ done: true, value: undefined });
                },
            };
        },
    };
}
/**
 * Create an asynchronous iterable from an array.
 *
 * @private Internal code, does not follow semantic versioning.
 */
// eslint-disable-next-line @typescript-eslint/require-await
function createAsyncIterable(items) {
    return __asyncGenerator(this, arguments, function* createAsyncIterable_1() {
        yield __await(yield* __asyncDelegator(__asyncValues(items)));
    });
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contentTypeMatcher: () => (/* binding */ contentTypeMatcher)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
const contentTypeMatcherCacheSize = 1024;
/**
 * Create a function that returns true if the given mime type is supported.
 * A mime type is supported when one of the regular expressions match.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function contentTypeMatcher(...supported) {
    const cache = new Map();
    const source = supported.reduce((previousValue, currentValue) => previousValue.concat("supported" in currentValue ? currentValue.supported : currentValue), []);
    function match(contentType) {
        if (contentType === null || contentType.length == 0) {
            return false;
        }
        const cached = cache.get(contentType);
        if (cached !== undefined) {
            return cached;
        }
        const ok = source.some((re) => re.test(contentType));
        if (cache.size < contentTypeMatcherCacheSize) {
            cache.set(contentType, ok);
        }
        return ok;
    }
    match.supported = source;
    return match;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/invoke-implementation.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/invoke-implementation.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   invokeUnaryImplementation: () => (/* binding */ invokeUnaryImplementation),
/* harmony export */   transformInvokeImplementation: () => (/* binding */ transformInvokeImplementation)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normalize.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/normalize.js");
/* harmony import */ var _interceptor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../interceptor.js */ "./node_modules/@connectrpc/connect/dist/esm/interceptor.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __asyncValues = (undefined && undefined.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __asyncDelegator = (undefined && undefined.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
};





/**
 * Invoke a user-provided implementation of a unary RPC. Returns a normalized
 * output message.
 *
 * @private Internal code, does not follow semantic versioning.
 */
async function invokeUnaryImplementation(spec, context, input, interceptors) {
    const anyFn = async (req) => {
        return {
            message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_0__.normalize)(spec.method.O, await spec.impl(req.message, Object.assign(Object.assign({}, context), { service: req.service, method: req.method, requestHeader: req.header, values: req.contextValues, signal: req.signal }))),
            stream: false,
            service: req.service,
            method: req.method,
            header: context.responseHeader,
            trailer: context.responseTrailer,
        };
    };
    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_1__.applyInterceptors)(anyFn, interceptors);
    const { message } = await next({
        init: {
            method: context.requestMethod,
        },
        message: input,
        url: context.url,
        signal: context.signal,
        service: spec.service,
        method: spec.method,
        header: context.requestHeader,
        contextValues: context.values,
        stream: false,
    });
    return message;
}
/**
 * Return an AsyncIterableTransform that invokes a user-provided implementation,
 * giving it input from an asynchronous iterable, and returning its output as an
 * asynchronous iterable.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function transformInvokeImplementation(spec, context, interceptors) {
    switch (spec.kind) {
        case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.MethodKind.Unary:
            return function unary(input) {
                return __asyncGenerator(this, arguments, function* unary_1() {
                    const inputIt = input[Symbol.asyncIterator]();
                    const input1 = yield __await(inputIt.next());
                    if (input1.done === true) {
                        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError("protocol error: missing input message for unary method", _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.InvalidArgument);
                    }
                    const anyFn = async (req) => {
                        return {
                            message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_0__.normalize)(spec.method.O, await spec.impl(req.message, Object.assign(Object.assign({}, context), { service: req.service, method: req.method, requestHeader: req.header, values: req.contextValues, signal: req.signal }))),
                            stream: false,
                            service: req.service,
                            method: req.method,
                            header: context.responseHeader,
                            trailer: context.responseTrailer,
                        };
                    };
                    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_1__.applyInterceptors)(anyFn, interceptors);
                    const { message, header, trailer } = yield __await(next({
                        init: {
                            method: context.requestMethod,
                        },
                        message: input1.value,
                        url: context.url,
                        signal: context.signal,
                        service: spec.service,
                        method: spec.method,
                        header: context.requestHeader,
                        contextValues: context.values,
                        stream: false,
                    }));
                    copyHeaders(header, context.responseHeader);
                    copyHeaders(trailer, context.responseTrailer);
                    yield yield __await(message);
                    const input2 = yield __await(inputIt.next());
                    if (input2.done !== true) {
                        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError("protocol error: received extra input message for unary method", _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.InvalidArgument);
                    }
                });
            };
        case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.MethodKind.ServerStreaming: {
            return function serverStreaming(input) {
                return __asyncGenerator(this, arguments, function* serverStreaming_1() {
                    const inputIt = input[Symbol.asyncIterator]();
                    const input1 = yield __await(inputIt.next());
                    if (input1.done === true) {
                        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError("protocol error: missing input message for server-streaming method", _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.InvalidArgument);
                    }
                    const anyFn = async (req) => {
                        return {
                            message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_0__.normalizeIterable)(spec.method.O, spec.impl(req.message, Object.assign(Object.assign({}, context), { service: req.service, method: req.method, requestHeader: req.header, values: req.contextValues, signal: req.signal }))),
                            stream: true,
                            service: req.service,
                            method: req.method,
                            header: context.responseHeader,
                            trailer: context.responseTrailer,
                        };
                    };
                    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_1__.applyInterceptors)(anyFn, interceptors);
                    const { message, header, trailer } = yield __await(next({
                        init: {
                            method: context.requestMethod,
                        },
                        message: input1.value,
                        url: context.url,
                        signal: context.signal,
                        service: spec.service,
                        method: spec.method,
                        header: context.requestHeader,
                        contextValues: context.values,
                        stream: false,
                    }));
                    copyHeaders(header, context.responseHeader);
                    copyHeaders(trailer, context.responseTrailer);
                    yield __await(yield* __asyncDelegator(__asyncValues(message)));
                    const input2 = yield __await(inputIt.next());
                    if (input2.done !== true) {
                        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_3__.ConnectError("protocol error: received extra input message for server-streaming method", _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.InvalidArgument);
                    }
                });
            };
        }
        case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.MethodKind.ClientStreaming: {
            return function clientStreaming(input) {
                return __asyncGenerator(this, arguments, function* clientStreaming_1() {
                    const anyFn = async (req) => {
                        return {
                            message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_0__.normalize)(spec.method.O, await spec.impl(req.message, Object.assign(Object.assign({}, context), { service: req.service, method: req.method, requestHeader: req.header, values: req.contextValues, signal: req.signal }))),
                            stream: false,
                            service: req.service,
                            method: req.method,
                            header: context.responseHeader,
                            trailer: context.responseTrailer,
                        };
                    };
                    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_1__.applyInterceptors)(anyFn, interceptors);
                    const { message, header, trailer } = yield __await(next({
                        init: {
                            method: context.requestMethod,
                        },
                        message: input,
                        url: context.url,
                        signal: context.signal,
                        service: spec.service,
                        method: spec.method,
                        header: context.requestHeader,
                        contextValues: context.values,
                        stream: true,
                    }));
                    copyHeaders(header, context.responseHeader);
                    copyHeaders(trailer, context.responseTrailer);
                    yield yield __await(message);
                });
            };
        }
        case _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_2__.MethodKind.BiDiStreaming:
            return function biDiStreaming(input) {
                return __asyncGenerator(this, arguments, function* biDiStreaming_1() {
                    const anyFn = async (req) => {
                        return {
                            message: (0,_normalize_js__WEBPACK_IMPORTED_MODULE_0__.normalizeIterable)(spec.method.O, spec.impl(req.message, Object.assign(Object.assign({}, context), { service: req.service, method: req.method, requestHeader: req.header, values: req.contextValues, signal: req.signal }))),
                            stream: true,
                            service: req.service,
                            method: req.method,
                            header: context.responseHeader,
                            trailer: context.responseTrailer,
                        };
                    };
                    const next = (0,_interceptor_js__WEBPACK_IMPORTED_MODULE_1__.applyInterceptors)(anyFn, interceptors);
                    const { message, header, trailer } = yield __await(next({
                        init: {
                            method: context.requestMethod,
                        },
                        message: input,
                        url: context.url,
                        signal: context.signal,
                        service: spec.service,
                        method: spec.method,
                        header: context.requestHeader,
                        contextValues: context.values,
                        stream: true,
                    }));
                    copyHeaders(header, context.responseHeader);
                    copyHeaders(trailer, context.responseTrailer);
                    yield __await(yield* __asyncDelegator(__asyncValues(message)));
                });
            };
    }
}
function copyHeaders(from, to) {
    if (from === to) {
        return;
    }
    to.forEach((_, key) => {
        to.delete(key);
    });
    from.forEach((value, key) => {
        to.set(key, value);
    });
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler-client.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler-client.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUniversalHandlerClient: () => (/* binding */ createUniversalHandlerClient)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _async_iterable_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./async-iterable.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/async-iterable.js");
/* harmony import */ var _signals_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./signals.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/signals.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * An in-memory UniversalClientFn that can be used to route requests to a ConnectRouter
 * bypassing network calls. Useful for testing and calling in-process services.
 */
function createUniversalHandlerClient(uHandlers) {
    const handlerMap = new Map();
    for (const handler of uHandlers) {
        handlerMap.set(handler.requestPath, handler);
    }
    return async (uClientReq) => {
        var _a, _b, _c;
        const pathname = new URL(uClientReq.url).pathname;
        const handler = handlerMap.get(pathname);
        if (!handler) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_0__.ConnectError(`RouterHttpClient: no handler registered for ${pathname}`, _code_js__WEBPACK_IMPORTED_MODULE_1__.Code.Unimplemented);
        }
        const reqSignal = (_a = uClientReq.signal) !== null && _a !== void 0 ? _a : new AbortController().signal;
        const uServerRes = await raceSignal(reqSignal, handler({
            body: (_b = uClientReq.body) !== null && _b !== void 0 ? _b : (0,_async_iterable_js__WEBPACK_IMPORTED_MODULE_2__.createAsyncIterable)([]),
            httpVersion: "2.0",
            method: uClientReq.method,
            url: uClientReq.url,
            header: uClientReq.header,
            signal: reqSignal,
        }));
        const body = (_c = uServerRes.body) !== null && _c !== void 0 ? _c : (0,_async_iterable_js__WEBPACK_IMPORTED_MODULE_2__.createAsyncIterable)([]);
        return {
            body: (0,_async_iterable_js__WEBPACK_IMPORTED_MODULE_2__.pipe)(body, (iterable) => {
                return {
                    [Symbol.asyncIterator]() {
                        const it = iterable[Symbol.asyncIterator]();
                        const w = {
                            next() {
                                return raceSignal(reqSignal, it.next());
                            },
                        };
                        if (it.throw !== undefined) {
                            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- can't handle mutated object sensibly
                            w.throw = (e) => it.throw(e);
                        }
                        if (it.return !== undefined) {
                            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion,@typescript-eslint/no-explicit-any -- can't handle mutated object sensibly
                            w.return = (value) => it.return(value);
                        }
                        return w;
                    },
                };
            }),
            header: new Headers(uServerRes.header),
            status: uServerRes.status,
            trailer: new Headers(uServerRes.trailer),
        };
    };
}
/**
 * Wrap a promise, and reject early if the given signal triggers before the
 * promise is settled.
 */
function raceSignal(signal, promise) {
    let cleanup;
    const signalPromise = new Promise((_, reject) => {
        const onAbort = () => reject((0,_signals_js__WEBPACK_IMPORTED_MODULE_3__.getAbortSignalReason)(signal));
        if (signal.aborted) {
            return onAbort();
        }
        signal.addEventListener("abort", onAbort);
        cleanup = () => signal.removeEventListener("abort", onAbort);
    });
    return Promise.race([signalPromise, promise]).finally(cleanup);
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUniversalMethodHandler: () => (/* binding */ createUniversalMethodHandler),
/* harmony export */   createUniversalServiceHandlers: () => (/* binding */ createUniversalServiceHandlers),
/* harmony export */   negotiateProtocol: () => (/* binding */ negotiateProtocol),
/* harmony export */   validateUniversalHandlerOptions: () => (/* binding */ validateUniversalHandlerOptions)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _universal_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./universal.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js");
/* harmony import */ var _content_type_matcher_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./content-type-matcher.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/content-type-matcher.js");
/* harmony import */ var _limit_io_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./limit-io.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/limit-io.js");
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Asserts that the options are within sane limits, and returns default values
 * where no value is provided.
 *
 * Note that this function does not set default values for `acceptCompression`.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateUniversalHandlerOptions(opt) {
    var _a, _b, _c;
    opt !== null && opt !== void 0 ? opt : (opt = {});
    const acceptCompression = opt.acceptCompression
        ? [...opt.acceptCompression]
        : [];
    const requireConnectProtocolHeader = (_a = opt.requireConnectProtocolHeader) !== null && _a !== void 0 ? _a : false;
    const maxTimeoutMs = (_b = opt.maxTimeoutMs) !== null && _b !== void 0 ? _b : Number.MAX_SAFE_INTEGER;
    return Object.assign(Object.assign({ acceptCompression }, (0,_limit_io_js__WEBPACK_IMPORTED_MODULE_0__.validateReadWriteMaxBytes)(opt.readMaxBytes, opt.writeMaxBytes, opt.compressMinBytes)), { jsonOptions: opt.jsonOptions, binaryOptions: opt.binaryOptions, maxTimeoutMs, shutdownSignal: opt.shutdownSignal, requireConnectProtocolHeader, interceptors: (_c = opt.interceptors) !== null && _c !== void 0 ? _c : [] });
}
/**
 * For the given service implementation, return a universal handler for each
 * RPC. The handler serves the given protocols.
 *
 * At least one protocol is required.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createUniversalServiceHandlers(spec, protocols) {
    return Object.entries(spec.methods).map(([, implSpec]) => createUniversalMethodHandler(implSpec, protocols));
}
/**
 * Return a universal handler for the given RPC implementation.
 * The handler serves the given protocols.
 *
 * At least one protocol is required.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function createUniversalMethodHandler(spec, protocols) {
    return negotiateProtocol(protocols.map((f) => f(spec)));
}
/**
 * Create a universal handler that negotiates the protocol.
 *
 * This functions takes one or more handlers - all for the same RPC, but for
 * different protocols - and returns a single handler that looks at the
 * Content-Type header and the HTTP verb of the incoming request to select
 * the appropriate protocol-specific handler.
 *
 * Raises an error if no protocol handlers were provided, or if they do not
 * handle exactly the same RPC.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function negotiateProtocol(protocolHandlers) {
    if (protocolHandlers.length == 0) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError("at least one protocol is required", _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.Internal);
    }
    const service = protocolHandlers[0].service;
    const method = protocolHandlers[0].method;
    const requestPath = protocolHandlers[0].requestPath;
    if (protocolHandlers.some((h) => h.service !== service || h.method !== method)) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError("cannot negotiate protocol for different RPCs", _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.Internal);
    }
    if (protocolHandlers.some((h) => h.requestPath !== requestPath)) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_1__.ConnectError("cannot negotiate protocol for different requestPaths", _code_js__WEBPACK_IMPORTED_MODULE_2__.Code.Internal);
    }
    async function protocolNegotiatingHandler(request) {
        var _a;
        if (method.kind == _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_3__.MethodKind.BiDiStreaming &&
            request.httpVersion.startsWith("1.")) {
            return Object.assign(Object.assign({}, _universal_js__WEBPACK_IMPORTED_MODULE_4__.uResponseVersionNotSupported), { 
                // Clients coded to expect full-duplex connections may hang if they've
                // mistakenly negotiated HTTP/1.1. To unblock them, we must close the
                // underlying TCP connection.
                header: new Headers({ Connection: "close" }) });
        }
        const contentType = (_a = request.header.get("Content-Type")) !== null && _a !== void 0 ? _a : "";
        const matchingMethod = protocolHandlers.filter((h) => h.allowedMethods.includes(request.method));
        if (matchingMethod.length == 0) {
            return _universal_js__WEBPACK_IMPORTED_MODULE_4__.uResponseMethodNotAllowed;
        }
        // If Content-Type is unset but only one handler matches, use it.
        if (matchingMethod.length == 1 && contentType === "") {
            const onlyMatch = matchingMethod[0];
            return onlyMatch(request);
        }
        const matchingContentTypes = matchingMethod.filter((h) => h.supportedContentType(contentType));
        if (matchingContentTypes.length == 0) {
            return _universal_js__WEBPACK_IMPORTED_MODULE_4__.uResponseUnsupportedMediaType;
        }
        const firstMatch = matchingContentTypes[0];
        return firstMatch(request);
    }
    return Object.assign(protocolNegotiatingHandler, {
        service,
        method,
        requestPath,
        supportedContentType: (0,_content_type_matcher_js__WEBPACK_IMPORTED_MODULE_5__.contentTypeMatcher)(...protocolHandlers.map((h) => h.supportedContentType)),
        protocolNames: protocolHandlers
            .flatMap((h) => h.protocolNames)
            .filter((value, index, array) => array.indexOf(value) === index),
        allowedMethods: protocolHandlers
            .flatMap((h) => h.allowedMethods)
            .filter((value, index, array) => array.indexOf(value) === index),
    });
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol/universal.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertByteStreamRequest: () => (/* binding */ assertByteStreamRequest),
/* harmony export */   uResponseMethodNotAllowed: () => (/* binding */ uResponseMethodNotAllowed),
/* harmony export */   uResponseNotFound: () => (/* binding */ uResponseNotFound),
/* harmony export */   uResponseOk: () => (/* binding */ uResponseOk),
/* harmony export */   uResponseUnsupportedMediaType: () => (/* binding */ uResponseUnsupportedMediaType),
/* harmony export */   uResponseVersionNotSupported: () => (/* binding */ uResponseVersionNotSupported)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Assert that the given UniversalServerRequest has a byte stream body, not
 * a JSON value.
 *
 * We accept a JSON object or a byte stream in server requests.
 * In practice, only Connect unary handlers will receive a parse
 * JSON object. Other call-sites can use this assertion to narrow
 * the union type. A failure in such a call-sites indicates that
 * the contract between a server framework and the connect-node \
 * handler is broken.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function assertByteStreamRequest(req) {
    if (typeof req.body == "object" &&
        req.body !== null &&
        Symbol.asyncIterator in req.body) {
        return;
    }
    throw new Error("byte stream required, but received JSON");
}
/**
 * HTTP 200 OK
 *
 * @private Internal code, does not follow semantic versioning.
 */
const uResponseOk = {
    status: 200,
};
/**
 * HTTP 404 Not Found
 *
 * @private Internal code, does not follow semantic versioning.
 */
const uResponseNotFound = {
    status: 404,
};
/**
 * HTTP 415 Unsupported Media Type
 *
 * @private Internal code, does not follow semantic versioning.
 */
const uResponseUnsupportedMediaType = {
    status: 415,
};
/**
 * HTTP 405 Method Not Allowed
 *
 * @private Internal code, does not follow semantic versioning.
 */
const uResponseMethodNotAllowed = {
    status: 405,
};
/**
 * HTTP 505 Version Not Supported
 *
 * @private Internal code, does not follow semantic versioning.
 */
const uResponseVersionNotSupported = {
    status: 505,
};


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/router-transport.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/router-transport.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRouterTransport: () => (/* binding */ createRouterTransport)
/* harmony export */ });
/* harmony import */ var _protocol_connect_transport_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./protocol-connect/transport.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/transport.js");
/* harmony import */ var _protocol_universal_handler_client_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./protocol/universal-handler-client.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler-client.js");
/* harmony import */ var _router_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./router.js */ "./node_modules/@connectrpc/connect/dist/esm/router.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Creates a Transport that routes requests to the configured router. Useful for testing
 * and calling services running in the same process.
 *
 * This can be used to test both client logic by using this to stub/mock the backend,
 * and to test server logic by using this to run without needing to spin up a server.
 */
function createRouterTransport(routes, options) {
    var _a, _b;
    const router = (0,_router_js__WEBPACK_IMPORTED_MODULE_0__.createConnectRouter)(Object.assign(Object.assign({}, ((_a = options === null || options === void 0 ? void 0 : options.router) !== null && _a !== void 0 ? _a : {})), { connect: true }));
    routes(router);
    return (0,_protocol_connect_transport_js__WEBPACK_IMPORTED_MODULE_1__.createTransport)(Object.assign({ httpClient: (0,_protocol_universal_handler_client_js__WEBPACK_IMPORTED_MODULE_2__.createUniversalHandlerClient)(router.handlers), baseUrl: "https://in-memory", useBinaryFormat: true, interceptors: [], acceptCompression: [], sendCompression: null, compressMinBytes: Number.MAX_SAFE_INTEGER, readMaxBytes: Number.MAX_SAFE_INTEGER, writeMaxBytes: Number.MAX_SAFE_INTEGER }, ((_b = options === null || options === void 0 ? void 0 : options.transport) !== null && _b !== void 0 ? _b : {})));
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/router.js":
/*!*************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/router.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConnectRouter: () => (/* binding */ createConnectRouter)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _implementation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./implementation.js */ "./node_modules/@connectrpc/connect/dist/esm/implementation.js");
/* harmony import */ var _protocol_grpc_web_handler_factory_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./protocol-grpc-web/handler-factory.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/handler-factory.js");
/* harmony import */ var _protocol_grpc_handler_factory_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./protocol-grpc/handler-factory.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/handler-factory.js");
/* harmony import */ var _protocol_connect_handler_factory_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./protocol-connect/handler-factory.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/handler-factory.js");
/* harmony import */ var _protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./protocol/universal-handler.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol/universal-handler.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.







/**
 * Create a new ConnectRouter.
 */
function createConnectRouter(routerOptions) {
    const base = whichProtocols(routerOptions);
    const handlers = [];
    return {
        handlers,
        service(service, implementation, options) {
            const { protocols } = whichProtocols(options, base);
            handlers.push(...(0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.createUniversalServiceHandlers)((0,_implementation_js__WEBPACK_IMPORTED_MODULE_1__.createServiceImplSpec)(service, implementation), protocols));
            return this;
        },
        rpc(serviceOrMethod, methodOrImpl, implementationOrOptions, options) {
            let service;
            let method;
            let impl;
            let opt;
            if ("typeName" in serviceOrMethod) {
                service = serviceOrMethod;
                method = methodOrImpl;
                impl = implementationOrOptions;
                opt = options;
            }
            else {
                service = Object.assign(Object.assign({}, serviceOrMethod.service), { methods: {} });
                method = serviceOrMethod;
                impl = methodOrImpl;
                opt = implementationOrOptions;
            }
            const { protocols } = whichProtocols(opt, base);
            handlers.push((0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.createUniversalMethodHandler)((0,_implementation_js__WEBPACK_IMPORTED_MODULE_1__.createMethodImplSpec)(service, method, impl), protocols));
            return this;
        },
    };
}
function whichProtocols(options, base) {
    if (base && !options) {
        return base;
    }
    const opt = base
        ? Object.assign(Object.assign({}, (0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.validateUniversalHandlerOptions)(base.options)), options) : Object.assign(Object.assign({}, options), (0,_protocol_universal_handler_js__WEBPACK_IMPORTED_MODULE_0__.validateUniversalHandlerOptions)(options !== null && options !== void 0 ? options : {}));
    const protocols = [];
    if ((options === null || options === void 0 ? void 0 : options.grpc) !== false) {
        protocols.push((0,_protocol_grpc_handler_factory_js__WEBPACK_IMPORTED_MODULE_2__.createHandlerFactory)(opt));
    }
    if ((options === null || options === void 0 ? void 0 : options.grpcWeb) !== false) {
        protocols.push((0,_protocol_grpc_web_handler_factory_js__WEBPACK_IMPORTED_MODULE_3__.createHandlerFactory)(opt));
    }
    if ((options === null || options === void 0 ? void 0 : options.connect) !== false) {
        protocols.push((0,_protocol_connect_handler_factory_js__WEBPACK_IMPORTED_MODULE_4__.createHandlerFactory)(opt));
    }
    if (protocols.length === 0) {
        throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_5__.ConnectError("cannot create handler, all protocols are disabled", _code_js__WEBPACK_IMPORTED_MODULE_6__.Code.InvalidArgument);
    }
    return {
        options: opt,
        protocols,
    };
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_connectrpc_connect_dist_esm_index_js.efd4bc248d2307bc13dc.js.map