"use strict";
(self["webpackChunkcodeium_jupyter"] = self["webpackChunkcodeium_jupyter"] || []).push([["vendors-node_modules_connectrpc_connect-web_dist_esm_index_js"],{

/***/ "./node_modules/@connectrpc/connect-web/dist/esm/assert-fetch-api.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect-web/dist/esm/assert-fetch-api.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertFetchApi: () => (/* binding */ assertFetchApi)
/* harmony export */ });
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Asserts that the fetch API is available.
 */
function assertFetchApi() {
    try {
        new Headers();
    }
    catch (_) {
        throw new Error("connect-web requires the fetch API. Are you running on an old version of Node.js? Node.js is not supported in Connect for Web - please stay tuned for Connect for Node.");
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect-web/dist/esm/connect-transport.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect-web/dist/esm/connect-transport.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConnectTransport: () => (/* binding */ createConnectTransport)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @connectrpc/connect */ "webpack/sharing/consume/default/@connectrpc/connect/@connectrpc/connect?a654");
/* harmony import */ var _connectrpc_connect__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/run-call.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/envelope.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/request-header.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/get-request.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/validate-response.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/error-json.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/trailer-mux.js");
/* harmony import */ var _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @connectrpc/connect/protocol-connect */ "./node_modules/@connectrpc/connect/dist/esm/protocol-connect/end-stream.js");
/* harmony import */ var _assert_fetch_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assert-fetch-api.js */ "./node_modules/@connectrpc/connect-web/dist/esm/assert-fetch-api.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};





/**
 * Create a Transport for the Connect protocol, which makes unary and
 * server-streaming methods available to web browsers. It uses the fetch
 * API to make HTTP requests.
 */
function createConnectTransport(options) {
    var _a;
    (0,_assert_fetch_api_js__WEBPACK_IMPORTED_MODULE_1__.assertFetchApi)();
    const useBinaryFormat = (_a = options.useBinaryFormat) !== null && _a !== void 0 ? _a : false;
    return {
        async unary(service, method, signal, timeoutMs, header, message, contextValues) {
            var _a;
            const { serialize, parse } = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__.createClientMethodSerializers)(method, useBinaryFormat, options.jsonOptions, options.binaryOptions);
            timeoutMs =
                timeoutMs === undefined
                    ? options.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return await (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__.runUnaryCall)({
                interceptors: options.interceptors,
                signal,
                timeoutMs,
                req: {
                    stream: false,
                    service,
                    method,
                    url: (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__.createMethodUrl)(options.baseUrl, service, method),
                    init: {
                        method: "POST",
                        credentials: (_a = options.credentials) !== null && _a !== void 0 ? _a : "same-origin",
                        redirect: "error",
                        mode: "cors",
                    },
                    header: (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_5__.requestHeader)(method.kind, useBinaryFormat, timeoutMs, header, false),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__.createContextValues)(),
                    message,
                },
                next: async (req) => {
                    var _a;
                    const useGet = options.useHttpGet === true &&
                        method.idempotency === _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_6__.MethodIdempotency.NoSideEffects;
                    let body = null;
                    if (useGet) {
                        req = (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_7__.transformConnectPostToGetRequest)(req, serialize(req.message), useBinaryFormat);
                    }
                    else {
                        body = serialize(req.message);
                    }
                    const fetch = (_a = options.fetch) !== null && _a !== void 0 ? _a : globalThis.fetch;
                    const response = await fetch(req.url, Object.assign(Object.assign({}, req.init), { headers: req.header, signal: req.signal, body }));
                    const { isUnaryError, unaryError } = (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_8__.validateResponse)(method.kind, response.status, response.headers);
                    if (isUnaryError) {
                        throw (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_9__.errorFromJson)((await response.json()), (0,_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__.appendHeaders)(...(0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_10__.trailerDemux)(response.headers)), unaryError);
                    }
                    const [demuxedHeader, demuxedTrailer] = (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_10__.trailerDemux)(response.headers);
                    return {
                        stream: false,
                        service,
                        method,
                        header: demuxedHeader,
                        message: useBinaryFormat
                            ? parse(new Uint8Array(await response.arrayBuffer()))
                            : method.O.fromJson((await response.json()), (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__.getJsonOptions)(options.jsonOptions)),
                        trailer: demuxedTrailer,
                    };
                },
            });
        },
        async stream(service, method, signal, timeoutMs, header, input, contextValues) {
            var _a;
            const { serialize, parse } = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__.createClientMethodSerializers)(method, useBinaryFormat, options.jsonOptions, options.binaryOptions);
            function parseResponseBody(body, trailerTarget, header) {
                return __asyncGenerator(this, arguments, function* parseResponseBody_1() {
                    const reader = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_11__.createEnvelopeReadableStream)(body).getReader();
                    let endStreamReceived = false;
                    for (;;) {
                        const result = yield __await(reader.read());
                        if (result.done) {
                            break;
                        }
                        const { flags, data } = result.value;
                        if ((flags & _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_12__.endStreamFlag) === _connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_12__.endStreamFlag) {
                            endStreamReceived = true;
                            const endStream = (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_12__.endStreamFromJson)(data);
                            if (endStream.error) {
                                const error = endStream.error;
                                header.forEach((value, key) => {
                                    error.metadata.append(key, value);
                                });
                                throw error;
                            }
                            endStream.metadata.forEach((value, key) => trailerTarget.set(key, value));
                            continue;
                        }
                        yield yield __await(parse(data));
                    }
                    if (!endStreamReceived) {
                        throw "missing EndStreamResponse";
                    }
                });
            }
            async function createRequestBody(input) {
                if (method.kind != _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_6__.MethodKind.ServerStreaming) {
                    throw "The fetch API does not support streaming request bodies";
                }
                const r = await input[Symbol.asyncIterator]().next();
                if (r.done == true) {
                    throw "missing request message";
                }
                return (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_11__.encodeEnvelope)(0, serialize(r.value));
            }
            timeoutMs =
                timeoutMs === undefined
                    ? options.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return await (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__.runStreamingCall)({
                interceptors: options.interceptors,
                timeoutMs,
                signal,
                req: {
                    stream: true,
                    service,
                    method,
                    url: (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__.createMethodUrl)(options.baseUrl, service, method),
                    init: {
                        method: "POST",
                        credentials: (_a = options.credentials) !== null && _a !== void 0 ? _a : "same-origin",
                        redirect: "error",
                        mode: "cors",
                    },
                    header: (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_5__.requestHeader)(method.kind, useBinaryFormat, timeoutMs, header, false),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__.createContextValues)(),
                    message: input,
                },
                next: async (req) => {
                    var _a;
                    const fetch = (_a = options.fetch) !== null && _a !== void 0 ? _a : globalThis.fetch;
                    const fRes = await fetch(req.url, Object.assign(Object.assign({}, req.init), { headers: req.header, signal: req.signal, body: await createRequestBody(req.message) }));
                    (0,_connectrpc_connect_protocol_connect__WEBPACK_IMPORTED_MODULE_8__.validateResponse)(method.kind, fRes.status, fRes.headers);
                    if (fRes.body === null) {
                        throw "missing response body";
                    }
                    const trailer = new Headers();
                    const res = Object.assign(Object.assign({}, req), { header: fRes.headers, trailer, message: parseResponseBody(fRes.body, trailer, fRes.headers) });
                    return res;
                },
            });
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect-web/dist/esm/grpc-web-transport.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect-web/dist/esm/grpc-web-transport.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGrpcWebTransport: () => (/* binding */ createGrpcWebTransport)
/* harmony export */ });
/* harmony import */ var _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @bufbuild/protobuf */ "./node_modules/@bufbuild/protobuf/dist/esm/service-type.js");
/* harmony import */ var _connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @connectrpc/connect */ "webpack/sharing/consume/default/@connectrpc/connect/@connectrpc/connect?a654");
/* harmony import */ var _connectrpc_connect__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/serialization.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/run-call.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/create-method-url.js");
/* harmony import */ var _connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @connectrpc/connect/protocol */ "./node_modules/@connectrpc/connect/dist/esm/protocol/envelope.js");
/* harmony import */ var _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @connectrpc/connect/protocol-grpc-web */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/request-header.js");
/* harmony import */ var _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @connectrpc/connect/protocol-grpc-web */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/validate-response.js");
/* harmony import */ var _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @connectrpc/connect/protocol-grpc-web */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/trailer.js");
/* harmony import */ var _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @connectrpc/connect/protocol-grpc-web */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/validate-trailer.js");
/* harmony import */ var _assert_fetch_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./assert-fetch-api.js */ "./node_modules/@connectrpc/connect-web/dist/esm/assert-fetch-api.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __await = (undefined && undefined.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (undefined && undefined.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};





/**
 * Create a Transport for the gRPC-web protocol. The protocol encodes
 * trailers in the response body and makes unary and server-streaming
 * methods available to web browsers. It uses the fetch API to make
 * HTTP requests.
 *
 * Note that this transport does not implement the grpc-web-text format,
 * which applies base64 encoding to the request and response bodies to
 * support reading streaming responses from an XMLHttpRequest.
 */
function createGrpcWebTransport(options) {
    var _a;
    (0,_assert_fetch_api_js__WEBPACK_IMPORTED_MODULE_1__.assertFetchApi)();
    const useBinaryFormat = (_a = options.useBinaryFormat) !== null && _a !== void 0 ? _a : true;
    return {
        async unary(service, method, signal, timeoutMs, header, message, contextValues) {
            var _a;
            const { serialize, parse } = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__.createClientMethodSerializers)(method, useBinaryFormat, options.jsonOptions, options.binaryOptions);
            timeoutMs =
                timeoutMs === undefined
                    ? options.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return await (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__.runUnaryCall)({
                interceptors: options.interceptors,
                signal,
                timeoutMs,
                req: {
                    stream: false,
                    service,
                    method,
                    url: (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__.createMethodUrl)(options.baseUrl, service, method),
                    init: {
                        method: "POST",
                        credentials: (_a = options.credentials) !== null && _a !== void 0 ? _a : "same-origin",
                        redirect: "error",
                        mode: "cors",
                    },
                    header: (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_5__.requestHeader)(useBinaryFormat, timeoutMs, header, false),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__.createContextValues)(),
                    message,
                },
                next: async (req) => {
                    var _a;
                    const fetch = (_a = options.fetch) !== null && _a !== void 0 ? _a : globalThis.fetch;
                    const response = await fetch(req.url, Object.assign(Object.assign({}, req.init), { headers: req.header, signal: req.signal, body: (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_6__.encodeEnvelope)(0, serialize(req.message)) }));
                    (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_7__.validateResponse)(response.status, response.headers);
                    if (!response.body) {
                        throw "missing response body";
                    }
                    const reader = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_6__.createEnvelopeReadableStream)(response.body).getReader();
                    let trailer;
                    let message;
                    for (;;) {
                        const r = await reader.read();
                        if (r.done) {
                            break;
                        }
                        const { flags, data } = r.value;
                        if (flags === _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__.trailerFlag) {
                            if (trailer !== undefined) {
                                throw "extra trailer";
                            }
                            // Unary responses require exactly one response message, but in
                            // case of an error, it is perfectly valid to have a response body
                            // that only contains error trailers.
                            trailer = (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__.trailerParse)(data);
                            continue;
                        }
                        if (message !== undefined) {
                            throw "extra message";
                        }
                        message = parse(data);
                    }
                    if (trailer === undefined) {
                        throw "missing trailer";
                    }
                    (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_9__.validateTrailer)(trailer, response.headers);
                    if (message === undefined) {
                        throw "missing message";
                    }
                    return {
                        stream: false,
                        service,
                        method,
                        header: response.headers,
                        message,
                        trailer,
                    };
                },
            });
        },
        async stream(service, method, signal, timeoutMs, header, input, contextValues) {
            var _a;
            const { serialize, parse } = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_2__.createClientMethodSerializers)(method, useBinaryFormat, options.jsonOptions, options.binaryOptions);
            function parseResponseBody(body, foundStatus, trailerTarget, header) {
                return __asyncGenerator(this, arguments, function* parseResponseBody_1() {
                    const reader = (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_6__.createEnvelopeReadableStream)(body).getReader();
                    if (foundStatus) {
                        // A grpc-status: 0 response header was present. This is a "trailers-only"
                        // response (a response without a body and no trailers).
                        //
                        // The spec seems to disallow a trailers-only response for status 0 - we are
                        // lenient and only verify that the body is empty.
                        //
                        // > [...] Trailers-Only is permitted for calls that produce an immediate error.
                        // See https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md
                        if (!(yield __await(reader.read())).done) {
                            throw "extra data for trailers-only";
                        }
                        return yield __await(void 0);
                    }
                    let trailerReceived = false;
                    for (;;) {
                        const result = yield __await(reader.read());
                        if (result.done) {
                            break;
                        }
                        const { flags, data } = result.value;
                        if ((flags & _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__.trailerFlag) === _connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__.trailerFlag) {
                            if (trailerReceived) {
                                throw "extra trailer";
                            }
                            trailerReceived = true;
                            const trailer = (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_8__.trailerParse)(data);
                            (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_9__.validateTrailer)(trailer, header);
                            trailer.forEach((value, key) => trailerTarget.set(key, value));
                            continue;
                        }
                        if (trailerReceived) {
                            throw "extra message";
                        }
                        yield yield __await(parse(data));
                        continue;
                    }
                    if (!trailerReceived) {
                        throw "missing trailer";
                    }
                });
            }
            async function createRequestBody(input) {
                if (method.kind != _bufbuild_protobuf__WEBPACK_IMPORTED_MODULE_10__.MethodKind.ServerStreaming) {
                    throw "The fetch API does not support streaming request bodies";
                }
                const r = await input[Symbol.asyncIterator]().next();
                if (r.done == true) {
                    throw "missing request message";
                }
                return (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_6__.encodeEnvelope)(0, serialize(r.value));
            }
            timeoutMs =
                timeoutMs === undefined
                    ? options.defaultTimeoutMs
                    : timeoutMs <= 0
                        ? undefined
                        : timeoutMs;
            return (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_3__.runStreamingCall)({
                interceptors: options.interceptors,
                signal,
                timeoutMs,
                req: {
                    stream: true,
                    service,
                    method,
                    url: (0,_connectrpc_connect_protocol__WEBPACK_IMPORTED_MODULE_4__.createMethodUrl)(options.baseUrl, service, method),
                    init: {
                        method: "POST",
                        credentials: (_a = options.credentials) !== null && _a !== void 0 ? _a : "same-origin",
                        redirect: "error",
                        mode: "cors",
                    },
                    header: (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_5__.requestHeader)(useBinaryFormat, timeoutMs, header, false),
                    contextValues: contextValues !== null && contextValues !== void 0 ? contextValues : (0,_connectrpc_connect__WEBPACK_IMPORTED_MODULE_0__.createContextValues)(),
                    message: input,
                },
                next: async (req) => {
                    var _a;
                    const fetch = (_a = options.fetch) !== null && _a !== void 0 ? _a : globalThis.fetch;
                    const fRes = await fetch(req.url, Object.assign(Object.assign({}, req.init), { headers: req.header, signal: req.signal, body: await createRequestBody(req.message) }));
                    const { foundStatus } = (0,_connectrpc_connect_protocol_grpc_web__WEBPACK_IMPORTED_MODULE_7__.validateResponse)(fRes.status, fRes.headers);
                    if (!fRes.body) {
                        throw "missing response body";
                    }
                    const trailer = new Headers();
                    const res = Object.assign(Object.assign({}, req), { header: fRes.headers, trailer, message: parseResponseBody(fRes.body, foundStatus, trailer, fRes.headers) });
                    return res;
                },
            });
        },
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect-web/dist/esm/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@connectrpc/connect-web/dist/esm/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConnectTransport: () => (/* reexport safe */ _connect_transport_js__WEBPACK_IMPORTED_MODULE_0__.createConnectTransport),
/* harmony export */   createGrpcWebTransport: () => (/* reexport safe */ _grpc_web_transport_js__WEBPACK_IMPORTED_MODULE_1__.createGrpcWebTransport)
/* harmony export */ });
/* harmony import */ var _connect_transport_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./connect-transport.js */ "./node_modules/@connectrpc/connect-web/dist/esm/connect-transport.js");
/* harmony import */ var _grpc_web_transport_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./grpc-web-transport.js */ "./node_modules/@connectrpc/connect-web/dist/esm/grpc-web-transport.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/request-header.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/request-header.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   requestHeader: () => (/* binding */ requestHeader),
/* harmony export */   requestHeaderWithCompression: () => (/* binding */ requestHeaderWithCompression)
/* harmony export */ });
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/headers.js");
/* harmony import */ var _content_type_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./content-type.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/content-type.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Creates headers for a gRPC-web request.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requestHeader(useBinaryFormat, timeoutMs, userProvidedHeaders, setUserAgent) {
    const result = new Headers(userProvidedHeaders !== null && userProvidedHeaders !== void 0 ? userProvidedHeaders : {});
    // Note that we do not support the grpc-web-text format.
    // https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-WEB.md#protocol-differences-vs-grpc-over-http2
    result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerContentType, useBinaryFormat ? _content_type_js__WEBPACK_IMPORTED_MODULE_1__.contentTypeProto : _content_type_js__WEBPACK_IMPORTED_MODULE_1__.contentTypeJson);
    result.set(_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerXGrpcWeb, "1");
    // Note that we do not strictly comply with gRPC user agents.
    // We use "connect-es/1.2.3" where gRPC would use "grpc-es/1.2.3".
    // See https://github.com/grpc/grpc/blob/c462bb8d485fc1434ecfae438823ca8d14cf3154/doc/PROTOCOL-HTTP2.md#user-agents
    result.set(_headers_js__WEBPACK_IMPORTED_MODULE_2__.headerXUserAgent, "connect-es/1.4.0");
    if (setUserAgent) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerUserAgent, "connect-es/1.4.0");
    }
    if (timeoutMs !== undefined) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerTimeout, `${timeoutMs}m`);
    }
    return result;
}
/**
 * Creates headers for a gRPC-web request with compression.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function requestHeaderWithCompression(useBinaryFormat, timeoutMs, userProvidedHeaders, acceptCompression, sendCompression, setUserAgent) {
    const result = requestHeader(useBinaryFormat, timeoutMs, userProvidedHeaders, setUserAgent);
    if (sendCompression != null) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerEncoding, sendCompression.name);
    }
    if (acceptCompression.length > 0) {
        result.set(_headers_js__WEBPACK_IMPORTED_MODULE_0__.headerAcceptEncoding, acceptCompression.map((c) => c.name).join(","));
    }
    return result;
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/validate-response.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc-web/validate-response.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   validateResponse: () => (/* binding */ validateResponse),
/* harmony export */   validateResponseWithCompression: () => (/* binding */ validateResponseWithCompression)
/* harmony export */ });
/* harmony import */ var _connect_error_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../connect-error.js */ "./node_modules/@connectrpc/connect/dist/esm/connect-error.js");
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
/* harmony import */ var _headers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./headers.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/headers.js");
/* harmony import */ var _protocol_grpc_http_status_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../protocol-grpc/http-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/http-status.js");
/* harmony import */ var _protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../protocol-grpc/trailer-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Validates response status and header for the gRPC-web protocol.
 *
 * Throws a ConnectError if the header contains an error status,
 * or if the HTTP status indicates an error.
 *
 * Returns an object that indicates whether a gRPC status was found
 * in the response header. In this case, clients can not expect a
 * trailer.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateResponse(status, headers) {
    var _a;
    // For compatibility with the `grpc-web` package, we treat all HTTP status
    // codes in the 200 range as valid, not just HTTP 200.
    if (status >= 200 && status < 300) {
        const err = (0,_protocol_grpc_trailer_status_js__WEBPACK_IMPORTED_MODULE_0__.findTrailerError)(headers);
        if (err) {
            throw err;
        }
        return { foundStatus: headers.has(_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerGrpcStatus) };
    }
    throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_2__.ConnectError(decodeURIComponent((_a = headers.get(_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerGrpcMessage)) !== null && _a !== void 0 ? _a : `HTTP ${status}`), (0,_protocol_grpc_http_status_js__WEBPACK_IMPORTED_MODULE_3__.codeFromHttpStatus)(status), headers);
}
/**
 * Validates response status and header for the gRPC-web protocol.
 * This function is identical to validateResponse(), but also verifies
 * that a given encoding header is acceptable.
 *
 * Returns an object with the response compression, and a boolean
 * indicating whether a gRPC status was found in the response header
 * (in this case, clients can not expect a trailer).
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateResponseWithCompression(acceptCompression, status, headers) {
    const { foundStatus } = validateResponse(status, headers);
    let compression;
    const encoding = headers.get(_headers_js__WEBPACK_IMPORTED_MODULE_1__.headerEncoding);
    if (encoding !== null && encoding.toLowerCase() !== "identity") {
        compression = acceptCompression.find((c) => c.name === encoding);
        if (!compression) {
            throw new _connect_error_js__WEBPACK_IMPORTED_MODULE_2__.ConnectError(`unsupported response encoding "${encoding}"`, _code_js__WEBPACK_IMPORTED_MODULE_4__.Code.InvalidArgument, headers);
        }
    }
    return {
        foundStatus,
        compression,
    };
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/http-status.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/http-status.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   codeFromHttpStatus: () => (/* binding */ codeFromHttpStatus)
/* harmony export */ });
/* harmony import */ var _code_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../code.js */ "./node_modules/@connectrpc/connect/dist/esm/code.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * Determine the gRPC-web error code for the given HTTP status code.
 * See https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function codeFromHttpStatus(httpStatus) {
    switch (httpStatus) {
        case 400: // Bad Request
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Internal;
        case 401: // Unauthorized
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unauthenticated;
        case 403: // Forbidden
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.PermissionDenied;
        case 404: // Not Found
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unimplemented;
        case 429: // Too Many Requests
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 502: // Bad Gateway
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 503: // Service Unavailable
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        case 504: // Gateway Timeout
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unavailable;
        default:
            // 200 is UNKNOWN because there should be a grpc-status in case of truly OK response.
            return _code_js__WEBPACK_IMPORTED_MODULE_0__.Code.Unknown;
    }
}


/***/ }),

/***/ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/validate-trailer.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/validate-trailer.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   validateTrailer: () => (/* binding */ validateTrailer)
/* harmony export */ });
/* harmony import */ var _trailer_status_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./trailer-status.js */ "./node_modules/@connectrpc/connect/dist/esm/protocol-grpc/trailer-status.js");
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * Validates a trailer for the gRPC and the gRPC-web protocol.
 * Throws a ConnectError if the trailer contains an error status.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateTrailer(trailer, header) {
    const err = (0,_trailer_status_js__WEBPACK_IMPORTED_MODULE_0__.findTrailerError)(trailer);
    if (err) {
        header.forEach((value, key) => {
            err.metadata.append(key, value);
        });
        throw err;
    }
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_connectrpc_connect-web_dist_esm_index_js.41a6a98b853cb6a11dbd.js.map