"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SNS dead letter queue destination configuration for a Lambda event source.
 *
 * @stability stable
 */
class SnsDlq {
    /**
     * @stability stable
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ.
     *
     * @stability stable
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
_a = JSII_RTTI_SYMBOL_1;
SnsDlq[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SnsDlq", version: "1.138.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEsTUFBTTs7OztJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0tBQzdDOzs7Ozs7SUFHTSxJQUFJLENBQUMsT0FBNEIsRUFBRSxhQUF3QjtRQUNoRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUV2QyxPQUFPO1lBQ0wsV0FBVyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtTQUNqQyxDQUFDO0tBQ0g7O0FBWEgsd0JBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEbHFEZXN0aW5hdGlvbkNvbmZpZywgSUV2ZW50U291cmNlRGxxLCBJRXZlbnRTb3VyY2VNYXBwaW5nLCBJRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU25zRGxxIGltcGxlbWVudHMgSUV2ZW50U291cmNlRGxxIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGJpbmQoX3RhcmdldDogSUV2ZW50U291cmNlTWFwcGluZywgdGFyZ2V0SGFuZGxlcjogSUZ1bmN0aW9uKTogRGxxRGVzdGluYXRpb25Db25maWcge1xuICAgIHRoaXMudG9waWMuZ3JhbnRQdWJsaXNoKHRhcmdldEhhbmRsZXIpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnRvcGljLnRvcGljQXJuLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==