# AUTOGENERATED! DO NOT EDIT! File to edit: 03_fastai.transform.ipynb (unless otherwise specified).

__all__ = ['transform_error']

# Cell
from fastai.data.core import TfmdDL
from fastai.data.load import DataLoader

from fastcore.basics import patch
from fastcore.meta import delegates
from fastcore.transform import _get_name, Transform

# Cell
def transform_error(e:Exception, nm:str, event:str) -> Exception:
    """
    Raises Exception `e` stemming from a Transform with more information

    - `nm`: The name of the Transform
    - `event`: The event called (such as `encodes` or `decodes`)
    """
    err = f'There was an issue calling the {event} on transform {nm}:\n\n'
    err += e.args[0]
    e.args = [err]
    raise e

# Cell
@patch
def __call__(self:Transform, x, **kwargs):
    try:
        return self._call('encodes', x, **kwargs)
    except Exception as e:
        transform_error(e, _get_name(self), 'encodes')

# Cell
@patch
def decode(self:Transform, x, **kwargs):
    "Delegate to <code>decodes</code> to undo transform"
    try:
        return self._call('decodes', x, **kwargs)
    except Exception as e:
        transform_error(e, _get_name(self), 'decodes')

# Cell
@patch
@delegates(DataLoader.new)
def new(self:TfmdDL, dataset=None, cls=None, **kwargs):
    "Create a new version of self with a few changed attributes"
    res = super(TfmdDL, self).new(dataset, cls, do_setup=False, **kwargs)
    if not hasattr(self, '_n_inp') or not hasattr(self, '_types'):
        try:
            self._one_pass()
            res._n_inp,res._types = self._n_inp,self._types
        except Exception as e:
            print("Could not do one pass in your DataLoader, there is something wrong in it. Please see the stack trace below:")
            raise e
    else: res._n_inp,res._types = self._n_inp,self._types
    return res