# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class RemovalShipmentItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'removal_shipment_item_id': 'str',
        'tax_collection_model': 'str',
        'fulfillment_network_sku': 'str',
        'quantity': 'int',
        'revenue': 'Currency',
        'fee_amount': 'Currency',
        'tax_amount': 'Currency',
        'tax_withheld': 'Currency'
    }

    attribute_map = {
        'removal_shipment_item_id': 'RemovalShipmentItemId',
        'tax_collection_model': 'TaxCollectionModel',
        'fulfillment_network_sku': 'FulfillmentNetworkSKU',
        'quantity': 'Quantity',
        'revenue': 'Revenue',
        'fee_amount': 'FeeAmount',
        'tax_amount': 'TaxAmount',
        'tax_withheld': 'TaxWithheld'
    }

    def __init__(self, removal_shipment_item_id=None, tax_collection_model=None, fulfillment_network_sku=None, quantity=None, revenue=None, fee_amount=None, tax_amount=None, tax_withheld=None):  # noqa: E501
        """RemovalShipmentItem - a model defined in Swagger"""  # noqa: E501
        self._removal_shipment_item_id = None
        self._tax_collection_model = None
        self._fulfillment_network_sku = None
        self._quantity = None
        self._revenue = None
        self._fee_amount = None
        self._tax_amount = None
        self._tax_withheld = None
        self.discriminator = None
        if removal_shipment_item_id is not None:
            self.removal_shipment_item_id = removal_shipment_item_id
        if tax_collection_model is not None:
            self.tax_collection_model = tax_collection_model
        if fulfillment_network_sku is not None:
            self.fulfillment_network_sku = fulfillment_network_sku
        if quantity is not None:
            self.quantity = quantity
        if revenue is not None:
            self.revenue = revenue
        if fee_amount is not None:
            self.fee_amount = fee_amount
        if tax_amount is not None:
            self.tax_amount = tax_amount
        if tax_withheld is not None:
            self.tax_withheld = tax_withheld

    @property
    def removal_shipment_item_id(self):
        """Gets the removal_shipment_item_id of this RemovalShipmentItem.  # noqa: E501

        An identifier for an item in a removal shipment.  # noqa: E501

        :return: The removal_shipment_item_id of this RemovalShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._removal_shipment_item_id

    @removal_shipment_item_id.setter
    def removal_shipment_item_id(self, removal_shipment_item_id):
        """Sets the removal_shipment_item_id of this RemovalShipmentItem.

        An identifier for an item in a removal shipment.  # noqa: E501

        :param removal_shipment_item_id: The removal_shipment_item_id of this RemovalShipmentItem.  # noqa: E501
        :type: str
        """

        self._removal_shipment_item_id = removal_shipment_item_id

    @property
    def tax_collection_model(self):
        """Gets the tax_collection_model of this RemovalShipmentItem.  # noqa: E501

        The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.  # noqa: E501

        :return: The tax_collection_model of this RemovalShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._tax_collection_model

    @tax_collection_model.setter
    def tax_collection_model(self, tax_collection_model):
        """Sets the tax_collection_model of this RemovalShipmentItem.

        The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.  # noqa: E501

        :param tax_collection_model: The tax_collection_model of this RemovalShipmentItem.  # noqa: E501
        :type: str
        """

        self._tax_collection_model = tax_collection_model

    @property
    def fulfillment_network_sku(self):
        """Gets the fulfillment_network_sku of this RemovalShipmentItem.  # noqa: E501

        The Amazon fulfillment network SKU for the item.  # noqa: E501

        :return: The fulfillment_network_sku of this RemovalShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._fulfillment_network_sku

    @fulfillment_network_sku.setter
    def fulfillment_network_sku(self, fulfillment_network_sku):
        """Sets the fulfillment_network_sku of this RemovalShipmentItem.

        The Amazon fulfillment network SKU for the item.  # noqa: E501

        :param fulfillment_network_sku: The fulfillment_network_sku of this RemovalShipmentItem.  # noqa: E501
        :type: str
        """

        self._fulfillment_network_sku = fulfillment_network_sku

    @property
    def quantity(self):
        """Gets the quantity of this RemovalShipmentItem.  # noqa: E501

        The quantity of the item.  # noqa: E501

        :return: The quantity of this RemovalShipmentItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this RemovalShipmentItem.

        The quantity of the item.  # noqa: E501

        :param quantity: The quantity of this RemovalShipmentItem.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def revenue(self):
        """Gets the revenue of this RemovalShipmentItem.  # noqa: E501


        :return: The revenue of this RemovalShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._revenue

    @revenue.setter
    def revenue(self, revenue):
        """Sets the revenue of this RemovalShipmentItem.


        :param revenue: The revenue of this RemovalShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._revenue = revenue

    @property
    def fee_amount(self):
        """Gets the fee_amount of this RemovalShipmentItem.  # noqa: E501


        :return: The fee_amount of this RemovalShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._fee_amount

    @fee_amount.setter
    def fee_amount(self, fee_amount):
        """Sets the fee_amount of this RemovalShipmentItem.


        :param fee_amount: The fee_amount of this RemovalShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._fee_amount = fee_amount

    @property
    def tax_amount(self):
        """Gets the tax_amount of this RemovalShipmentItem.  # noqa: E501


        :return: The tax_amount of this RemovalShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """Sets the tax_amount of this RemovalShipmentItem.


        :param tax_amount: The tax_amount of this RemovalShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._tax_amount = tax_amount

    @property
    def tax_withheld(self):
        """Gets the tax_withheld of this RemovalShipmentItem.  # noqa: E501


        :return: The tax_withheld of this RemovalShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_withheld

    @tax_withheld.setter
    def tax_withheld(self, tax_withheld):
        """Sets the tax_withheld of this RemovalShipmentItem.


        :param tax_withheld: The tax_withheld of this RemovalShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._tax_withheld = tax_withheld

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RemovalShipmentItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RemovalShipmentItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
