# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict, Optional  # noqa: F401

from properly_model_python.search_models.models.search import Search
from properly_model_python.search_models.models.base_model_ import Model
from properly_model_python.search_models import util


class UsersSearch(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        id: str = None,
        search_id: str = None,
        search_data: Search = None,
        user_id: str = None,
        last_run_millis: int = None,
        last_run_search_result_id: str = None,
    ):  # noqa: E501
        """UsersSearch - a model defined in Swagger

        :param id: The id of this UsersSearch.  # noqa: E501
        :type id: str
        :param search_id: The search_id of this UsersSearch.  # noqa: E501
        :type search_id: str
        :param search_data: The search_data of this UsersSearch.  # noqa: E501
        :type search_data: Search
        :param user_id: The user_id of this UsersSearch.  # noqa: E501
        :type user_id: str
        :param last_run_millis: The last_run_millis of this UsersSearch.  # noqa: E501
        :type last_run_millis: int
        :param last_run_search_result_id: The last_run_search_result_id of this UsersSearch.  # noqa: E501
        :type last_run_search_result_id: str
        """
        self.swagger_types = {
            "id": str,
            "search_id": str,
            "search_data": Search,
            "user_id": str,
            "last_run_millis": int,
            "last_run_search_result_id": str,
        }

        self.attribute_map = {
            "id": "id",
            "search_id": "searchId",
            "search_data": "searchData",
            "user_id": "userId",
            "last_run_millis": "lastRunMillis",
            "last_run_search_result_id": "lastRunSearchResultId",
        }

        self._id = id
        self._search_id = search_id
        self._search_data = search_data
        self._user_id = user_id
        self._last_run_millis = last_run_millis
        self._last_run_search_result_id = last_run_search_result_id

    @classmethod
    def from_dict(cls, dikt) -> "UsersSearch":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UsersSearch of this UsersSearch.  # noqa: E501
        :rtype: UsersSearch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this UsersSearch.


        :return: The id of this UsersSearch.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this UsersSearch.


        :param id: The id of this UsersSearch.
        :type id: str
        """

        self._id = id

    @property
    def search_id(self) -> str:
        """Gets the search_id of this UsersSearch.


        :return: The search_id of this UsersSearch.
        :rtype: str
        """
        return self._search_id

    @search_id.setter
    def search_id(self, search_id: str):
        """Sets the search_id of this UsersSearch.


        :param search_id: The search_id of this UsersSearch.
        :type search_id: str
        """

        self._search_id = search_id

    @property
    def search_data(self) -> Optional[Search]:
        """Gets the search_data of this UsersSearch.


        :return: The search_data of this UsersSearch.
        :rtype: Search
        """
        return self._search_data

    @search_data.setter
    def search_data(self, search_data: Optional[Search]):
        """Sets the search_data of this UsersSearch.


        :param search_data: The search_data of this UsersSearch.
        :type search_data: Search
        """

        self._search_data = search_data

    @property
    def user_id(self) -> str:
        """Gets the user_id of this UsersSearch.


        :return: The user_id of this UsersSearch.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str):
        """Sets the user_id of this UsersSearch.


        :param user_id: The user_id of this UsersSearch.
        :type user_id: str
        """

        self._user_id = user_id

    @property
    def last_run_millis(self) -> int:
        """Gets the last_run_millis of this UsersSearch.


        :return: The last_run_millis of this UsersSearch.
        :rtype: int
        """
        return self._last_run_millis

    @last_run_millis.setter
    def last_run_millis(self, last_run_millis: int):
        """Sets the last_run_millis of this UsersSearch.


        :param last_run_millis: The last_run_millis of this UsersSearch.
        :type last_run_millis: int
        """

        self._last_run_millis = last_run_millis

    @property
    def last_run_search_result_id(self) -> str:
        """Gets the last_run_search_result_id of this UsersSearch.


        :return: The last_run_search_result_id of this UsersSearch.
        :rtype: str
        """
        return self._last_run_search_result_id

    @last_run_search_result_id.setter
    def last_run_search_result_id(self, last_run_search_result_id: str):
        """Sets the last_run_search_result_id of this UsersSearch.


        :param last_run_search_result_id: The last_run_search_result_id of this UsersSearch.
        :type last_run_search_result_id: str
        """

        self._last_run_search_result_id = last_run_search_result_id
