# hwmux-client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.0
- Package version: 0.0.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import hwmux_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import hwmux_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import hwmux_client
from pprint import pprint
from hwmux_client.api import _token_auth_api
from hwmux_client.model.auth_token import AuthToken
# Defining the host is optional and defaults to https://hwmux.silabs.net
# See configuration.py for a list of all supported configuration parameters.
configuration = hwmux_client.Configuration(
    host = "https://hwmux.silabs.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'

# Configure API key authorization: tokenAuth
configuration.api_key['tokenAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['tokenAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with hwmux_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = _token_auth_api.TokenAuthApi(api_client)
    username = "username_example" # str | 
password = "password_example" # str | 
token = "token_example" # str | 

    try:
        api_response = api_instance.token_auth_create(username, password, token)
        pprint(api_response)
    except hwmux_client.ApiException as e:
        print("Exception when calling TokenAuthApi->token_auth_create: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://hwmux.silabs.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TokenAuthApi* | [**token_auth_create**](docs/TokenAuthApi.md#token_auth_create) | **POST** /api-token-auth/ | 
*AdminApi* | [**admin_efrpool_devices_offline_create**](docs/AdminApi.md#admin_efrpool_devices_offline_create) | **POST** /admin/efrpool/devices/offline/ | 
*DevicesApi* | [**devices_create**](docs/DevicesApi.md#devices_create) | **POST** /api/devices/ | 
*DevicesApi* | [**devices_destroy**](docs/DevicesApi.md#devices_destroy) | **DELETE** /api/devices/{id}/ | 
*DevicesApi* | [**devices_list**](docs/DevicesApi.md#devices_list) | **GET** /api/devices/ | 
*DevicesApi* | [**devices_list_my_retrieve**](docs/DevicesApi.md#devices_list_my_retrieve) | **GET** /api/devices/list_my/ | 
*DevicesApi* | [**devices_partial_update**](docs/DevicesApi.md#devices_partial_update) | **PATCH** /api/devices/{id}/ | 
*DevicesApi* | [**devices_release_update**](docs/DevicesApi.md#devices_release_update) | **PUT** /api/devices/{id}/release/ | 
*DevicesApi* | [**devices_reserve_update**](docs/DevicesApi.md#devices_reserve_update) | **PUT** /api/devices/{id}/reserve/ | 
*DevicesApi* | [**devices_retrieve**](docs/DevicesApi.md#devices_retrieve) | **GET** /api/devices/{id}/ | 
*DevicesApi* | [**devices_search_retrieve**](docs/DevicesApi.md#devices_search_retrieve) | **GET** /api/devices/search/ | 
*DevicesApi* | [**devices_set_offline_create**](docs/DevicesApi.md#devices_set_offline_create) | **POST** /api/devices/set_offline/ | 
*DevicesApi* | [**devices_update**](docs/DevicesApi.md#devices_update) | **PUT** /api/devices/{id}/ | 
*GroupsApi* | [**groups_available_retrieve**](docs/GroupsApi.md#groups_available_retrieve) | **GET** /api/groups/available/ | 
*GroupsApi* | [**groups_create**](docs/GroupsApi.md#groups_create) | **POST** /api/groups/ | 
*GroupsApi* | [**groups_create_with_devices_create**](docs/GroupsApi.md#groups_create_with_devices_create) | **POST** /api/groups/create-with-devices | 
*GroupsApi* | [**groups_destroy**](docs/GroupsApi.md#groups_destroy) | **DELETE** /api/groups/{id}/ | 
*GroupsApi* | [**groups_list**](docs/GroupsApi.md#groups_list) | **GET** /api/groups/ | 
*GroupsApi* | [**groups_my_retrieve**](docs/GroupsApi.md#groups_my_retrieve) | **GET** /api/groups/my/ | 
*GroupsApi* | [**groups_partial_update**](docs/GroupsApi.md#groups_partial_update) | **PATCH** /api/groups/{id}/ | 
*GroupsApi* | [**groups_release_by_name_update**](docs/GroupsApi.md#groups_release_by_name_update) | **PUT** /api/groups/{group_name}/release_by_name/ | 
*GroupsApi* | [**groups_release_update**](docs/GroupsApi.md#groups_release_update) | **PUT** /api/groups/{id}/release/ | 
*GroupsApi* | [**groups_reserve_by_name_update**](docs/GroupsApi.md#groups_reserve_by_name_update) | **PUT** /api/groups/{group_name}/reserve_by_name/ | 
*GroupsApi* | [**groups_reserve_update**](docs/GroupsApi.md#groups_reserve_update) | **PUT** /api/groups/{id}/reserve/ | 
*GroupsApi* | [**groups_retrieve**](docs/GroupsApi.md#groups_retrieve) | **GET** /api/groups/{id}/ | 
*GroupsApi* | [**groups_update**](docs/GroupsApi.md#groups_update) | **PUT** /api/groups/{id}/ | 
*LabelsApi* | [**labels_create**](docs/LabelsApi.md#labels_create) | **POST** /api/labels/ | 
*LabelsApi* | [**labels_destroy**](docs/LabelsApi.md#labels_destroy) | **DELETE** /api/labels/{id}/ | 
*LabelsApi* | [**labels_list**](docs/LabelsApi.md#labels_list) | **GET** /api/labels/ | 
*LabelsApi* | [**labels_partial_update**](docs/LabelsApi.md#labels_partial_update) | **PATCH** /api/labels/{id}/ | 
*LabelsApi* | [**labels_release_all_update**](docs/LabelsApi.md#labels_release_all_update) | **PUT** /api/labels/{id}/release_all/ | 
*LabelsApi* | [**labels_reserve_all_update**](docs/LabelsApi.md#labels_reserve_all_update) | **PUT** /api/labels/{id}/reserve_all/ | 
*LabelsApi* | [**labels_reserve_any_update**](docs/LabelsApi.md#labels_reserve_any_update) | **PUT** /api/labels/{id}/reserve_any/ | 
*LabelsApi* | [**labels_retrieve**](docs/LabelsApi.md#labels_retrieve) | **GET** /api/labels/{id}/ | 
*LabelsApi* | [**labels_update**](docs/LabelsApi.md#labels_update) | **PUT** /api/labels/{id}/ | 
*LogsApi* | [**logs_destroy**](docs/LogsApi.md#logs_destroy) | **DELETE** /api/logs/{id} | 
*LogsApi* | [**logs_list**](docs/LogsApi.md#logs_list) | **GET** /api/logs/ | 
*LogsApi* | [**logs_retrieve**](docs/LogsApi.md#logs_retrieve) | **GET** /api/logs/{id}/ | 
*PartFamiliesApi* | [**part_families_create**](docs/PartFamiliesApi.md#part_families_create) | **POST** /api/part-families/ | 
*PartFamiliesApi* | [**part_families_destroy**](docs/PartFamiliesApi.md#part_families_destroy) | **DELETE** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_list**](docs/PartFamiliesApi.md#part_families_list) | **GET** /api/part-families/ | 
*PartFamiliesApi* | [**part_families_partial_update**](docs/PartFamiliesApi.md#part_families_partial_update) | **PATCH** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_parts_create**](docs/PartFamiliesApi.md#part_families_parts_create) | **POST** /api/part-families/{part_family_pk}/parts/ | 
*PartFamiliesApi* | [**part_families_parts_destroy**](docs/PartFamiliesApi.md#part_families_parts_destroy) | **DELETE** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_list**](docs/PartFamiliesApi.md#part_families_parts_list) | **GET** /api/part-families/{part_family_pk}/parts/ | 
*PartFamiliesApi* | [**part_families_parts_partial_update**](docs/PartFamiliesApi.md#part_families_parts_partial_update) | **PATCH** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_retrieve**](docs/PartFamiliesApi.md#part_families_parts_retrieve) | **GET** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_parts_update**](docs/PartFamiliesApi.md#part_families_parts_update) | **PUT** /api/part-families/{part_family_pk}/parts/{id}/ | 
*PartFamiliesApi* | [**part_families_retrieve**](docs/PartFamiliesApi.md#part_families_retrieve) | **GET** /api/part-families/{name}/ | 
*PartFamiliesApi* | [**part_families_update**](docs/PartFamiliesApi.md#part_families_update) | **PUT** /api/part-families/{name}/ | 
*PartsApi* | [**parts_list**](docs/PartsApi.md#parts_list) | **GET** /api/parts/ | 
*PartsApi* | [**parts_retrieve**](docs/PartsApi.md#parts_retrieve) | **GET** /api/parts/{part_no}/ | 
*RoomsApi* | [**rooms_list**](docs/RoomsApi.md#rooms_list) | **GET** /api/rooms/ | 
*RoomsApi* | [**rooms_retrieve**](docs/RoomsApi.md#rooms_retrieve) | **GET** /api/rooms/{name}/ | 
*SchemaApi* | [**schema_download_retrieve**](docs/SchemaApi.md#schema_download_retrieve) | **GET** /schema/download | 
*SitesApi* | [**sites_create**](docs/SitesApi.md#sites_create) | **POST** /api/sites/ | 
*SitesApi* | [**sites_destroy**](docs/SitesApi.md#sites_destroy) | **DELETE** /api/sites/{name}/ | 
*SitesApi* | [**sites_list**](docs/SitesApi.md#sites_list) | **GET** /api/sites/ | 
*SitesApi* | [**sites_partial_update**](docs/SitesApi.md#sites_partial_update) | **PATCH** /api/sites/{name}/ | 
*SitesApi* | [**sites_retrieve**](docs/SitesApi.md#sites_retrieve) | **GET** /api/sites/{name}/ | 
*SitesApi* | [**sites_rooms_create**](docs/SitesApi.md#sites_rooms_create) | **POST** /api/sites/{site_pk}/rooms/ | 
*SitesApi* | [**sites_rooms_destroy**](docs/SitesApi.md#sites_rooms_destroy) | **DELETE** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_list**](docs/SitesApi.md#sites_rooms_list) | **GET** /api/sites/{site_pk}/rooms/ | 
*SitesApi* | [**sites_rooms_locations_create**](docs/SitesApi.md#sites_rooms_locations_create) | **POST** /api/sites/{site_pk}/rooms/{room_pk}/locations/ | 
*SitesApi* | [**sites_rooms_locations_partial_update**](docs/SitesApi.md#sites_rooms_locations_partial_update) | **PATCH** /api/sites/{site_pk}/rooms/{room_pk}/locations/{id}/ | 
*SitesApi* | [**sites_rooms_locations_retrieve**](docs/SitesApi.md#sites_rooms_locations_retrieve) | **GET** /api/sites/{site_pk}/rooms/{room_pk}/locations/{id}/ | 
*SitesApi* | [**sites_rooms_locations_update**](docs/SitesApi.md#sites_rooms_locations_update) | **PUT** /api/sites/{site_pk}/rooms/{room_pk}/locations/{id}/ | 
*SitesApi* | [**sites_rooms_partial_update**](docs/SitesApi.md#sites_rooms_partial_update) | **PATCH** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_retrieve**](docs/SitesApi.md#sites_rooms_retrieve) | **GET** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_rooms_update**](docs/SitesApi.md#sites_rooms_update) | **PUT** /api/sites/{site_pk}/rooms/{id}/ | 
*SitesApi* | [**sites_update**](docs/SitesApi.md#sites_update) | **PUT** /api/sites/{name}/ | 


## Documentation For Models

 - [AuthToken](docs/AuthToken.md)
 - [DeviceGroup](docs/DeviceGroup.md)
 - [DeviceGroupSerializerWithDevicePk](docs/DeviceGroupSerializerWithDevicePk.md)
 - [DeviceSerializerPrivate](docs/DeviceSerializerPrivate.md)
 - [DeviceSerializerWithPermissions](docs/DeviceSerializerWithPermissions.md)
 - [EventEnum](docs/EventEnum.md)
 - [Label](docs/Label.md)
 - [LabelSerializerWithGroupAsPk](docs/LabelSerializerWithGroupAsPk.md)
 - [LightDevice](docs/LightDevice.md)
 - [Location](docs/Location.md)
 - [LocationSerializerWriteOnly](docs/LocationSerializerWriteOnly.md)
 - [Log](docs/Log.md)
 - [NestedDeviceGroup](docs/NestedDeviceGroup.md)
 - [PaginatedDeviceGroupList](docs/PaginatedDeviceGroupList.md)
 - [PaginatedDeviceSerializerPrivateList](docs/PaginatedDeviceSerializerPrivateList.md)
 - [PaginatedLabelList](docs/PaginatedLabelList.md)
 - [PaginatedLogList](docs/PaginatedLogList.md)
 - [PaginatedPartFamilyList](docs/PaginatedPartFamilyList.md)
 - [PaginatedPartList](docs/PaginatedPartList.md)
 - [PaginatedRoomList](docs/PaginatedRoomList.md)
 - [PaginatedSiteList](docs/PaginatedSiteList.md)
 - [Part](docs/Part.md)
 - [PartFamily](docs/PartFamily.md)
 - [PatchedDeviceGroupSerializerWithDevicePk](docs/PatchedDeviceGroupSerializerWithDevicePk.md)
 - [PatchedDeviceSerializerWithPermissions](docs/PatchedDeviceSerializerWithPermissions.md)
 - [PatchedLabelSerializerWithGroupAsPk](docs/PatchedLabelSerializerWithGroupAsPk.md)
 - [PatchedLocation](docs/PatchedLocation.md)
 - [PatchedPart](docs/PatchedPart.md)
 - [PatchedPartFamily](docs/PatchedPartFamily.md)
 - [PatchedRoom](docs/PatchedRoom.md)
 - [PatchedSite](docs/PatchedSite.md)
 - [Room](docs/Room.md)
 - [Site](docs/Site.md)
 - [User](docs/User.md)
 - [WriteOnlyDevice](docs/WriteOnlyDevice.md)


## Documentation For Authorization


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in hwmux_client.apis and hwmux_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from hwmux_client.api.default_api import DefaultApi`
- `from hwmux_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import hwmux_client
from hwmux_client.apis import *
from hwmux_client.models import *
```

