"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmsEncryptionKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_kms_1 = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class KmsEncryptionKey extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.environmentName = (_b = props === null || props === void 0 ? void 0 : props.environmentName) !== null && _b !== void 0 ? _b : 'DEV';
        this.description = this.getKeyName(props === null || props === void 0 ? void 0 : props.description);
        this.keyName = this.getKeyName(props === null || props === void 0 ? void 0 : props.keyName);
        this.kmsKey = this.createKmsKey((_c = props === null || props === void 0 ? void 0 : props.kmsAdministratorArns) !== null && _c !== void 0 ? _c : []);
        this.addTags();
    }
    /**
     * @stability stable
     */
    static getArnPrincipals(kmsAdministratorArns) {
        return kmsAdministratorArns.map((arn) => new aws_iam_1.ArnPrincipal(arn));
    }
    /**
     * @stability stable
     */
    static getAdministratorArns(kmsAdministratorArns) {
        return [
            new aws_iam_1.CompositePrincipal(...KmsEncryptionKey.getArnPrincipals(kmsAdministratorArns)),
        ];
    }
    /**
     * @stability stable
     */
    static createKeyPolicy(kmsAdministratorArns) {
        return new aws_iam_1.PolicyDocument({
            statements: [
                new aws_iam_1.PolicyStatement({
                    actions: ['kms:*'],
                    resources: ['*'],
                    principals: KmsEncryptionKey.getAdministratorArns(kmsAdministratorArns),
                }),
            ],
        });
    }
    /**
     * @stability stable
     */
    getKeyName(keyName) {
        return keyName !== null && keyName !== void 0 ? keyName : `${this.environmentName}-kms-encryption-key`;
    }
    /**
     * @stability stable
     */
    createKmsKey(kmsAdministratorArns) {
        return new aws_kms_1.Key(this, 'EncryptionKey', {
            alias: this.keyName,
            description: this.description,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            policy: KmsEncryptionKey.createKeyPolicy(kmsAdministratorArns),
        });
    }
    /**
     * @stability stable
     */
    addTags() {
        core_1.Tags.of(this).add('environment', this.environmentName);
        core_1.Tags.of(this).add('alias', this.keyName);
    }
}
exports.KmsEncryptionKey = KmsEncryptionKey;
_a = JSII_RTTI_SYMBOL_1;
KmsEncryptionKey[_a] = { fqn: "kms-encryption-key.KmsEncryptionKey", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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