# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.0.20.34  # noqa: E501
    The version of the OpenAPI document: 0.8.10
    Contact: ravi@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class ResolutionStatementBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'height': 'str',
        'unresolved': 'AnyOfstringstring',
        'resolution_entries': 'list[ResolutionEntryDTO]'
    }

    attribute_map = {
        'height': 'height',
        'unresolved': 'unresolved',
        'resolution_entries': 'resolutionEntries'
    }

    def __init__(self, height=None, unresolved=None, resolution_entries=None, local_vars_configuration=None):  # noqa: E501
        """ResolutionStatementBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._height = None
        self._unresolved = None
        self._resolution_entries = None
        self.discriminator = None

        self.height = height
        self.unresolved = unresolved
        self.resolution_entries = resolution_entries

    @property
    def height(self):
        """Gets the height of this ResolutionStatementBodyDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The height of this ResolutionStatementBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this ResolutionStatementBodyDTO.

        Height of the blockchain.  # noqa: E501

        :param height: The height of this ResolutionStatementBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and height is None:  # noqa: E501
            raise ValueError("Invalid value for `height`, must not be `None`")  # noqa: E501

        self._height = height

    @property
    def unresolved(self):
        """Gets the unresolved of this ResolutionStatementBodyDTO.  # noqa: E501


        :return: The unresolved of this ResolutionStatementBodyDTO.  # noqa: E501
        :rtype: AnyOfstringstring
        """
        return self._unresolved

    @unresolved.setter
    def unresolved(self, unresolved):
        """Sets the unresolved of this ResolutionStatementBodyDTO.


        :param unresolved: The unresolved of this ResolutionStatementBodyDTO.  # noqa: E501
        :type: AnyOfstringstring
        """
        if self.local_vars_configuration.client_side_validation and unresolved is None:  # noqa: E501
            raise ValueError("Invalid value for `unresolved`, must not be `None`")  # noqa: E501

        self._unresolved = unresolved

    @property
    def resolution_entries(self):
        """Gets the resolution_entries of this ResolutionStatementBodyDTO.  # noqa: E501

        Array of resolution entries linked to the unresolved namespaceId. It is an array instead of a single resolution entry since within one block the resolution might change for different sources due to alias related transactions.   # noqa: E501

        :return: The resolution_entries of this ResolutionStatementBodyDTO.  # noqa: E501
        :rtype: list[ResolutionEntryDTO]
        """
        return self._resolution_entries

    @resolution_entries.setter
    def resolution_entries(self, resolution_entries):
        """Sets the resolution_entries of this ResolutionStatementBodyDTO.

        Array of resolution entries linked to the unresolved namespaceId. It is an array instead of a single resolution entry since within one block the resolution might change for different sources due to alias related transactions.   # noqa: E501

        :param resolution_entries: The resolution_entries of this ResolutionStatementBodyDTO.  # noqa: E501
        :type: list[ResolutionEntryDTO]
        """
        if self.local_vars_configuration.client_side_validation and resolution_entries is None:  # noqa: E501
            raise ValueError("Invalid value for `resolution_entries`, must not be `None`")  # noqa: E501

        self._resolution_entries = resolution_entries

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResolutionStatementBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ResolutionStatementBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
