/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { YamlFile } from "projen";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { ClientLanguage } from "./languages";
import { OpenApiSpecConfig } from "./spec/open-api-spec-project";
/**
 * Configuration for the OpenApiGatewayTsProject
 */
export interface OpenApiGatewayTsProjectOptions extends TypeScriptProjectOptions, OpenApiSpecConfig {
    /**
     * The list of languages for which clients will be generated. A typescript client will always be generated.
     */
    readonly clientLanguages: ClientLanguage[];
    /**
     * The directory in which the OpenAPI spec should be generated, relative to the outdir of this project
     * @default "spec"
     */
    readonly specDir?: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     * @default "generated"
     */
    readonly generatedCodeDir?: string;
}
/**
 * Synthesizes a Typescript Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid open-api-gateway-ts
 */
export declare class OpenApiGatewayTsProject extends TypeScriptProject {
    /**
     * A reference to the generated typescript client
     */
    readonly generatedTypescriptClient: TypeScriptProject;
    /**
     * The directory in which the OpenAPI spec file(s) reside, relative to the project outdir
     */
    readonly specDir: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     */
    readonly generatedCodeDir: string;
    /**
     * Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated
     * typescript client when this project is used in a monorepo, and the package manager is PNPM.
     */
    readonly pnpmWorkspace?: YamlFile;
    private readonly hasParent;
    constructor(options: OpenApiGatewayTsProjectOptions);
    /**
     * @inheritDoc
     */
    postSynthesize(): void;
    /**
     * Executes commands to link the native (ie typescript) client such that updates to the generated client are reflected
     * in this project's node_modules (when not managed by a monorepo)
     * @private
     */
    private executeLinkNativeClientCommands;
}
