# codabl-python
The Codabl API is a collection of analytics tools and data integrations made for blockchain developers. In particular we offer Natural Language Processing and Anomaly detection algorithms that have been fine tune to understand text data and time series in the domain speficic setting of cryptocurrency and blockchain technology. This technology is intended to be use as building blocks to bigger applications, we offer examples on how to use them for Trading Backtesting and Smart Contract anomaly monitoring.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1
- Package version: 0.1.2
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import codabl 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import codabl
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import codabl
from codabl.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = codabl.AnomalyApi(codabl.ApiClient(configuration))
request = codabl.TimeSeries() # TimeSeries | Time Series to be analyzed, with the following format. (optional)

try:
    # Detects anomalies in historical data in batches. This endpoint uses your entire dataset as input
    api_response = api_instance.anomaly_batch(request=request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnomalyApi->anomaly_batch: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.codabl.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnomalyApi* | [**anomaly_batch**](docs/AnomalyApi.md#anomaly_batch) | **POST** /anomaly/json/detect | Detects anomalies in historical data in batches. This endpoint uses your entire dataset as input
*IntegrationsApi* | [**crypto_get_candle_data**](docs/IntegrationsApi.md#crypto_get_candle_data) | **POST** /crypto/get_candles | Downloads candle format market data
*IntegrationsApi* | [**crypto_get_exchange_assets**](docs/IntegrationsApi.md#crypto_get_exchange_assets) | **POST** /crypto/get_exchange_assets | Gets all coin pairs traded in specified exchange
*IntegrationsApi* | [**crypto_get_orderbooks**](docs/IntegrationsApi.md#crypto_get_orderbooks) | **POST** /crypto/get_orderbooks | Returns the current state of the orderbook.
*IntegrationsApi* | [**crypto_get_supported_exchanges**](docs/IntegrationsApi.md#crypto_get_supported_exchanges) | **GET** /crypto/get_supported_exchanges | Gets all cryptocurrency exchanges supported by the Codabl API
*IntegrationsApi* | [**crypto_get_ticker**](docs/IntegrationsApi.md#crypto_get_ticker) | **POST** /crypto/get_ticker | Downloads candle format market data
*LanguageApi* | [**language_get_crypto_entities**](docs/LanguageApi.md#language_get_crypto_entities) | **POST** /entity/get_crypto_entities | Extracts known crypto entities like coin names, exchanges, media from text.
*LanguageApi* | [**language_get_general_sentiment**](docs/LanguageApi.md#language_get_general_sentiment) | **POST** /sentiment/get_general_sentiment | Returns a -1 to 1 score, depending on positive/negative sentiment
*LanguageApi* | [**language_get_price_sentiment**](docs/LanguageApi.md#language_get_price_sentiment) | **POST** /language/get_price_sentiment | Sentiment analysis score using a model trained for buy signals.


## Documentation For Models

 - [CandleRequest](docs/CandleRequest.md)
 - [CandleResponse](docs/CandleResponse.md)
 - [Error](docs/Error.md)
 - [Exchange](docs/Exchange.md)
 - [ExchangeAssetsResponse](docs/ExchangeAssetsResponse.md)
 - [OHCLV](docs/OHCLV.md)
 - [OrderbookRequest](docs/OrderbookRequest.md)
 - [OrderbookResponse](docs/OrderbookResponse.md)
 - [PointTimeSeries](docs/PointTimeSeries.md)
 - [SupportedExchanges](docs/SupportedExchanges.md)
 - [Text](docs/Text.md)
 - [TickerResponse](docs/TickerResponse.md)
 - [TimeSeries](docs/TimeSeries.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



