import { Construct } from "constructs";
/**
 * Utilities class used across the different resources
 */
export declare class Utils {
    /**
     * Sanitize a string by removing upper case and replacing special characters except underscore
     * @param {string} toSanitize the string to sanitize
     */
    static stringSanitizer(toSanitize: string): string;
    /**
     * Create a random string to be used as a seed for IAM User password
     * @param {string} name the string to which to append a random string
     */
    static randomize(name: string): string;
    /**
     * Import the default IAM role used by CDK
     * @param {Construct} scope the scope to import the role into
     * @param {string} id the ID of the role in the stack
     */
    static getCdkExecRole(scope: Construct, id: string): import("aws-cdk-lib/aws-iam").IRole;
    /**
     * Import the default IAM role used for CDK deploy
     * @param {Construct} scope the scope to import the role into
     * @param {string} id the ID of the role in the stack
     */
    static getCdkDeployRole(scope: Construct, id: string): import("aws-cdk-lib/aws-iam").IRole;
    /**
     * Import the default IAM role used for CDK file publishing
     * @param {Construct} scope the scope to import the role into
     * @param {string} id the ID of the role in the stack
     */
    static getCdkFilePublishRole(scope: Construct, id: string): import("aws-cdk-lib/aws-iam").IRole;
    static readYamlDocument(path: string): string;
    /**
     * Take a document stored as string and load it as YAML
     * @param {string} document the document stored as string
     */
    static loadYaml(document: string): any;
}
