import { Construct } from 'constructs';
/**
 * The properties for SynchronousCrawler Construct.
 */
export interface SynchronousCrawlerProps {
    /**
     * The name of the Crawler to use
     */
    readonly crawlerName: string;
    /**
     * The timeout in seconds to wait for the Crawler success
     * @default - 300 seconds
     */
    readonly timeout?: number;
}
/**
 * CrawlerStartWait Construct to start an AWS Glue Crawler execution and asynchronously wait for completion
 */
export declare class SynchronousCrawler extends Construct {
    /**
    * Constructs a new instance of the DataGenerator class
    * @param {Construct} scope the Scope of the CDK Construct
    * @param {string} id the ID of the CDK Construct
    * @param {SynchronousCrawlerProps} props the CrawlerStartWait [properties]{@link SynchronousCrawlerProps}
    * @access public
    */
    constructor(scope: Construct, id: string, props: SynchronousCrawlerProps);
}
