"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const emr_eks_platform_1 = require("./emr-eks-platform");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const notebook_platform_1 = require("./notebook-platform");
// eslint-disable-next-line import/no-extraneous-dependencies,import/no-unresolved
const mockApp = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(mockApp, 'EmrEksClustereE2eTest');
const emrEks = emr_eks_platform_1.EmrEksCluster.getOrCreate(stack, {
    eksAdminRoleArn: 'arn:aws:iam::123445678912:role/gromav',
    autoscaling: emr_eks_platform_1.Autoscaler.KARPENTER,
});
const virtualCluster = emrEks.addEmrVirtualCluster(stack, {
    name: 'e2eTest',
    createNamespace: true,
    eksNamespace: 'emreks',
});
const policy = new aws_iam_1.ManagedPolicy(stack, 'MyPolicy1', {
    statements: [
        new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['s3:*'],
        }),
        new aws_iam_1.PolicyStatement({
            resources: [
                stack.formatArn({
                    account: aws_cdk_lib_1.Aws.ACCOUNT_ID,
                    region: aws_cdk_lib_1.Aws.REGION,
                    service: 'logs',
                    resource: '*',
                    arnFormat: aws_cdk_lib_1.ArnFormat.NO_RESOURCE_NAME,
                }),
            ],
            actions: [
                'logs:*',
            ],
        }),
    ],
});
const execRole = emrEks.createExecutionRole(stack, 'ExecRole', policy, 'emreks', 'emr-eks-exec-role');
const platform = new notebook_platform_1.NotebookPlatform(stack, 'platform-notebook', {
    emrEks: emrEks,
    eksNamespace: 'notebook',
    studioName: 'notebook',
    studioAuthMode: notebook_platform_1.StudioAuthMode.IAM,
});
const notebookUser = new aws_iam_1.User(stack, 'NotebookUser', { userName: 'test' });
platform.addUser([{
        iamUser: notebookUser,
        notebookManagedEndpoints: [
            {
                emrOnEksVersion: emr_eks_platform_1.EmrVersion.V6_9,
                executionPolicy: policy,
                managedEndpointName: 'notebook',
            },
        ],
    }]);
// Job config for each nodegroup
new aws_cdk_lib_1.CfnOutput(stack, 'CriticalConfig', { value: emrEks.criticalDefaultConfig });
new aws_cdk_lib_1.CfnOutput(stack, 'SharedConfig', { value: emrEks.sharedDefaultConfig });
new aws_cdk_lib_1.CfnOutput(stack, 'JobExecRole', { value: execRole.roleArn });
new aws_cdk_lib_1.CfnOutput(stack, 'VirtualClusterId', { value: virtualCluster.attrId });
//# sourceMappingURL=data:application/json;base64,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