"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.Example = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @ignore
 * // DO NOT include ignore tag, if you do TypeDoc will not include documentation of your construct
 * Example Construct to help onboarding contributors.
 * This example includes best practices for code comment/documentation generation,
 * and for default parameters pattern in CDK using Props with Optional properties
 */
class Example extends constructs_1.Construct {
    /**
     * @ignore
     * // DO NOT include ignore tag, if you do TypeDoc will not include documentation of your construct
     * Constructs a new instance of the Example class with CfnOutput.
     * CfnOutput can be customized.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {ExampleProps} props the ExampleProps properties
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        // add a fake CFN Output to the Stack
        // use an export name because the output name is defined by AWS CDK
        new aws_cdk_lib_1.CfnOutput(this, 'message', {
            exportName: props.name ? props.name : 'defaultMessage',
            value: props.value ? props.value : 'defaultValue!',
        });
    }
}
exports.Example = Example;
//# sourceMappingURL=data:application/json;base64,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