import { Provider } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
/**
* The properties for the EmrEksNodegroupAsgTagsProvider Construct class.
 * @private
*/
export interface EmrEksNodegroupAsgTagProviderProps {
    /**
     * The name of the EKS cluster
     * @private
     */
    readonly eksClusterName: string;
}
/**
 * EmrEksNodegroupAsgTagsProvider Construct implementing a custom resource provider for tagging EC2 Auto Scaling Group of EmrEksNodegroup.
 * By default EKS Managed Nodegroups are using EC2 Auto Scaling Group that are not tagged for Kubernetes Cluster Autoscaler usage.
 * If minimum number of node is 0, the Cluster Autoscaler is [not able to scale the nodegroup](https://github.com/aws/containers-roadmap/issues/724)
 */
export declare class EmrEksNodegroupAsgTagProvider extends Construct {
    /**
     * The custom resource Provider for creating custom resources
     */
    readonly provider: Provider;
    /**
     * Constructs a new instance of the ManageEnEmrEksNodegroupAsgTagsProviderdpointProvider.
     * The provider can then be used to create custom resources for tagging EC2 Auto Scaling group
     * @param { Construct} scope the Scope of the CDK Construct
     * @param id the ID of the CDK Construct
     */
    constructor(scope: Construct, id: string, props: EmrEksNodegroupAsgTagProviderProps);
}
