"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AthenaDemoSetup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_athena_1 = require("aws-cdk-lib/aws-athena");
const constructs_1 = require("constructs");
const ara_bucket_1 = require("./ara-bucket");
/**
 * AthenaDemoSetup Construct to automatically setup a new Amazon Athena Workgroup with proper configuration for out-of-the-box demo
 */
class AthenaDemoSetup extends constructs_1.Construct {
    /**
     * Constructs a new instance of the AthenaDefaultSetup class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const workgroupName = props.workgroupName || 'demo';
        // Singleton Amazon S3 bucket for Amazon Athena Query logs
        this.resultBucket = ara_bucket_1.AraBucket.getOrCreate(this, {
            bucketName: `${workgroupName}-athena-logs`,
            serverAccessLogsPrefix: `${workgroupName}-athena-logs-bucket`,
        });
        this.athenaWorkgroup = new aws_athena_1.CfnWorkGroup(this, 'athenaDemoWorkgroup', {
            name: workgroupName,
            recursiveDeleteOption: true,
            workGroupConfiguration: {
                requesterPaysEnabled: true,
                publishCloudWatchMetricsEnabled: false,
                resultConfiguration: {
                    outputLocation: this.resultBucket.s3UrlForObject('athena-console-results'),
                },
            },
        });
    }
}
exports.AthenaDemoSetup = AthenaDemoSetup;
_a = JSII_RTTI_SYMBOL_1;
AthenaDemoSetup[_a] = { fqn: "aws-analytics-reference-architecture.AthenaDemoSetup", version: "2.8.10" };
//# sourceMappingURL=data:application/json;base64,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