"""
    Delphix API Gateway

    Delphix API Gateway API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.bookmark import Bookmark
from delphix.api.gateway.model.create_bookmark_response import CreateBookmarkResponse
from delphix.api.gateway.model.list_bookmarks_response import ListBookmarksResponse
from delphix.api.gateway.model.restore_bookmark_response import RestoreBookmarkResponse


class BookmarksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_bookmark(
            self,
            bookmark,
            **kwargs
        ):
            """Create a bookmark at the current time.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bookmark(bookmark, async_req=True)
            >>> result = thread.get()

            Args:
                bookmark (Bookmark): The parameters to create a bookmark.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateBookmarkResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bookmark'] = \
                bookmark
            return self.call_with_http_info(**kwargs)

        self.create_bookmark = _Endpoint(
            settings={
                'response_type': (CreateBookmarkResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/bookmarks',
                'operation_id': 'create_bookmark',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark',
                ],
                'required': [
                    'bookmark',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark':
                        (Bookmark,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'bookmark': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_bookmark
        )

        def __delete_bookmark(
            self,
            bookmark_id,
            **kwargs
        ):
            """Delete a bookmark.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_bookmark(bookmark_id, async_req=True)
            >>> result = thread.get()

            Args:
                bookmark_id (str): The ID of the bookmark.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bookmark_id'] = \
                bookmark_id
            return self.call_with_http_info(**kwargs)

        self.delete_bookmark = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/bookmarks/{bookmarkId}',
                'operation_id': 'delete_bookmark',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark_id',
                ],
                'required': [
                    'bookmark_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bookmark_id',
                ]
            },
            root_map={
                'validations': {
                    ('bookmark_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark_id':
                        (str,),
                },
                'attribute_map': {
                    'bookmark_id': 'bookmarkId',
                },
                'location_map': {
                    'bookmark_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_bookmark
        )

        def __get_bookmark_by_id(
            self,
            bookmark_id,
            **kwargs
        ):
            """Get a bookmark by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_bookmark_by_id(bookmark_id, async_req=True)
            >>> result = thread.get()

            Args:
                bookmark_id (str): The ID of the bookmark.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Bookmark
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bookmark_id'] = \
                bookmark_id
            return self.call_with_http_info(**kwargs)

        self.get_bookmark_by_id = _Endpoint(
            settings={
                'response_type': (Bookmark,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/bookmarks/{bookmarkId}',
                'operation_id': 'get_bookmark_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark_id',
                ],
                'required': [
                    'bookmark_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bookmark_id',
                ]
            },
            root_map={
                'validations': {
                    ('bookmark_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark_id':
                        (str,),
                },
                'attribute_map': {
                    'bookmark_id': 'bookmarkId',
                },
                'location_map': {
                    'bookmark_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_bookmark_by_id
        )

        def __get_bookmarks(
            self,
            **kwargs
        ):
            """List all bookmarks.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_bookmarks(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBookmarksResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_bookmarks = _Endpoint(
            settings={
                'response_type': (ListBookmarksResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/bookmarks',
                'operation_id': 'get_bookmarks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_bookmarks
        )

        def __restore_bookmark(
            self,
            bookmark_id,
            **kwargs
        ):
            """Restore VDBs to the bookmark creation time.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.restore_bookmark(bookmark_id, async_req=True)
            >>> result = thread.get()

            Args:
                bookmark_id (str): The ID of the bookmark.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RestoreBookmarkResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bookmark_id'] = \
                bookmark_id
            return self.call_with_http_info(**kwargs)

        self.restore_bookmark = _Endpoint(
            settings={
                'response_type': (RestoreBookmarkResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/bookmarks/{bookmarkId}/restore',
                'operation_id': 'restore_bookmark',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark_id',
                ],
                'required': [
                    'bookmark_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'bookmark_id',
                ]
            },
            root_map={
                'validations': {
                    ('bookmark_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark_id':
                        (str,),
                },
                'attribute_map': {
                    'bookmark_id': 'bookmarkId',
                },
                'location_map': {
                    'bookmark_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__restore_bookmark
        )
