"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyGeneratedOutput = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class SmithyGeneratedOutput extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        const { smithyBuildConfigPath, modelPath, outputPath, gradleProjectPath } = this.options;
        // Run smithy generation
        util_1.exec(`./gradlew -p ${gradleProjectPath} generate -Pconfig=${smithyBuildConfigPath} -Pdiscover=${modelPath} -Poutput=${outputPath}`, {
            cwd: gradleProjectPath,
        });
    }
}
exports.SmithyGeneratedOutput = SmithyGeneratedOutput;
//# sourceMappingURL=data:application/json;base64,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