"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class LambdaMetrics {
    static concurrentExecutionsMaximum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'ConcurrentExecutions',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static deadLetterErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'DeadLetterErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static destinationDeliveryFailuresSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'DestinationDeliveryFailures',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static durationAverage(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Duration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static errorsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Errors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static invocationsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Invocations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static iteratorAgeAverage(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'IteratorAge',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static postRuntimeExtensionsDurationAverage(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'PostRuntimeExtensionsDuration',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static provisionedConcurrencyInvocationsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'ProvisionedConcurrencyInvocations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static provisionedConcurrencySpilloverInvocationsSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'ProvisionedConcurrencySpilloverInvocations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static provisionedConcurrencyUtilizationMaximum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'ProvisionedConcurrencyUtilization',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static provisionedConcurrentExecutionsMaximum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'ProvisionedConcurrentExecutions',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static throttlesSum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'Throttles',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static unreservedConcurrentExecutionsMaximum(dimensions) {
        return {
            namespace: 'AWS/Lambda',
            metricName: 'UnreservedConcurrentExecutions',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
}
exports.LambdaMetrics = LambdaMetrics;
//# sourceMappingURL=data:application/json;base64,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