name = "py_manager_api_test"
import requests
import json



class manager_pk_api(object):
    def __init__(self,username,password,broker):
        self.username = username
        self.password = password
        self.broker = broker
        self.refresh_token(username,password)

    def refresh_token(self,username,password):
        login_url = 'https://api-pk-data.sigmatm.com.au/api/v1/auth/login'
        token = requests.post(login_url, json = {
            "email": username,
            "password": password
        })
        self.token = token.json()['access_token']

    
    def get_alert_data(self,alert):

        link = f'https://api-pk-data.sigmatm.com.au/api/v1/alert/data?broker_id=1&alert={alert}'
        response = requests.get(link , headers={'Authorization': f'Bearer {self.token}'})
        return response.json()['data']
