"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Relative path of devcontainer file to generate
 */
const DEVCONTAINER_FILE = ".devcontainer.json";
/**
 * A development environment running VSCode in a container; used by GitHub
 * codespaces.
 */
class DevContainer extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.postCreateTasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options?.dockerImage;
        if (options?.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options?.ports) {
            this.addPorts(...options.ports);
        }
        if (options?.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        this.config = {
            image: () => this.dockerImage?.image,
            build: {
                dockerfile: () => this.dockerImage?.dockerFile,
            },
            postCreateCommand: () => this.renderTasks(),
            forwardPorts: this.ports,
            extensions: this.vscodeExtensions,
        };
        new json_1.JsonFile(this.project, DEVCONTAINER_FILE, {
            obj: this.config,
            omitEmpty: true,
        });
    }
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error("dockerImage cannot be redefined.");
        }
        this.dockerImage = image;
    }
    /**
     * Adds tasks to run when the container starts. Tasks will be run in sequence.
     *
     * @param tasks The new tasks
     */
    addTasks(...tasks) {
        this.postCreateTasks.push(...tasks);
    }
    /**
     * Adds ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports
     */
    addPorts(...ports) {
        this.ports.push(...ports);
    }
    /**
     * Adds a list of VSCode extensions that should be automatically installed
     * in the container.
     *
     * @param extensions The extension IDs
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderTasks() {
        if (this.postCreateTasks.length !== 0) {
            return this.postCreateTasks
                .map((task) => `( npx projen ${task.name} )`)
                .join(" && ");
        }
        else {
            return undefined;
        }
    }
}
exports.DevContainer = DevContainer;
_a = JSII_RTTI_SYMBOL_1;
DevContainer[_a] = { fqn: "projen.vscode.DevContainer", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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