import { Component } from "../component";
import { DevEnvironmentDockerImage, DevEnvironmentOptions, IDevEnvironment } from "../dev-env";
import { Project } from "../project";
import { Task } from "../task";
/**
 * Constructor options for the DevContainer component.
 *
 * The default docker image used for GitHub Codespaces is defined here:
 * @see https://github.com/microsoft/vscode-dev-containers/tree/master/containers/codespaces-linux
 */
export interface DevContainerOptions extends DevEnvironmentOptions {
}
/**
 * A development environment running VSCode in a container; used by GitHub
 * codespaces.
 */
export declare class DevContainer extends Component implements IDevEnvironment {
    private dockerImage;
    private readonly postCreateTasks;
    private readonly ports;
    private readonly vscodeExtensions;
    /**
     * Direct access to the devcontainer configuration (escape hatch)
     */
    readonly config: any;
    constructor(project: Project, options?: DevContainerOptions);
    addDockerImage(image: DevEnvironmentDockerImage): void;
    /**
     * Adds tasks to run when the container starts. Tasks will be run in sequence.
     *
     * @param tasks The new tasks
     */
    addTasks(...tasks: Task[]): void;
    /**
     * Adds ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports
     */
    addPorts(...ports: string[]): void;
    /**
     * Adds a list of VSCode extensions that should be automatically installed
     * in the container.
     *
     * @param extensions The extension IDs
     */
    addVscodeExtensions(...extensions: string[]): void;
    private renderTasks;
}
