"use strict";
// a builtin task that sets the "version" field of the file
// specified in OUTFILE to "0.0.0"
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const fs_extra_1 = require("fs-extra");
const outfile = process.env.OUTFILE;
if (!outfile) {
    throw new Error("OUTFILE is required");
}
if (!fs_extra_1.pathExistsSync(outfile)) {
    process.exit(0); // nothing to do
}
const content = JSON.parse(fs_1.readFileSync(outfile, "utf8"));
content.version = "0.0.0";
fs_1.writeFileSync(outfile, JSON.stringify(content, undefined, 2) + "\n");
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzZXQtdmVyc2lvbi50YXNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3JlbGVhc2UvcmVzZXQtdmVyc2lvbi50YXNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwyREFBMkQ7QUFDM0Qsa0NBQWtDOztBQUVsQywyQkFBaUQ7QUFDakQsdUNBQTBDO0FBRTFDLE1BQU0sT0FBTyxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO0FBQ3BDLElBQUksQ0FBQyxPQUFPLEVBQUU7SUFDWixNQUFNLElBQUksS0FBSyxDQUFDLHFCQUFxQixDQUFDLENBQUM7Q0FDeEM7QUFFRCxJQUFJLENBQUMseUJBQWMsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUM1QixPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCO0NBQ2xDO0FBRUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBWSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO0FBQzFELE9BQU8sQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0FBQzFCLGtCQUFhLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGEgYnVpbHRpbiB0YXNrIHRoYXQgc2V0cyB0aGUgXCJ2ZXJzaW9uXCIgZmllbGQgb2YgdGhlIGZpbGVcbi8vIHNwZWNpZmllZCBpbiBPVVRGSUxFIHRvIFwiMC4wLjBcIlxuXG5pbXBvcnQgeyByZWFkRmlsZVN5bmMsIHdyaXRlRmlsZVN5bmMgfSBmcm9tIFwiZnNcIjtcbmltcG9ydCB7IHBhdGhFeGlzdHNTeW5jIH0gZnJvbSBcImZzLWV4dHJhXCI7XG5cbmNvbnN0IG91dGZpbGUgPSBwcm9jZXNzLmVudi5PVVRGSUxFO1xuaWYgKCFvdXRmaWxlKSB7XG4gIHRocm93IG5ldyBFcnJvcihcIk9VVEZJTEUgaXMgcmVxdWlyZWRcIik7XG59XG5cbmlmICghcGF0aEV4aXN0c1N5bmMob3V0ZmlsZSkpIHtcbiAgcHJvY2Vzcy5leGl0KDApOyAvLyBub3RoaW5nIHRvIGRvXG59XG5cbmNvbnN0IGNvbnRlbnQgPSBKU09OLnBhcnNlKHJlYWRGaWxlU3luYyhvdXRmaWxlLCBcInV0ZjhcIikpO1xuY29udGVudC52ZXJzaW9uID0gXCIwLjAuMFwiO1xud3JpdGVGaWxlU3luYyhvdXRmaWxlLCBKU09OLnN0cmluZ2lmeShjb250ZW50LCB1bmRlZmluZWQsIDIpICsgXCJcXG5cIik7XG4iXX0=