"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pip = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const requirements_file_1 = require("./requirements-file");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const task_runtime_1 = require("../task-runtime");
/**
 * Manages dependencies using a requirements.txt file and the pip CLI tool.
 */
class Pip extends component_1.Component {
    constructor(project, _options = {}) {
        super(project);
        new requirements_file_1.RequirementsFile(project, "requirements.txt", {
            packageProvider: new RuntimeDependencyProvider(project),
        });
        new requirements_file_1.RequirementsFile(project, "requirements-dev.txt", {
            packageProvider: new DevDependencyProvider(project),
        });
        this.installTask = project.addTask("install", {
            description: "Install and upgrade dependencies",
        });
        this.installTask.exec("pip install --upgrade pip");
        this.installTask.exec("pip install -r requirements.txt");
        this.installTask.exec("pip install -r requirements-dev.txt");
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.RUNTIME);
    }
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.DEVENV);
    }
    /**
     * Installs dependencies (called during post-synthesis).
     */
    installDependencies() {
        this.project.logger.info("Installing dependencies...");
        const runtime = new task_runtime_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Pip = Pip;
_a = JSII_RTTI_SYMBOL_1;
Pip[_a] = { fqn: "projen.python.Pip", version: "0.67.87" };
class RuntimeDependencyProvider {
    constructor(project) {
        this.project = project;
    }
    get packages() {
        return this.project.deps.all.filter((dep) => dep.type === dependencies_1.DependencyType.RUNTIME);
    }
}
class DevDependencyProvider {
    constructor(project) {
        this.project = project;
    }
    get packages() {
        return this.project.deps.all.filter((dep) => dep.type === dependencies_1.DependencyType.DEVENV);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3B5dGhvbi9waXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSwyREFBdUQ7QUFDdkQsNENBQXlDO0FBQ3pDLGtEQUE2RDtBQUc3RCxrREFBOEM7QUFPOUM7O0dBRUc7QUFDSCxNQUFhLEdBQUksU0FBUSxxQkFBUztJQUdoQyxZQUFZLE9BQWdCLEVBQUUsV0FBdUIsRUFBRTtRQUNyRCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLG9DQUFnQixDQUFDLE9BQU8sRUFBRSxrQkFBa0IsRUFBRTtZQUNoRCxlQUFlLEVBQUUsSUFBSSx5QkFBeUIsQ0FBQyxPQUFPLENBQUM7U0FDeEQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxvQ0FBZ0IsQ0FBQyxPQUFPLEVBQUUsc0JBQXNCLEVBQUU7WUFDcEQsZUFBZSxFQUFFLElBQUkscUJBQXFCLENBQUMsT0FBTyxDQUFDO1NBQ3BELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxXQUFXLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQUU7WUFDNUMsV0FBVyxFQUFFLGtDQUFrQztTQUNoRCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ25ELElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7UUFDekQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUMvRCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLGFBQWEsQ0FBQyxJQUFZO1FBQy9CLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsNkJBQWMsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNoRSxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLGdCQUFnQixDQUFDLElBQVk7UUFDbEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSw2QkFBYyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFFRDs7T0FFRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUV2RCxNQUFNLE9BQU8sR0FBRyxJQUFJLDBCQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUNyRCxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDekMsQ0FBQzs7QUEvQ0gsa0JBZ0RDOzs7QUFFRCxNQUFNLHlCQUF5QjtJQUM3QixZQUE2QixPQUFnQjtRQUFoQixZQUFPLEdBQVAsT0FBTyxDQUFTO0lBQUcsQ0FBQztJQUNqRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUNqQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLElBQUksS0FBSyw2QkFBYyxDQUFDLE9BQU8sQ0FDN0MsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQUVELE1BQU0scUJBQXFCO0lBQ3pCLFlBQTZCLE9BQWdCO1FBQWhCLFlBQU8sR0FBUCxPQUFPLENBQVM7SUFBRyxDQUFDO0lBQ2pELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQ2pDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxHQUFHLENBQUMsSUFBSSxLQUFLLDZCQUFjLENBQUMsTUFBTSxDQUM1QyxDQUFDO0lBQ0osQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVBhY2thZ2VQcm92aWRlciwgSVB5dGhvbkRlcHMgfSBmcm9tIFwiLi9weXRob24tZGVwc1wiO1xuaW1wb3J0IHsgUmVxdWlyZW1lbnRzRmlsZSB9IGZyb20gXCIuL3JlcXVpcmVtZW50cy1maWxlXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBEZXBlbmRlbmN5LCBEZXBlbmRlbmN5VHlwZSB9IGZyb20gXCIuLi9kZXBlbmRlbmNpZXNcIjtcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tIFwiLi4vcHJvamVjdFwiO1xuaW1wb3J0IHsgVGFzayB9IGZyb20gXCIuLi90YXNrXCI7XG5pbXBvcnQgeyBUYXNrUnVudGltZSB9IGZyb20gXCIuLi90YXNrLXJ1bnRpbWVcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciBwaXBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBQaXBPcHRpb25zIHt9XG5cbi8qKlxuICogTWFuYWdlcyBkZXBlbmRlbmNpZXMgdXNpbmcgYSByZXF1aXJlbWVudHMudHh0IGZpbGUgYW5kIHRoZSBwaXAgQ0xJIHRvb2wuXG4gKi9cbmV4cG9ydCBjbGFzcyBQaXAgZXh0ZW5kcyBDb21wb25lbnQgaW1wbGVtZW50cyBJUHl0aG9uRGVwcyB7XG4gIHB1YmxpYyByZWFkb25seSBpbnN0YWxsVGFzazogVGFzaztcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBfb3B0aW9uczogUGlwT3B0aW9ucyA9IHt9KSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICBuZXcgUmVxdWlyZW1lbnRzRmlsZShwcm9qZWN0LCBcInJlcXVpcmVtZW50cy50eHRcIiwge1xuICAgICAgcGFja2FnZVByb3ZpZGVyOiBuZXcgUnVudGltZURlcGVuZGVuY3lQcm92aWRlcihwcm9qZWN0KSxcbiAgICB9KTtcbiAgICBuZXcgUmVxdWlyZW1lbnRzRmlsZShwcm9qZWN0LCBcInJlcXVpcmVtZW50cy1kZXYudHh0XCIsIHtcbiAgICAgIHBhY2thZ2VQcm92aWRlcjogbmV3IERldkRlcGVuZGVuY3lQcm92aWRlcihwcm9qZWN0KSxcbiAgICB9KTtcblxuICAgIHRoaXMuaW5zdGFsbFRhc2sgPSBwcm9qZWN0LmFkZFRhc2soXCJpbnN0YWxsXCIsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBcIkluc3RhbGwgYW5kIHVwZ3JhZGUgZGVwZW5kZW5jaWVzXCIsXG4gICAgfSk7XG4gICAgdGhpcy5pbnN0YWxsVGFzay5leGVjKFwicGlwIGluc3RhbGwgLS11cGdyYWRlIHBpcFwiKTtcbiAgICB0aGlzLmluc3RhbGxUYXNrLmV4ZWMoXCJwaXAgaW5zdGFsbCAtciByZXF1aXJlbWVudHMudHh0XCIpO1xuICAgIHRoaXMuaW5zdGFsbFRhc2suZXhlYyhcInBpcCBpbnN0YWxsIC1yIHJlcXVpcmVtZW50cy1kZXYudHh0XCIpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSBydW50aW1lIGRlcGVuZGVuY3kuXG4gICAqXG4gICAqIEBwYXJhbSBzcGVjIEZvcm1hdCBgPG1vZHVsZT5APHNlbXZlcj5gXG4gICAqL1xuICBwdWJsaWMgYWRkRGVwZW5kZW5jeShzcGVjOiBzdHJpbmcpIHtcbiAgICB0aGlzLnByb2plY3QuZGVwcy5hZGREZXBlbmRlbmN5KHNwZWMsIERlcGVuZGVuY3lUeXBlLlJVTlRJTUUpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSBkZXYgZGVwZW5kZW5jeS5cbiAgICpcbiAgICogQHBhcmFtIHNwZWMgRm9ybWF0IGA8bW9kdWxlPkA8c2VtdmVyPmBcbiAgICovXG4gIHB1YmxpYyBhZGREZXZEZXBlbmRlbmN5KHNwZWM6IHN0cmluZykge1xuICAgIHRoaXMucHJvamVjdC5kZXBzLmFkZERlcGVuZGVuY3koc3BlYywgRGVwZW5kZW5jeVR5cGUuREVWRU5WKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbnN0YWxscyBkZXBlbmRlbmNpZXMgKGNhbGxlZCBkdXJpbmcgcG9zdC1zeW50aGVzaXMpLlxuICAgKi9cbiAgcHVibGljIGluc3RhbGxEZXBlbmRlbmNpZXMoKSB7XG4gICAgdGhpcy5wcm9qZWN0LmxvZ2dlci5pbmZvKFwiSW5zdGFsbGluZyBkZXBlbmRlbmNpZXMuLi5cIik7XG5cbiAgICBjb25zdCBydW50aW1lID0gbmV3IFRhc2tSdW50aW1lKHRoaXMucHJvamVjdC5vdXRkaXIpO1xuICAgIHJ1bnRpbWUucnVuVGFzayh0aGlzLmluc3RhbGxUYXNrLm5hbWUpO1xuICB9XG59XG5cbmNsYXNzIFJ1bnRpbWVEZXBlbmRlbmN5UHJvdmlkZXIgaW1wbGVtZW50cyBJUGFja2FnZVByb3ZpZGVyIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9qZWN0OiBQcm9qZWN0KSB7fVxuICBwdWJsaWMgZ2V0IHBhY2thZ2VzKCk6IERlcGVuZGVuY3lbXSB7XG4gICAgcmV0dXJuIHRoaXMucHJvamVjdC5kZXBzLmFsbC5maWx0ZXIoXG4gICAgICAoZGVwKSA9PiBkZXAudHlwZSA9PT0gRGVwZW5kZW5jeVR5cGUuUlVOVElNRVxuICAgICk7XG4gIH1cbn1cblxuY2xhc3MgRGV2RGVwZW5kZW5jeVByb3ZpZGVyIGltcGxlbWVudHMgSVBhY2thZ2VQcm92aWRlciB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvamVjdDogUHJvamVjdCkge31cbiAgcHVibGljIGdldCBwYWNrYWdlcygpOiBEZXBlbmRlbmN5W10ge1xuICAgIHJldHVybiB0aGlzLnByb2plY3QuZGVwcy5hbGwuZmlsdGVyKFxuICAgICAgKGRlcCkgPT4gZGVwLnR5cGUgPT09IERlcGVuZGVuY3lUeXBlLkRFVkVOVlxuICAgICk7XG4gIH1cbn1cbiJdfQ==