"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptConfig = exports.TypeScriptJsxMode = exports.TypeScriptModuleResolution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 */
var TypeScriptModuleResolution;
(function (TypeScriptModuleResolution) {
    /**
     * TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     */
    TypeScriptModuleResolution["CLASSIC"] = "classic";
    /**
     * Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     */
    TypeScriptModuleResolution["NODE"] = "node";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE16"] = "node16";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE_NEXT"] = "nodenext";
})(TypeScriptModuleResolution = exports.TypeScriptModuleResolution || (exports.TypeScriptModuleResolution = {}));
/**
 * Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 */
var TypeScriptJsxMode;
(function (TypeScriptJsxMode) {
    /**
     * Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     */
    TypeScriptJsxMode["PRESERVE"] = "preserve";
    /**
     * Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     */
    TypeScriptJsxMode["REACT"] = "react";
    /**
     * Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     */
    TypeScriptJsxMode["REACT_NATIVE"] = "react-native";
    /**
     * Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     */
    TypeScriptJsxMode["REACT_JSX"] = "react-jsx";
    /**
     * Same as `REACT_JSX` with additional debug data.
     */
    TypeScriptJsxMode["REACT_JSXDEV"] = "react-jsxdev";
})(TypeScriptJsxMode = exports.TypeScriptJsxMode || (exports.TypeScriptJsxMode = {}));
class TypescriptConfig extends component_1.Component {
    constructor(project, options) {
        super(project);
        const fileName = options.fileName ?? "tsconfig.json";
        this.include = options.include ?? ["**/*.ts"];
        this.exclude = options.exclude ?? ["node_modules"];
        this.fileName = fileName;
        this.compilerOptions = options.compilerOptions;
        this.file = new json_1.JsonFile(project, fileName, {
            allowComments: true,
            obj: {
                compilerOptions: this.compilerOptions,
                include: () => this.include,
                exclude: () => this.exclude,
            },
        });
        project.npmignore?.exclude(`/${fileName}`);
    }
    addInclude(pattern) {
        this.include.push(pattern);
    }
    addExclude(pattern) {
        this.exclude.push(pattern);
    }
}
exports.TypescriptConfig = TypescriptConfig;
_a = JSII_RTTI_SYMBOL_1;
TypescriptConfig[_a] = { fqn: "projen.javascript.TypescriptConfig", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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