import { GitHub } from "./github";
import { GithubWorkflow } from "./workflows";
import { ContainerOptions, JobPermissions, JobStep, JobStepOutput, Triggers } from "./workflows-model";
import { Task } from "../task";
export interface TaskWorkflowOptions {
    /**
     * The workflow name.
     */
    readonly name: string;
    /**
     * The primary job id.
     * @default "build"
     */
    readonly jobId?: string;
    /**
     * @default - default image
     */
    readonly container?: ContainerOptions;
    /**
     * Adds an 'if' condition to the workflow.
     */
    readonly condition?: string;
    /**
     * A directory name which contains artifacts to be uploaded (e.g. `dist`).
     * If this is set, the contents of this directory will be uploaded as an
     * artifact at the end of the workflow run, even if other steps fail.
     *
     * @default - not set
     */
    readonly artifactsDirectory?: string;
    /**
     * The triggers for the workflow.
     *
     * @default - by default workflows can only be triggered by manually.
     */
    readonly triggers?: Triggers;
    /**
     * Initial steps to run before the source code checkout.
     *
     * @default - not set
     */
    readonly preCheckoutSteps?: JobStep[];
    /**
     * Override for the `with` property of the source code checkout step.
     *
     * @default - not set
     */
    readonly checkoutWith?: Record<string, any>;
    /**
     * Steps to run before the main build step.
     *
     * @default - not set
     */
    readonly preBuildSteps?: JobStep[];
    /**
     * The main task to be executed.
     */
    readonly task: Task;
    /**
     * Actions to run after the main build step.
     *
     * @default - not set
     */
    readonly postBuildSteps?: JobStep[];
    /**
     * Workflow environment variables.
     * @default {}
     */
    readonly env?: Record<string, string>;
    /**
     * Permissions for the build job.
     */
    readonly permissions: JobPermissions;
    /**
     * Mapping of job output names to values/expressions.
     *
     * @default {}
     */
    readonly outputs?: {
        [name: string]: JobStepOutput;
    };
    /**
     * The git identity to use in this workflow.
     */
    readonly gitIdentity?: GitIdentity;
    /**
     * Github Runner selection labels
     * @default ["ubuntu-latest"]
     */
    readonly runsOn?: string[];
    /**
     * Whether to download files from Git LFS for this workflow
     *
     * @default - Use the setting on the corresponding GitHub project
     */
    readonly downloadLfs?: boolean;
}
/**
 * A GitHub workflow for common build tasks within a project.
 */
export declare class TaskWorkflow extends GithubWorkflow {
    private readonly github;
    readonly jobId: string;
    readonly artifactsDirectory?: string;
    constructor(github: GitHub, options: TaskWorkflowOptions);
}
/**
 * Represents the git identity.
 */
export interface GitIdentity {
    /**
     * The name of the user.
     */
    readonly name: string;
    /**
     * The email address of the git user.
     */
    readonly email: string;
}
