import { __rest } from "tslib";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import clsx from 'clsx';
import React, { useRef } from 'react';
import InternalInput from '../input/internal';
import { getBaseProps } from '../internal/base-component';
import useForwardFocus from '../internal/hooks/forward-focus';
import { fireNonCancelableEvent } from '../internal/events';
import styles from './styles.css.js';
import LiveRegion from '../internal/components/live-region';
import { useUniqueId } from '../internal/hooks/use-unique-id';
// Debounce delay for live region (based on testing with VoiceOver)
const LIVE_REGION_DELAY = 2000;
const InternalTextFilter = React.forwardRef((_a, ref) => {
    var { filteringText, filteringAriaLabel, filteringPlaceholder, filteringClearAriaLabel, disabled, countText, onChange, onDelayedChange, __internalRootRef } = _a, rest = __rest(_a, ["filteringText", "filteringAriaLabel", "filteringPlaceholder", "filteringClearAriaLabel", "disabled", "countText", "onChange", "onDelayedChange", "__internalRootRef"]);
    const baseProps = getBaseProps(rest);
    const inputRef = useRef(null);
    useForwardFocus(ref, inputRef);
    const countTextId = useUniqueId('text-filter');
    const showResults = filteringText && countText && !disabled;
    return (React.createElement("div", Object.assign({}, baseProps, { className: clsx(baseProps.className, styles.root), ref: __internalRootRef }),
        React.createElement(InternalInput, { ref: inputRef, className: styles.input, type: "search", ariaLabel: filteringAriaLabel, placeholder: filteringPlaceholder, value: filteringText, disabled: disabled, autoComplete: false, ariaDescribedby: countTextId, clearAriaLabel: filteringClearAriaLabel, onChange: event => fireNonCancelableEvent(onChange, { filteringText: event.detail.value }), __onDelayedInput: event => fireNonCancelableEvent(onDelayedChange, { filteringText: event.detail.value }) }),
        React.createElement("span", { className: clsx(styles.results, showResults && styles['results-visible']) },
            React.createElement(LiveRegion, { delay: LIVE_REGION_DELAY, visible: true },
                React.createElement("span", { id: countTextId }, showResults ? countText : '')))));
});
export default InternalTextFilter;
//# sourceMappingURL=internal.js.map