"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const dom_1 = require("@cloudscape-design/test-utils-core/dom");
const styles_selectors_js_1 = require("../../../flashbar/styles.selectors.js");
const flash_1 = require("./flash");
class FlashbarWrapper extends dom_1.ComponentWrapper {
    /**
     * Returns the individual flashes of this flashbar.
     *
     * If the items are stacked, only the item at the top of the stack is returned.
     */
    findItems() {
        return this.findAllByClassName(styles_selectors_js_1.default['flash-list-item']).map(item => new flash_1.default(item.getElement()));
    }
}
exports.default = FlashbarWrapper;
FlashbarWrapper.rootSelector = styles_selectors_js_1.default.flashbar;
//# sourceMappingURL=index.js.map