import { __awaiter } from "tslib";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import React, { useEffect, useState } from 'react';
import Button from '../../button/internal';
import FormField from '../../form-field/internal';
import SpaceBetween from '../../space-between/internal';
import { useClickAway } from './click-away';
import styles from './styles.css.js';
// A function that does nothing
const noop = () => undefined;
export function InlineEditor({ ariaLabels, item, column, onEditEnd, submitEdit, __onRender, }) {
    var _a, _b;
    const [currentEditLoading, setCurrentEditLoading] = useState(false);
    const [currentEditValue, setCurrentEditValue] = useState();
    const cellContext = {
        currentValue: currentEditValue,
        setValue: setCurrentEditValue,
    };
    function finishEdit(cancel = false) {
        if (!cancel) {
            setCurrentEditValue(undefined);
        }
        onEditEnd();
    }
    function onSubmitClick(evt) {
        return __awaiter(this, void 0, void 0, function* () {
            evt.preventDefault();
            if (currentEditValue === undefined) {
                finishEdit();
                return;
            }
            setCurrentEditLoading(true);
            try {
                yield submitEdit(item, column, currentEditValue);
                setCurrentEditLoading(false);
                finishEdit();
            }
            catch (e) {
                setCurrentEditLoading(false);
            }
        });
    }
    function onCancel() {
        if (currentEditLoading) {
            return;
        }
        finishEdit(true);
    }
    function handleEscape(event) {
        if (event.key === 'Escape') {
            onCancel();
        }
    }
    const clickAwayRef = useClickAway(onCancel);
    useEffect(() => {
        if (__onRender) {
            const timer = setTimeout(__onRender, 1);
            return () => clearTimeout(timer);
        }
    }, [__onRender]);
    // asserting non-undefined editConfig here because this component is unreachable otherwise
    const { ariaLabel = undefined, validation = noop, errorIconAriaLabel, editingCell } = column.editConfig;
    return (React.createElement("form", { ref: clickAwayRef, onSubmit: onSubmitClick, onKeyDown: handleEscape, className: styles['body-cell-editor-form'] },
        React.createElement(FormField, { stretch: true, label: ariaLabel, __hideLabel: true, __disableGutters: true, __useReactAutofocus: true, i18nStrings: { errorIconAriaLabel }, errorText: validation(item, currentEditValue) },
            React.createElement("div", { className: styles['body-cell-editor-row'] },
                editingCell(item, cellContext),
                React.createElement("span", { className: styles['body-cell-editor-controls'] },
                    React.createElement(SpaceBetween, { direction: "horizontal", size: "xxs" },
                        !currentEditLoading ? (React.createElement(Button, { ariaLabel: (_a = ariaLabels === null || ariaLabels === void 0 ? void 0 : ariaLabels.cancelEditLabel) === null || _a === void 0 ? void 0 : _a.call(ariaLabels, column), formAction: "none", iconName: "close", variant: "inline-icon", onClick: onCancel })) : null,
                        React.createElement(Button, { ariaLabel: (_b = ariaLabels === null || ariaLabels === void 0 ? void 0 : ariaLabels.submitEditLabel) === null || _b === void 0 ? void 0 : _b.call(ariaLabels, column), formAction: "submit", iconName: "check", variant: "inline-icon", loading: currentEditLoading })))))));
}
//# sourceMappingURL=inline-editor.js.map