import React from 'react';
import useFocusVisible from '../internal/hooks/focus-visible';
import InternalIcon from '../icon/internal';
import clsx from 'clsx';
import styles from './styles.css.js';
import InternalHeader from '../header/internal';
import ScreenreaderOnly from '../internal/components/screenreader-only';
import { generateUniqueId } from '../internal/hooks/use-unique-id';
import { isDevelopment } from '../internal/is-development';
import { warnOnce } from '../internal/logging';
const ExpandableDefaultHeader = ({ id, className, onClick, ariaLabel, ariaControls, expanded, children, icon, onKeyUp, onKeyDown, }) => {
    const focusVisible = useFocusVisible();
    return (React.createElement("div", Object.assign({ id: id, role: "button", className: className, tabIndex: 0, onKeyUp: onKeyUp, onKeyDown: onKeyDown, onClick: onClick, "aria-label": ariaLabel, "aria-controls": ariaControls, "aria-expanded": expanded }, focusVisible),
        React.createElement("div", { className: styles['icon-container'] }, icon),
        children));
};
const ExpandableNavigationHeader = ({ id, className, onClick, ariaLabelledBy, ariaLabel, ariaControls, expanded, children, icon, }) => {
    const focusVisible = useFocusVisible();
    return (React.createElement("div", { id: id, className: className, onClick: onClick },
        React.createElement("button", Object.assign({ className: styles['icon-container'], "aria-labelledby": ariaLabelledBy, "aria-label": ariaLabel, "aria-controls": ariaControls, "aria-expanded": expanded }, focusVisible), icon),
        children));
};
const ExpandableContainerHeader = ({ id, className, onClick, ariaLabel, ariaControls, expanded, children, icon, headerDescription, headerCounter, headingTagOverride, onKeyUp, onKeyDown, }) => {
    const focusVisible = useFocusVisible();
    const screenreaderContentId = generateUniqueId('expandable-section-header-content-');
    return (React.createElement("div", Object.assign({ id: id, className: className, onClick: onClick }, focusVisible),
        React.createElement(InternalHeader, { variant: 'h2', description: headerDescription, counter: headerCounter, headingTagOverride: headingTagOverride },
            React.createElement("span", { className: styles['header-container-button'], role: "button", tabIndex: 0, onKeyUp: onKeyUp, onKeyDown: onKeyDown, "aria-label": ariaLabel, "aria-labelledby": ariaLabel ? undefined : screenreaderContentId, "aria-controls": ariaControls, "aria-expanded": expanded },
                React.createElement("span", { className: styles['icon-container'] }, icon),
                React.createElement("span", null, children))),
        React.createElement(ScreenreaderOnly, { id: screenreaderContentId },
            children,
            " ",
            headerCounter,
            " ",
            headerDescription)));
};
export const ExpandableSectionHeader = ({ id, className, variant, header, headerText, headerDescription, headerCounter, headingTagOverride, expanded, ariaControls, ariaLabel, ariaLabelledBy, onKeyUp, onKeyDown, onClick, }) => {
    const icon = (React.createElement(InternalIcon, { size: variant === 'container' ? 'medium' : 'normal', className: clsx(styles.icon, expanded && styles.expanded), name: "caret-down-filled" }));
    const defaultHeaderProps = {
        id: id,
        icon: icon,
        expanded: expanded,
        ariaControls: ariaControls,
        ariaLabel: ariaLabel,
        onClick: onClick,
    };
    const triggerClassName = clsx(styles.trigger, styles[`trigger-${variant}`], expanded && styles['trigger-expanded']);
    if (variant === 'navigation') {
        return (React.createElement(ExpandableNavigationHeader, Object.assign({ className: clsx(className, triggerClassName), ariaLabelledBy: ariaLabelledBy }, defaultHeaderProps), headerText !== null && headerText !== void 0 ? headerText : header));
    }
    if (variant === 'container' && headerText) {
        return (React.createElement(ExpandableContainerHeader, Object.assign({ className: clsx(className, triggerClassName, expanded && styles.expanded), headerDescription: headerDescription, headerCounter: headerCounter, headingTagOverride: headingTagOverride, onKeyUp: onKeyUp, onKeyDown: onKeyDown }, defaultHeaderProps), headerText));
    }
    if (variant === 'container' && header && isDevelopment) {
        warnOnce('ExpandableSection', 'Use `headerText` instead of `header` to provide the button within the heading for a11y.');
    }
    return (React.createElement(ExpandableDefaultHeader, Object.assign({ className: clsx(className, triggerClassName, styles.focusable, expanded && styles.expanded), onKeyUp: onKeyUp, onKeyDown: onKeyDown }, defaultHeaderProps), headerText !== null && headerText !== void 0 ? headerText : header));
};
//# sourceMappingURL=expandable-section-header.js.map