import React from 'react';
import { ButtonProps } from '../../button/interfaces';
import { togglesConfig } from '../toggles';
import { AppLayoutProps } from '../interfaces';
export interface DesktopDrawerProps {
    contentClassName: string;
    toggleClassName: string;
    closeClassName: string;
    toggleRefs: {
        toggle: React.Ref<ButtonProps.Ref>;
        close: React.Ref<ButtonProps.Ref>;
    };
    width: number;
    topOffset: number | undefined;
    bottomOffset: number | undefined;
    ariaLabels: AppLayoutProps.Labels | undefined;
    children: React.ReactNode;
    type: keyof typeof togglesConfig;
    isMobile: boolean;
    isOpen: boolean;
    onToggle: (isOpen: boolean) => void;
    onClick?: (event: React.MouseEvent) => void;
    onLoseFocus?: (event: React.FocusEvent) => void;
}
export declare function Drawer({ contentClassName, toggleClassName, closeClassName, width, type, toggleRefs, topOffset, bottomOffset, ariaLabels, children, isOpen, isMobile, onToggle, onClick, onLoseFocus, }: DesktopDrawerProps): JSX.Element;
//# sourceMappingURL=index.d.ts.map