"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocsProject = void 0;
const projen_1 = require("projen");
const languages_1 = require("../languages");
const generated_html2_docs_1 = require("./components/docs/generated-html2-docs");
const generated_markdown_docs_1 = require("./components/docs/generated-markdown-docs");
const generated_plantuml_docs_1 = require("./components/docs/generated-plantuml-docs");
/**
 * Project containing generated OpenApi docs
 */
class DocsProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        // Generate docs in all specified formats
        options.formats.forEach((format) => this.generateDocs(format, options.specPath));
    }
    /**
     * Generates the docs in the given format
     */
    generateDocs(format, specPath) {
        switch (format) {
            case languages_1.DocumentationFormat.HTML2:
                return new generated_html2_docs_1.GeneratedHtml2Docs(this, { specPath });
            case languages_1.DocumentationFormat.MARKDOWN:
                return new generated_markdown_docs_1.GeneratedMarkdownDocs(this, { specPath });
            case languages_1.DocumentationFormat.PLANTUML:
                return new generated_plantuml_docs_1.GeneratedPlantUmlDocs(this, { specPath });
            default:
                throw new Error(`Unsupported documentation format ${format}`);
        }
    }
}
exports.DocsProject = DocsProject;
//# sourceMappingURL=data:application/json;base64,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